/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jsa.safe.bugdetecter.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.tizen.web.jsa.JsaPlugin;

public class IOUtil {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static IOUtil instance = null;

    static {
        if (instance == null) {
            instance = new IOUtil();
        }
    }

    private IOUtil() {
    }

    public static IOUtil getInstance() {
        return instance;
    }

    public String execute(List<String> command) throws Exception {
        Process proc = null;
        StringBuilder contents = new StringBuilder();
        String line = null;
        BufferedReader input = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(command);
            proc = pb.start();
            input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            line = input.readLine();
            if (line != null) {
                contents.append(line);
                contents.append(LINE_SEPARATOR);
            }
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
        }
        return contents.toString().trim();
    }

    public void writeToFile(String filepath, String contents) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filepath));
            out.write(contents);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void copyJsFile(String filepath, File file) {
        InputStream input = null;
        OutputStream output = null;
        try {
            try {
                int bytesRead;
                input = FileLocator.openStream((Bundle)JsaPlugin.getDefault().getBundle(), (IPath)new Path(filepath), (boolean)false);
                output = new FileOutputStream(file);
                byte[] buf = new byte[1024];
                while ((bytesRead = input.read(buf)) > 0) {
                    output.write(buf, 0, bytesRead);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    input.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                try {
                    output.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    input.close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
                try {
                    output.close();
                }
                catch (IOException e5) {
                    e5.printStackTrace();
                }
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                output.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

