/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.traceparser;

import com.samsung.memoryanalysis.traceparser.IIDMap;
import com.samsung.memoryanalysis.traceparser.Timer;
import com.samsung.memoryanalysis.traceparser.TraceAnalysis;
import com.samsung.memoryanalysis.traceparser.TraceAnalysisRunner;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Set;

public class TracePrettyPrinter
implements TraceAnalysis<Void> {
    private Timer timer;

    @Override
    public void init(Timer timer, IIDMap iidMap) {
        this.timer = timer;
    }

    @Override
    public void declare(int iid, String name, int objectId) {
        System.out.println(String.format("declare(iid=%d, name=%s, objectId=%s, time=%d)", iid, name, objectId, this.timer.currentTime()));
    }

    @Override
    public void create(int iid, int objectId) {
        System.out.println(String.format("create(iid=%d, objectId=%s, time=%d)", iid, objectId, this.timer.currentTime()));
    }

    @Override
    public void createFun(int iid, int objectId, int prototypeId, int functionEnterIID, Set<String> namesReferencedInClosure) {
        System.out.println(String.format("create(iid=%d, objectId=%s, prototypeId = %d, functionEnterIID=%d,namesReferencedInClosure = %s, time=%d)", iid, objectId, prototypeId, functionEnterIID, namesReferencedInClosure.toString(), this.timer.currentTime()));
    }

    @Override
    public void putField(int iid, int baseId, String offset, int objectId) {
        System.out.println(String.format("putField(iid=%d, baseId=%d, offset=%s, objectId=%s, time=%d)", iid, baseId, offset, objectId, this.timer.currentTime()));
    }

    @Override
    public void write(int iid, String name, int objectId) {
        System.out.println(String.format("write(iid=%d, name=%s, objectId=%s, time=%d)", iid, name, objectId, this.timer.currentTime()));
    }

    @Override
    public void lastUse(int objectId, int iid, int time) {
        System.out.println(String.format("lastUse(objectId=%d, iid=%d, time=%d)", objectId, iid, time));
    }

    @Override
    public void functionEnter(int iid, int functionId, int callSiteIID) {
        System.out.println(String.format("functionEnter(iid = %d, functionId = %d, callSiteIID = %d, time = %d)", iid, functionId, callSiteIID, this.timer.currentTime()));
    }

    @Override
    public void functionExit(int iid) {
        System.out.println(String.format("functionExit(iid = %d, time = %d)", iid, this.timer.currentTime()));
    }

    @Override
    public void topLevelFlush(int iid) {
        System.out.printf("topLevelFlush(iid = %d)\n", iid);
    }

    @Override
    public Void endExecution() {
        return null;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        System.out.println(new File(args[0]).getAbsolutePath());
        if (args.length != 1) {
            System.out.println("Specify a trace " + args.length);
            System.exit(1);
        }
        TraceAnalysisRunner t = new TraceAnalysisRunner(new FileInputStream(args[0]), null, new File(args[0]).getParentFile());
        t.runAnalysis(new TracePrettyPrinter());
    }

    @Override
    public void updateIID(int objId, int newIID) {
        System.out.println(String.format("updateIID(objId = %d, newIID = %d, time = %d)", objId, newIID, this.timer.currentTime()));
    }

    @Override
    public void debug(int iid, int oid) {
        System.out.printf("debug(%d,%d)\n", iid, oid);
    }

    @Override
    public void returnStmt(int retVal) {
        System.out.printf("return(%d)\n", retVal);
    }

    @Override
    public void createDomNode(int iid, int o) {
        System.out.printf("createDomNode(iid = %d, objectId = %d\n", iid, o);
    }

    @Override
    public void addDOMChild(int parent, int child) {
        System.out.printf("addDOMChild(parent = %d, child = %d\n", parent, child);
    }

    @Override
    public void removeDOMChild(int parent, int child) {
        System.out.printf("removeDOMChild(parent = %d, child = %d\n", parent, child);
    }

    @Override
    public void addToChildSet(int iid, int parent, String name, int child) {
        System.out.println(String.format("addToChildSet(iid=%d, parent=%d, name=%s, child=%s, time=%d)", iid, parent, name, child, this.timer.currentTime()));
    }

    @Override
    public void removeFromChildSet(int iid, int parent, String name, int child) {
        System.out.println(String.format("removeFromChildSet(iid=%d, parent=%d, name=%s, child=%s, time=%d)", iid, parent, name, child, this.timer.currentTime()));
    }

    @Override
    public void domRoot(int nodeId) {
        System.out.println(String.format("domRoot(nodeId=%d, time=%d)", nodeId, this.timer.currentTime()));
    }

    @Override
    public void scriptEnter(int iid, String filename) {
        System.out.println(String.format("scriptEnter(iid=%d, filename=%s, time=%d)", iid, filename, this.timer.currentTime()));
    }

    @Override
    public void scriptExit(int iid) {
        System.out.println(String.format("scriptExit(iid=%d, time=%d)", iid, this.timer.currentTime()));
    }
}

