/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.ComposedIterable;
import edu.rice.cs.plt.iter.EmptyIterable;
import edu.rice.cs.plt.iter.EmptyIterator;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.ReadOnlyIterator;
import edu.rice.cs.plt.iter.SingletonIterator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermutationIterator<T>
extends ReadOnlyIterator<Iterable<T>> {
    private final Iterable<? extends T> _original;
    private final Iterator<? extends T> _elements;
    private T _element;
    private int _elementIndex;
    private Iterator<Iterable<T>> _restPermutations;

    public PermutationIterator(Iterable<? extends T> original) {
        this._original = original;
        this._elements = this._original.iterator();
        this._elementIndex = -1;
        this._restPermutations = IterUtil.isEmpty(this._original) ? SingletonIterator.make(EmptyIterable.make()) : EmptyIterator.make();
    }

    @Override
    public boolean hasNext() {
        return this._restPermutations.hasNext() || this._elements.hasNext();
    }

    @Override
    public Iterable<T> next() {
        if (IterUtil.isEmpty(this._original)) {
            return this._restPermutations.next();
        }
        if (!this._restPermutations.hasNext()) {
            this._element = this._elements.next();
            ++this._elementIndex;
            this._restPermutations = new PermutationIterator<T>(this.makeRest(this._elementIndex));
        }
        return new ComposedIterable<T>(this._element, this._restPermutations.next());
    }

    private Iterable<T> makeRest(int skipIndex) {
        AbstractIterable result = EmptyIterable.make();
        int i = 0;
        for (T e : this._original) {
            if (i != skipIndex) {
                result = new ComposedIterable(result, e);
            }
            ++i;
        }
        return result;
    }

    public static <T> PermutationIterator<T> make(Iterable<? extends T> original) {
        return new PermutationIterator<T>(original);
    }
}

