/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.canvas;

import com.mxgraph.canvas.mxBasicCanvas;
import com.mxgraph.shape.mxActorShape;
import com.mxgraph.shape.mxArrowShape;
import com.mxgraph.shape.mxCloudShape;
import com.mxgraph.shape.mxConnectorShape;
import com.mxgraph.shape.mxCurveShape;
import com.mxgraph.shape.mxCylinderShape;
import com.mxgraph.shape.mxDefaultTextShape;
import com.mxgraph.shape.mxDoubleEllipseShape;
import com.mxgraph.shape.mxEllipseShape;
import com.mxgraph.shape.mxHexagonShape;
import com.mxgraph.shape.mxHtmlTextShape;
import com.mxgraph.shape.mxIShape;
import com.mxgraph.shape.mxITextShape;
import com.mxgraph.shape.mxImageShape;
import com.mxgraph.shape.mxLabelShape;
import com.mxgraph.shape.mxLineShape;
import com.mxgraph.shape.mxRectangleShape;
import com.mxgraph.shape.mxRhombusShape;
import com.mxgraph.shape.mxStencilRegistry;
import com.mxgraph.shape.mxSwimlaneShape;
import com.mxgraph.shape.mxTriangleShape;
import com.mxgraph.swing.util.mxSwingConstants;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.CellRendererPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxGraphics2DCanvas
extends mxBasicCanvas {
    public static final String TEXT_SHAPE_DEFAULT = "default";
    public static final String TEXT_SHAPE_HTML = "html";
    public static int IMAGE_SCALING = 4;
    protected static Map<String, mxIShape> shapes = new HashMap<String, mxIShape>();
    protected static Map<String, mxITextShape> textShapes = new HashMap<String, mxITextShape>();
    protected CellRendererPane rendererPane;
    protected Graphics2D g;

    public mxGraphics2DCanvas() {
        this(null);
    }

    public mxGraphics2DCanvas(Graphics2D g) {
        this.g = g;
        try {
            this.rendererPane = new CellRendererPane();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void putShape(String name, mxIShape shape) {
        shapes.put(name, shape);
    }

    public mxIShape getShape(Map<String, Object> style) {
        String name = mxUtils.getString(style, mxConstants.STYLE_SHAPE, null);
        mxIShape shape = shapes.get(name);
        if (shape == null && name != null) {
            shape = mxStencilRegistry.getStencil(name);
        }
        return shape;
    }

    public static void putTextShape(String name, mxITextShape shape) {
        textShapes.put(name, shape);
    }

    public mxITextShape getTextShape(Map<String, Object> style, boolean html) {
        String name = html ? TEXT_SHAPE_HTML : TEXT_SHAPE_DEFAULT;
        return textShapes.get(name);
    }

    public CellRendererPane getRendererPane() {
        return this.rendererPane;
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    public void setGraphics(Graphics2D g) {
        this.g = g;
    }

    @Override
    public Object drawCell(mxCellState state) {
        Map<String, Object> style = state.getStyle();
        mxIShape shape = this.getShape(style);
        if (this.g != null && shape != null) {
            float opacity = mxUtils.getFloat(style, mxConstants.STYLE_OPACITY, 100.0f);
            Graphics2D previousGraphics = this.g;
            this.g = this.createTemporaryGraphics(style, opacity, state);
            shape.paintShape(this, state);
            this.g.dispose();
            this.g = previousGraphics;
        }
        return shape;
    }

    @Override
    public Object drawLabel(String text, mxCellState state, boolean html) {
        Map<String, Object> style = state.getStyle();
        mxITextShape shape = this.getTextShape(style, html);
        if (this.g != null && shape != null && this.drawLabels && text != null && text.length() > 0) {
            float opacity = mxUtils.getFloat(style, mxConstants.STYLE_TEXT_OPACITY, 100.0f);
            Graphics2D previousGraphics = this.g;
            this.g = this.createTemporaryGraphics(style, opacity, null);
            Color bg = mxUtils.getColor(style, mxConstants.STYLE_LABEL_BACKGROUNDCOLOR);
            Color border = mxUtils.getColor(style, mxConstants.STYLE_LABEL_BORDERCOLOR);
            this.paintRectangle(state.getLabelBounds().getRectangle(), bg, border);
            shape.paintShape(this, text, state, style);
            this.g.dispose();
            this.g = previousGraphics;
        }
        return shape;
    }

    public void drawImage(Rectangle bounds, String imageUrl) {
        this.drawImage(bounds, imageUrl, PRESERVE_IMAGE_ASPECT, false, false);
    }

    public void drawImage(Rectangle bounds, String imageUrl, boolean preserveAspect, boolean flipH, boolean flipV) {
        BufferedImage img;
        if (imageUrl != null && bounds.getWidth() > 0.0 && bounds.getHeight() > 0.0 && (img = this.loadImage(imageUrl)) != null) {
            Image scaledImage;
            int h;
            int w;
            int x = bounds.x;
            int y = bounds.y;
            Dimension size = this.getImageSize(img);
            if (preserveAspect) {
                double s = Math.min((double)bounds.width / (double)size.width, (double)bounds.height / (double)size.height);
                w = (int)((double)size.width * s);
                h = (int)((double)size.height * s);
                x += (bounds.width - w) / 2;
                y += (bounds.height - h) / 2;
            } else {
                w = bounds.width;
                h = bounds.height;
            }
            Image image = scaledImage = w == size.width && h == size.height ? img : img.getScaledInstance(w, h, IMAGE_SCALING);
            if (scaledImage != null) {
                AffineTransform af = null;
                if (flipH || flipV) {
                    af = this.g.getTransform();
                    int sx = 1;
                    int sy = 1;
                    int dx = 0;
                    int dy = 0;
                    if (flipH) {
                        sx = -1;
                        dx = -w - 2 * x;
                    }
                    if (flipV) {
                        sy = -1;
                        dy = -h - 2 * y;
                    }
                    this.g.scale(sx, sy);
                    this.g.translate(dx, dy);
                }
                this.drawImageImpl(scaledImage, x, y);
                if (af != null) {
                    this.g.setTransform(af);
                }
            }
        }
    }

    protected void drawImageImpl(Image image, int x, int y) {
        this.g.drawImage(image, x, y, null);
    }

    protected Dimension getImageSize(Image image) {
        return new Dimension(image.getWidth(null), image.getHeight(null));
    }

    public void paintPolyline(mxPoint[] points, boolean rounded) {
        if (points != null && points.length > 1) {
            mxPoint pt = points[0];
            mxPoint pe = points[points.length - 1];
            double arcSize = mxConstants.LINE_ARCSIZE * this.scale;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)pt.getX(), (float)pt.getY());
            for (int i = 1; i < points.length - 1; ++i) {
                mxPoint tmp = points[i];
                double dx = pt.getX() - tmp.getX();
                double dy = pt.getY() - tmp.getY();
                if (rounded && i < points.length - 1 && (dx != 0.0 || dy != 0.0)) {
                    double dist = Math.sqrt(dx * dx + dy * dy);
                    double nx1 = dx * Math.min(arcSize, dist / 2.0) / dist;
                    double ny1 = dy * Math.min(arcSize, dist / 2.0) / dist;
                    double x1 = tmp.getX() + nx1;
                    double y1 = tmp.getY() + ny1;
                    path.lineTo((float)x1, (float)y1);
                    mxPoint next = points[i + 1];
                    dx = next.getX() - tmp.getX();
                    dy = next.getY() - tmp.getY();
                    dist = Math.max(1.0, Math.sqrt(dx * dx + dy * dy));
                    double nx2 = dx * Math.min(arcSize, dist / 2.0) / dist;
                    double ny2 = dy * Math.min(arcSize, dist / 2.0) / dist;
                    double x2 = tmp.getX() + nx2;
                    double y2 = tmp.getY() + ny2;
                    path.quadTo((float)tmp.getX(), (float)tmp.getY(), (float)x2, (float)y2);
                    tmp = new mxPoint(x2, y2);
                } else {
                    path.lineTo((float)tmp.getX(), (float)tmp.getY());
                }
                pt = tmp;
            }
            path.lineTo((float)pe.getX(), (float)pe.getY());
            this.g.draw(path);
        }
    }

    public void paintRectangle(Rectangle bounds, Color background, Color border) {
        if (background != null) {
            this.g.setColor(background);
            this.fillShape(bounds);
        }
        if (border != null) {
            this.g.setColor(border);
            this.g.draw(bounds);
        }
    }

    public void fillShape(Shape shape) {
        this.fillShape(shape, false);
    }

    public void fillShape(Shape shape, boolean shadow) {
        int shadowOffsetY;
        int shadowOffsetX = shadow ? mxConstants.SHADOW_OFFSETX : 0;
        int n = shadowOffsetY = shadow ? mxConstants.SHADOW_OFFSETY : 0;
        if (shadow) {
            Paint p = this.g.getPaint();
            Color previousColor = this.g.getColor();
            this.g.setColor(mxSwingConstants.SHADOW_COLOR);
            this.g.translate(shadowOffsetX, shadowOffsetY);
            this.fillShape(shape, false);
            this.g.translate(-shadowOffsetX, -shadowOffsetY);
            this.g.setColor(previousColor);
            this.g.setPaint(p);
        }
        this.g.fill(shape);
    }

    public Stroke createStroke(Map<String, Object> style) {
        double width = (double)mxUtils.getFloat(style, mxConstants.STYLE_STROKEWIDTH, 1.0f) * this.scale;
        boolean dashed = mxUtils.isTrue(style, mxConstants.STYLE_DASHED);
        if (dashed) {
            float[] dashPattern = mxUtils.getFloatArray(style, mxConstants.STYLE_DASH_PATTERN, mxConstants.DEFAULT_DASHED_PATTERN, " ");
            float[] scaledDashPattern = new float[dashPattern.length];
            for (int i = 0; i < dashPattern.length; ++i) {
                scaledDashPattern[i] = (float)((double)dashPattern[i] * this.scale * width);
            }
            return new BasicStroke((float)width, 0, 0, 10.0f, scaledDashPattern, 0.0f);
        }
        return new BasicStroke((float)width);
    }

    public Paint createFillPaint(mxRectangle bounds, Map<String, Object> style) {
        Color gradientColor;
        Color fillColor = mxUtils.getColor(style, mxConstants.STYLE_FILLCOLOR);
        GradientPaint fillPaint = null;
        if (fillColor != null && (gradientColor = mxUtils.getColor(style, mxConstants.STYLE_GRADIENTCOLOR)) != null) {
            String gradientDirection = mxUtils.getString(style, mxConstants.STYLE_GRADIENT_DIRECTION);
            float x1 = (float)bounds.getX();
            float y1 = (float)bounds.getY();
            float x2 = (float)bounds.getX();
            float y2 = (float)bounds.getY();
            if (gradientDirection == null || gradientDirection.equals("south")) {
                y2 = (float)(bounds.getY() + bounds.getHeight());
            } else if (gradientDirection.equals("east")) {
                x2 = (float)(bounds.getX() + bounds.getWidth());
            } else if (gradientDirection.equals("north")) {
                y1 = (float)(bounds.getY() + bounds.getHeight());
            } else if (gradientDirection.equals("west")) {
                x1 = (float)(bounds.getX() + bounds.getWidth());
            }
            fillPaint = new GradientPaint(x1, y1, fillColor, x2, y2, gradientColor, true);
        }
        return fillPaint;
    }

    public Graphics2D createTemporaryGraphics(Map<String, Object> style, float opacity, mxRectangle bounds) {
        double rotation;
        Graphics2D temporaryGraphics = (Graphics2D)this.g.create();
        temporaryGraphics.translate(this.translate.x, this.translate.y);
        if (bounds != null && (rotation = mxUtils.getDouble(style, mxConstants.STYLE_ROTATION, 0.0)) != 0.0) {
            temporaryGraphics.rotate(Math.toRadians(rotation), bounds.getCenterX(), bounds.getCenterY());
        }
        if (opacity != 100.0f) {
            temporaryGraphics.setComposite(AlphaComposite.getInstance(3, opacity / 100.0f));
        }
        return temporaryGraphics;
    }

    static {
        mxGraphics2DCanvas.putShape("actor", new mxActorShape());
        mxGraphics2DCanvas.putShape("arrow", new mxArrowShape());
        mxGraphics2DCanvas.putShape("cloud", new mxCloudShape());
        mxGraphics2DCanvas.putShape("connector", new mxConnectorShape());
        mxGraphics2DCanvas.putShape("cylinder", new mxCylinderShape());
        mxGraphics2DCanvas.putShape("curve", new mxCurveShape());
        mxGraphics2DCanvas.putShape("doubleEllipse", new mxDoubleEllipseShape());
        mxGraphics2DCanvas.putShape("ellipse", new mxEllipseShape());
        mxGraphics2DCanvas.putShape("hexagon", new mxHexagonShape());
        mxGraphics2DCanvas.putShape("image", new mxImageShape());
        mxGraphics2DCanvas.putShape("label", new mxLabelShape());
        mxGraphics2DCanvas.putShape("line", new mxLineShape());
        mxGraphics2DCanvas.putShape("rectangle", new mxRectangleShape());
        mxGraphics2DCanvas.putShape("rhombus", new mxRhombusShape());
        mxGraphics2DCanvas.putShape("swimlane", new mxSwimlaneShape());
        mxGraphics2DCanvas.putShape("triangle", new mxTriangleShape());
        mxGraphics2DCanvas.putTextShape(TEXT_SHAPE_DEFAULT, new mxDefaultTextShape());
        mxGraphics2DCanvas.putTextShape(TEXT_SHAPE_HTML, new mxHtmlTextShape());
    }
}

