/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.referencecounter;

import com.ibm.wala.util.collections.HashMapFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccessPath {
    public static final AccessPath NO_PATH = new AccessPath();
    public final String target;
    public final List<AccessPathElement> path;

    public AccessPath(String target, List<AccessPathElement> path) {
        this.target = target;
        this.path = path;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (AccessPathElement elm : this.path) {
            b.append(elm.node);
            b.append("[").append(elm.prop).append("]->");
        }
        b.append(this.target);
        return b.toString();
    }

    private AccessPath() {
        this.target = null;
        this.path = null;
    }

    public Map<String, Object> toMap() {
        HashMap res = HashMapFactory.make((int)2);
        ArrayList<Map<String, Object>> pathMaps = new ArrayList<Map<String, Object>>();
        for (AccessPathElement g : this.path) {
            pathMaps.add(g.toMap());
        }
        res.put("path", pathMaps);
        res.put("target", this.target.toString());
        return res;
    }

    public static class AccessPathElement {
        public final String node;
        public final String prop;

        public AccessPathElement(String prop, String node) {
            this.prop = prop;
            this.node = node;
        }

        public Map<String, Object> toMap() {
            HashMap res = HashMapFactory.make();
            res.put("object", this.node);
            res.put("property", this.prop);
            return res;
        }
    }
}

