/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.referencecounter;

import com.samsung.memoryanalysis.context.Context;
import com.samsung.memoryanalysis.io.AbstractAsyncTraceWriter;
import com.samsung.memoryanalysis.referencecounter.UnreachabilityAwareAnalysis;
import com.samsung.memoryanalysis.traceparser.IIDMap;
import com.samsung.memoryanalysis.traceparser.Timer;
import com.samsung.memoryanalysis.traceparser.TraceAnalysisRunner;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;

public class UnreachabilityTraceWriter
implements UnreachabilityAwareAnalysis<UnreachAsyncWriter> {
    private final UnreachAsyncWriter out;
    private Timer timer;
    private long counter = 0L;

    public UnreachabilityTraceWriter(Path path) throws IOException {
        this.out = new UnreachAsyncWriter(path);
    }

    @Override
    public void init(Timer t, IIDMap iidMap) {
        this.timer = t;
    }

    private void updateCounter(int entryType) {
        if (entryType != TraceAnalysisRunner.TraceEntry.UNREACHABLE.ordinal()) {
            assert (this.timer.currentTime() == this.counter);
            ++this.counter;
        }
    }

    @Override
    public void functionEnter(int iid, int funId, int callSiteIID, Context newContext, long time) {
        this.out.start(TraceAnalysisRunner.TraceEntry.FUNCTION_ENTER.ordinal(), iid).write(funId).writeEnd(callSiteIID);
    }

    @Override
    public void functionExit(int iid, Context functionContext, Set<String> unReferenced, long time) {
        this.out.start(TraceAnalysisRunner.TraceEntry.FUNCTION_EXIT.ordinal()).writeEnd(iid);
    }

    @Override
    public void create(int iid, int objectId, long time, boolean isDom) {
        this.out.start(TraceAnalysisRunner.TraceEntry.CREATE_OBJ.ordinal(), iid).writeEnd(objectId);
    }

    @Override
    public void createFun(int iid, int objectId, int prototypeId, int functionEnterIID, Set<String> namesReferencedByClosures, Context context, long time) {
        this.out.start(TraceAnalysisRunner.TraceEntry.CREATE_FUN.ordinal(), iid).write(functionEnterIID).writeEnd(objectId);
    }

    @Override
    public void unreachableObject(int iid, int objectId, long time, int shallowSize) {
        assert (time <= this.counter);
        this.out.start(TraceAnalysisRunner.TraceEntry.UNREACHABLE.ordinal(), iid).write(objectId).writeEnd(time);
    }

    @Override
    public void unreachableContext(int iid, Context ctx, long time) {
    }

    @Override
    public void lastUse(int objectId, int iid, long time) {
        this.out.start(TraceAnalysisRunner.TraceEntry.LAST_USE.ordinal(), objectId).write(time).writeEnd(iid);
    }

    @Override
    public UnreachAsyncWriter endExecution(long time) {
        return this.out;
    }

    @Override
    public void domRoot(int nodeId) {
        this.out.start(TraceAnalysisRunner.TraceEntry.DOM_ROOT.ordinal()).writeEnd(nodeId);
    }

    @Override
    public void addDOMChild(int parentId, int childId, long time) {
        this.out.start(TraceAnalysisRunner.TraceEntry.ADD_DOM_CHILD.ordinal(), parentId).writeEnd(childId);
    }

    @Override
    public void removeDOMChild(int parentId, int childId, long time) {
        this.out.start(TraceAnalysisRunner.TraceEntry.REMOVE_DOM_CHILD.ordinal(), parentId).writeEnd(childId);
    }

    @Override
    public void putField(int iid, int baseId, String offset, int objectId) {
        this.out.start(TraceAnalysisRunner.TraceEntry.PUTFIELD.ordinal(), iid).write(baseId).write(offset).writeEnd(objectId);
    }

    @Override
    public void write(int iid, String name, int objectId) {
        this.out.start(TraceAnalysisRunner.TraceEntry.WRITE.ordinal(), iid).write(name).writeEnd(objectId);
    }

    @Override
    public void declare(int iid, String name, int objectId) {
        this.out.start(TraceAnalysisRunner.TraceEntry.DECLARE.ordinal(), iid).write(name).writeEnd(objectId);
    }

    @Override
    public void updateIID(int objId, int newIID) {
        this.out.start(TraceAnalysisRunner.TraceEntry.UPDATE_IID.ordinal(), objId).writeEnd(newIID);
    }

    @Override
    public void returnStmt(int objId) {
        this.out.start(TraceAnalysisRunner.TraceEntry.RETURN.ordinal()).writeEnd(objId);
    }

    @Override
    public void debug(int iid, int oid) {
        this.out.start(TraceAnalysisRunner.TraceEntry.DEBUG.ordinal(), iid).writeEnd(oid);
    }

    @Override
    public void scriptEnter(int iid, String filename) {
        this.out.start(TraceAnalysisRunner.TraceEntry.SCRIPT_ENTER.ordinal(), iid).writeEnd(filename);
    }

    @Override
    public void scriptExit(int iid) {
        this.out.start(TraceAnalysisRunner.TraceEntry.SCRIPT_EXIT.ordinal()).writeEnd(iid);
    }

    @Override
    public void topLevelFlush(int iid) {
        this.out.start(TraceAnalysisRunner.TraceEntry.TOP_LEVEL_FLUSH.ordinal()).writeEnd(iid);
    }

    @Override
    public void addToChildSet(int iid, int parentId, String name, int childId) {
        this.out.start(TraceAnalysisRunner.TraceEntry.ADD_TO_CHILD_SET.ordinal(), iid).write(parentId).write(name).writeEnd(childId);
    }

    @Override
    public void removeFromChildSet(int iid, int parentId, String name, int childId) {
        this.out.start(TraceAnalysisRunner.TraceEntry.REMOVE_FROM_CHILD_SET.ordinal(), iid).write(parentId).write(name).writeEnd(childId);
    }

    public class UnreachAsyncWriter
    extends AbstractAsyncTraceWriter {
        public UnreachAsyncWriter(Path path) throws IOException {
            super(path);
        }

        public UnreachAsyncWriter start(int entryType, int iid) {
            UnreachabilityTraceWriter.this.updateCounter(entryType);
            this.builder.append("[");
            this.builder.append(entryType);
            this.builder.append(",");
            this.builder.append(iid);
            this.builder.append(",");
            return this;
        }

        public UnreachAsyncWriter start(int entryType) {
            UnreachabilityTraceWriter.this.updateCounter(entryType);
            this.builder.append("[");
            this.builder.append(entryType);
            this.builder.append(",");
            return this;
        }

        public UnreachAsyncWriter write(int i) {
            this.builder.append(i);
            this.builder.append(",");
            return this;
        }

        public void writeEnd(int i) {
            this.builder.append(i);
            this.builder.append("]\n");
            this.flushIfNeeded();
        }

        public void writeEnd(long time) {
            this.builder.append(time);
            this.builder.append("]\n");
            this.flushIfNeeded();
        }

        public UnreachAsyncWriter write(long time) {
            this.builder.append(time);
            this.builder.append(",");
            return this;
        }

        public UnreachAsyncWriter write(String str) {
            this.builder.append("\"");
            this.builder.append(str);
            this.builder.append("\",");
            return this;
        }

        public void writeEnd(String str) {
            this.builder.append("\"");
            this.builder.append(str);
            this.builder.append("\"]\n");
            this.flushIfNeeded();
        }
    }
}

