/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import java.math.BigInteger;
import kr.ac.kaist.jsaf.nodes.ASTSpanInfo;
import kr.ac.kaist.jsaf.nodes.AbstractNodeVisitor;
import kr.ac.kaist.jsaf.nodes.AbstractNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.NodeVisitor;
import kr.ac.kaist.jsaf.nodes.NodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.NumberLiteral;
import kr.ac.kaist.jsaf.nodes.TreeWalker;

public class IntLiteral
extends NumberLiteral {
    private final BigInteger _intVal;
    private final int _radix;

    public IntLiteral(ASTSpanInfo in_info, BigInteger in_intVal, int in_radix) {
        super(in_info);
        if (in_intVal == null) {
            throw new IllegalArgumentException("Parameter 'intVal' to the IntLiteral constructor was null");
        }
        this._intVal = in_intVal;
        this._radix = in_radix;
    }

    public final BigInteger getIntVal() {
        return this._intVal;
    }

    public final int getRadix() {
        return this._radix;
    }

    @Override
    public <RetType> RetType accept(AbstractNodeVisitor<RetType> visitor) {
        return visitor.forIntLiteral(this);
    }

    @Override
    public <RetType> RetType accept(NodeVisitor<RetType> visitor) {
        return visitor.forIntLiteral(this);
    }

    @Override
    public void accept(AbstractNodeVisitor_void visitor) {
        visitor.forIntLiteral(this);
    }

    @Override
    public void accept(NodeVisitor_void visitor) {
        visitor.forIntLiteral(this);
    }

    public boolean equals(Object obj) {
        int casted_radix;
        BigInteger casted_intVal;
        ASTSpanInfo casted_info;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        IntLiteral casted = (IntLiteral)obj;
        ASTSpanInfo temp_info = this.getInfo();
        if (temp_info != (casted_info = casted.getInfo()) && !temp_info.equals(casted_info)) {
            return false;
        }
        BigInteger temp_intVal = this.getIntVal();
        if (temp_intVal != (casted_intVal = casted.getIntVal()) && !temp_intVal.equals(casted_intVal)) {
            return false;
        }
        int temp_radix = this.getRadix();
        return temp_radix == (casted_radix = casted.getRadix());
    }

    @Override
    public int generateHashCode() {
        int code = this.getClass().hashCode();
        ASTSpanInfo temp_info = this.getInfo();
        code ^= temp_info.hashCode();
        BigInteger temp_intVal = this.getIntVal();
        code ^= temp_intVal.hashCode();
        int temp_radix = this.getRadix();
        return code ^= temp_radix;
    }

    protected IntLiteral() {
        this._intVal = null;
        this._radix = 0;
    }

    @Override
    public void walk(TreeWalker w) {
        if (w.visitNode(this, "IntLiteral", 3)) {
            int temp_radix;
            BigInteger temp_intVal;
            ASTSpanInfo temp_info = this.getInfo();
            if (w.visitNodeField("info", temp_info)) {
                temp_info.walk(w);
                w.endNodeField("info", temp_info);
            }
            if (w.visitNodeField("intVal", temp_intVal = this.getIntVal())) {
                w.visitUnknownObject(temp_intVal);
                w.endNodeField("intVal", temp_intVal);
            }
            if (w.visitNodeField("radix", temp_radix = this.getRadix())) {
                w.visitInt(temp_radix);
                w.endNodeField("radix", temp_radix);
            }
            w.endNode(this, "IntLiteral", 3);
        }
    }
}

