/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import java.util.Collections;
import java.util.List;
import kr.ac.kaist.jsaf.nodes.TreeWalker;
import kr.ac.kaist.jsaf.nodes.WDefinition;
import kr.ac.kaist.jsaf.nodes.WEAttribute;
import kr.ac.kaist.jsaf.nodes.WIDLVisitor;
import kr.ac.kaist.jsaf.nodes.WIDLVisitor_void;
import kr.ac.kaist.jsaf.nodes.WNodeVisitor;
import kr.ac.kaist.jsaf.nodes.WNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.WString;
import kr.ac.kaist.jsaf.nodes_util.SpanInfo;

public class WEnum
extends WDefinition {
    private final String _name;
    private final List<WString> _enumValueList;

    public WEnum(SpanInfo in_info, List<WEAttribute> in_attrs, String in_name, List<WString> in_enumValueList) {
        super(in_info, in_attrs);
        if (in_name == null) {
            throw new IllegalArgumentException("Parameter 'name' to the WEnum constructor was null");
        }
        this._name = in_name.intern();
        if (in_enumValueList == null) {
            throw new IllegalArgumentException("Parameter 'enumValueList' to the WEnum constructor was null");
        }
        this._enumValueList = in_enumValueList;
    }

    public WEnum(SpanInfo in_info, String in_name, List<WString> in_enumValueList) {
        this(in_info, Collections.emptyList(), in_name, in_enumValueList);
    }

    public final String getName() {
        return this._name;
    }

    public final List<WString> getEnumValueList() {
        return this._enumValueList;
    }

    @Override
    public <RetType> RetType accept(WIDLVisitor<RetType> visitor) {
        return visitor.forWEnum(this);
    }

    @Override
    public <RetType> RetType accept(WNodeVisitor<RetType> visitor) {
        return visitor.forWEnum(this);
    }

    @Override
    public void accept(WIDLVisitor_void visitor) {
        visitor.forWEnum(this);
    }

    @Override
    public void accept(WNodeVisitor_void visitor) {
        visitor.forWEnum(this);
    }

    public boolean equals(Object obj) {
        List<WString> casted_enumValueList;
        String casted_name;
        List<WEAttribute> casted_attrs;
        SpanInfo casted_info;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        WEnum casted = (WEnum)obj;
        SpanInfo temp_info = this.getInfo();
        if (temp_info != (casted_info = casted.getInfo()) && !temp_info.equals(casted_info)) {
            return false;
        }
        List<WEAttribute> temp_attrs = this.getAttrs();
        if (temp_attrs != (casted_attrs = casted.getAttrs()) && !temp_attrs.equals(casted_attrs)) {
            return false;
        }
        String temp_name = this.getName();
        if (temp_name != (casted_name = casted.getName())) {
            return false;
        }
        List<WString> temp_enumValueList = this.getEnumValueList();
        return temp_enumValueList == (casted_enumValueList = casted.getEnumValueList()) || temp_enumValueList.equals(casted_enumValueList);
    }

    @Override
    public int generateHashCode() {
        int code = this.getClass().hashCode();
        SpanInfo temp_info = this.getInfo();
        code ^= temp_info.hashCode();
        List<WEAttribute> temp_attrs = this.getAttrs();
        code ^= temp_attrs.hashCode();
        String temp_name = this.getName();
        code ^= temp_name.hashCode();
        List<WString> temp_enumValueList = this.getEnumValueList();
        return code ^= temp_enumValueList.hashCode();
    }

    protected WEnum() {
        this._name = null;
        this._enumValueList = null;
    }

    @Override
    public void walk(TreeWalker w) {
        if (w.visitNode(this, "WEnum", 4)) {
            List<WString> temp_enumValueList;
            String temp_name;
            List<WEAttribute> temp_attrs;
            SpanInfo temp_info = this.getInfo();
            if (w.visitNodeField("info", temp_info)) {
                w.visitUnknownObject(temp_info);
                w.endNodeField("info", temp_info);
            }
            if (w.visitNodeField("attrs", temp_attrs = this.getAttrs())) {
                if (w.visitIterated(temp_attrs)) {
                    int i_temp_attrs = 0;
                    for (WEAttribute elt_temp_attrs : temp_attrs) {
                        if (w.visitIteratedElement(i_temp_attrs, elt_temp_attrs)) {
                            if (elt_temp_attrs == null) {
                                w.visitNull();
                            } else {
                                elt_temp_attrs.walk(w);
                            }
                        }
                        ++i_temp_attrs;
                    }
                    w.endIterated(temp_attrs, i_temp_attrs);
                }
                w.endNodeField("attrs", temp_attrs);
            }
            if (w.visitNodeField("name", temp_name = this.getName())) {
                w.visitString(temp_name);
                w.endNodeField("name", temp_name);
            }
            if (w.visitNodeField("enumValueList", temp_enumValueList = this.getEnumValueList())) {
                if (w.visitIterated(temp_enumValueList)) {
                    int i_temp_enumValueList = 0;
                    for (WString elt_temp_enumValueList : temp_enumValueList) {
                        if (w.visitIteratedElement(i_temp_enumValueList, elt_temp_enumValueList)) {
                            if (elt_temp_enumValueList == null) {
                                w.visitNull();
                            } else {
                                elt_temp_enumValueList.walk(w);
                            }
                        }
                        ++i_temp_enumValueList;
                    }
                    w.endIterated(temp_enumValueList, i_temp_enumValueList);
                }
                w.endNodeField("enumValueList", temp_enumValueList);
            }
            w.endNode(this, "WEnum", 4);
        }
    }
}

