/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jsa.safe.bugdetecter.ui.model;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.tizen.web.jsa.safe.bugdetecter.ui.model.JSFile;
import org.tizen.web.jsa.safe.bugdetecter.ui.model.JSInfo;

public class JSFileLabelProvider
extends StyledCellLabelProvider {
    private static final Image JS_FILE = JSFileLabelProvider.getImage("javascript_file.png");

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        StyledString text = new StyledString();
        if (element instanceof JSFile) {
            JSFile JSFile2 = (JSFile)element;
            text.append(JSFile2.getName());
            if (JSFile2.isExists()) {
                cell.setImage(JS_FILE);
                text.append(" : " + JSFile2.getPath(), StyledString.QUALIFIER_STYLER);
            } else {
                cell.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
                if (JSFile2.getPath() != null) {
                    text.append(" : " + JSFile2.getPath() + " > File not found.", StyledString.QUALIFIER_STYLER);
                }
            }
        } else {
            JSInfo JSInfo2 = (JSInfo)element;
            text.append(JSInfo2.getMessage());
            if (JSInfo2.getBugLevel().equals("ERROR")) {
                cell.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
            } else if (JSInfo2.getBugLevel().equals("WARNING")) {
                cell.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
            }
        }
        cell.setText(text.toString());
        cell.setStyleRanges(text.getStyleRanges());
        super.update(cell);
    }

    private static Image getImage(String file) {
        Bundle bundle = FrameworkUtil.getBundle(JSFileLabelProvider.class);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/" + file), null);
        ImageDescriptor image = ImageDescriptor.createFromURL((URL)url);
        return image.createImage();
    }
}

