/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import java.util.List;
import kr.ac.kaist.jsaf.nodes.ASTSpanInfo;
import kr.ac.kaist.jsaf.nodes.AbstractNode;
import kr.ac.kaist.jsaf.nodes.AbstractNodeVisitor;
import kr.ac.kaist.jsaf.nodes.AbstractNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.Expr;
import kr.ac.kaist.jsaf.nodes.NodeVisitor;
import kr.ac.kaist.jsaf.nodes.NodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.Stmt;
import kr.ac.kaist.jsaf.nodes.TreeWalker;

public class Case
extends AbstractNode {
    private final Expr _cond;
    private final List<Stmt> _body;

    public Case(ASTSpanInfo in_info, Expr in_cond, List<Stmt> in_body) {
        super(in_info);
        if (in_cond == null) {
            throw new IllegalArgumentException("Parameter 'cond' to the Case constructor was null");
        }
        this._cond = in_cond;
        if (in_body == null) {
            throw new IllegalArgumentException("Parameter 'body' to the Case constructor was null");
        }
        this._body = in_body;
    }

    public final Expr getCond() {
        return this._cond;
    }

    public final List<Stmt> getBody() {
        return this._body;
    }

    @Override
    public <RetType> RetType accept(AbstractNodeVisitor<RetType> visitor) {
        return visitor.forCase(this);
    }

    @Override
    public <RetType> RetType accept(NodeVisitor<RetType> visitor) {
        return visitor.forCase(this);
    }

    @Override
    public void accept(AbstractNodeVisitor_void visitor) {
        visitor.forCase(this);
    }

    @Override
    public void accept(NodeVisitor_void visitor) {
        visitor.forCase(this);
    }

    public boolean equals(Object obj) {
        List<Stmt> casted_body;
        Expr casted_cond;
        ASTSpanInfo casted_info;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        Case casted = (Case)obj;
        ASTSpanInfo temp_info = this.getInfo();
        if (temp_info != (casted_info = casted.getInfo()) && !temp_info.equals(casted_info)) {
            return false;
        }
        Expr temp_cond = this.getCond();
        if (temp_cond != (casted_cond = casted.getCond()) && !temp_cond.equals(casted_cond)) {
            return false;
        }
        List<Stmt> temp_body = this.getBody();
        return temp_body == (casted_body = casted.getBody()) || temp_body.equals(casted_body);
    }

    @Override
    public int generateHashCode() {
        int code = this.getClass().hashCode();
        ASTSpanInfo temp_info = this.getInfo();
        code ^= temp_info.hashCode();
        Expr temp_cond = this.getCond();
        code ^= temp_cond.hashCode();
        List<Stmt> temp_body = this.getBody();
        return code ^= temp_body.hashCode();
    }

    protected Case() {
        this._cond = null;
        this._body = null;
    }

    @Override
    public void walk(TreeWalker w) {
        if (w.visitNode(this, "Case", 3)) {
            List<Stmt> temp_body;
            Expr temp_cond;
            ASTSpanInfo temp_info = this.getInfo();
            if (w.visitNodeField("info", temp_info)) {
                temp_info.walk(w);
                w.endNodeField("info", temp_info);
            }
            if (w.visitNodeField("cond", temp_cond = this.getCond())) {
                temp_cond.walk(w);
                w.endNodeField("cond", temp_cond);
            }
            if (w.visitNodeField("body", temp_body = this.getBody())) {
                if (w.visitIterated(temp_body)) {
                    int i_temp_body = 0;
                    for (Stmt elt_temp_body : temp_body) {
                        if (w.visitIteratedElement(i_temp_body, elt_temp_body)) {
                            if (elt_temp_body == null) {
                                w.visitNull();
                            } else {
                                elt_temp_body.walk(w);
                            }
                        }
                        ++i_temp_body;
                    }
                    w.endIterated(temp_body, i_temp_body);
                }
                w.endNodeField("body", temp_body);
            }
            w.endNode(this, "Case", 3);
        }
    }
}

