/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class Predicate<T> {
    public static final Predicate FALSE = new Predicate(){

        public boolean test(Object o) {
            return false;
        }
    };
    public static final Predicate TRUE = FALSE.not();

    public static <T> Predicate<T> truePred() {
        return TRUE;
    }

    public static <T> Predicate<T> falsePred() {
        return FALSE;
    }

    public abstract boolean test(T var1);

    public Predicate<T> not() {
        final Predicate originalPredicate = this;
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return !originalPredicate.test(t);
            }
        };
    }

    public Predicate<T> and(final Predicate<T> conjunct) {
        final Predicate originalPredicate = this;
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return originalPredicate.test(t) && conjunct.test(t);
            }
        };
    }

    public Predicate<T> or(final Predicate<T> disjunct) {
        final Predicate originalPredicate = this;
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return originalPredicate.test(t) || disjunct.test(t);
            }
        };
    }

    public static <T> Predicate<T> isElementOf(final Collection<T> c) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return c.contains(t);
            }
        };
    }

    public static <T> List<T> filter(Iterator<T> src, Predicate<T> pred) throws IllegalArgumentException {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        ArrayList<T> result = new ArrayList<T>();
        while (src.hasNext()) {
            T curElem = src.next();
            if (!pred.test(curElem)) continue;
            result.add(curElem);
        }
        return result;
    }
}

