/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.staleness;

import com.samsung.memoryanalysis.io.AbstractAsyncTraceWriter;
import com.samsung.memoryanalysis.staleness.ObjectStaleness;
import com.samsung.memoryanalysis.traceparser.IIDMap;
import com.samsung.memoryanalysis.traceparser.SourceLocation;
import com.samsung.memoryanalysis.util.Util;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Staleness {
    public final Map<Integer, List<ObjectStaleness>> staleness;
    private final IIDMap iidMap;
    private final List<long[]> functionTrace;
    private final boolean callStackSourceLoc;

    public Staleness(Map<Integer, List<ObjectStaleness>> staleness, List<long[]> functionTrace, IIDMap iidMap, boolean callStackSourceLoc) {
        this.staleness = staleness;
        this.iidMap = iidMap;
        this.functionTrace = functionTrace;
        this.callStackSourceLoc = callStackSourceLoc;
    }

    public String toString() {
        return this.staleness.toString();
    }

    private void writeList(ArrayList l, StalenessAsyncWriter out) {
        out.writeRaw("[");
        for (int i = 0; i < l.size(); ++i) {
            Object val = l.get(i);
            if (val instanceof Integer) {
                out.writeRaw(val.toString());
            } else if (val instanceof String) {
                out.writeQuoted((String)val);
            } else {
                throw new RuntimeException("need to handle " + val.getClass());
            }
            if (i >= l.size() - 1) continue;
            out.writeRaw(",");
        }
        out.writeRaw("]");
    }

    private void writeObjMap(Map map, StalenessAsyncWriter out) {
        out.writeRaw("{");
        Set keySet = map.keySet();
        int i = 0;
        for (Object key : keySet) {
            out.writeQuoted((String)key);
            out.writeRaw(":");
            Object val = map.get(key);
            if (val instanceof ArrayList) {
                ArrayList l = (ArrayList)val;
                this.writeList(l, out);
            } else if (val instanceof String) {
                out.writeQuoted((String)val);
            } else if (val instanceof Integer || val instanceof Long) {
                out.writeRaw(val.toString());
            } else {
                throw new RuntimeException("need to handle " + val.getClass());
            }
            if (i < keySet.size() - 1) {
                out.writeRaw(",");
            }
            ++i;
        }
        out.writeRaw("}");
        out.flushIfNeeded();
    }

    public StalenessAsyncWriter toJSON(Path path, boolean relative) throws IOException {
        StalenessAsyncWriter out = new StalenessAsyncWriter(path);
        out.writeRaw("{\"functionTrace\":[");
        for (int i = 0; i < this.functionTrace.size(); ++i) {
            out.writeRaw(Arrays.toString(this.functionTrace.get(i)));
            if (i < this.functionTrace.size() - 1) {
                out.writeRaw(",");
            }
            out.flushIfNeeded();
        }
        out.writeRaw("],\"objectInfo\": {");
        TreeMap<String, Map[]> resStale = new TreeMap<String, Map[]>();
        for (Map.Entry<Integer, List<ObjectStaleness>> entry : this.staleness.entrySet()) {
            String key;
            String srcLoc;
            Map[] arr = new Map[entry.getValue().size()];
            for (int i = 0; i < arr.length; ++i) {
                ObjectStaleness stale = entry.getValue().get(i);
                arr[i] = stale.toMap(this.iidMap, relative, this.callStackSourceLoc);
            }
            SourceLocation entr = this.iidMap.get(entry.getKey());
            String string = relative ? Util.makeRelative(entr) : (srcLoc = entr == null ? null : entr.toString());
            String string2 = entry.getKey() == -1 ? "unknown" : (key = entry.getKey() == 0 ? "end of program" : srcLoc);
            if (resStale.containsKey(key)) {
                Map[] old = (Map[])resStale.get(key);
                Map[] newArr = Arrays.copyOf(old, old.length + arr.length);
                System.arraycopy(arr, 0, newArr, old.length, arr.length);
                resStale.put(key, newArr);
                continue;
            }
            resStale.put(key, arr);
        }
        Set staleEntries = resStale.entrySet();
        int i = 0;
        for (Map.Entry entry : staleEntries) {
            out.writeQuoted((String)entry.getKey());
            out.writeRaw(": [");
            Map[] objs = (Map[])entry.getValue();
            for (int j = 0; j < objs.length; ++j) {
                Map curMap = objs[j];
                this.writeObjMap(curMap, out);
                if (j >= objs.length - 1) continue;
                out.writeRaw(",");
            }
            out.writeRaw("]");
            if (i < staleEntries.size() - 1) {
                out.writeRaw(",");
            }
            ++i;
        }
        out.writeRaw("}}");
        return out;
    }

    public static class StalenessAsyncWriter
    extends AbstractAsyncTraceWriter {
        public StalenessAsyncWriter(Path path) throws IOException {
            super(path);
        }

        public StalenessAsyncWriter writeRaw(String str) {
            this.builder.append(str);
            return this;
        }

        public StalenessAsyncWriter writeQuoted(String str) {
            this.builder.append("\"");
            this.builder.append(str);
            this.builder.append("\"");
            return this;
        }
    }
}

