/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.staleness;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ibm.wala.util.collections.HashMapFactory;
import com.samsung.memoryanalysis.staleness.ObjectStaleness;
import com.samsung.memoryanalysis.traceparser.IIDMap;
import com.samsung.memoryanalysis.traceparser.SourceLocation;
import com.samsung.memoryanalysis.util.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Staleness {
    public final Map<Integer, List<ObjectStaleness>> staleness;
    private final IIDMap iidMap;
    private final List<long[]> functionTrace;
    private final boolean callStackSourceLoc;

    public Staleness(Map<Integer, List<ObjectStaleness>> staleness, List<long[]> functionTrace, IIDMap iidMap, boolean callStackSourceLoc) {
        this.staleness = staleness;
        this.iidMap = iidMap;
        this.functionTrace = functionTrace;
        this.callStackSourceLoc = callStackSourceLoc;
    }

    public String toString() {
        return this.staleness.toString();
    }

    public void toJSON(OutputStream out, boolean relative) throws IOException {
        HashMap res = HashMapFactory.make();
        TreeMap<String, Map[]> resStale = new TreeMap<String, Map[]>();
        for (Map.Entry<Integer, List<ObjectStaleness>> entry : this.staleness.entrySet()) {
            String key;
            String srcLoc;
            Map[] arr = new Map[entry.getValue().size()];
            for (int i = 0; i < arr.length; ++i) {
                ObjectStaleness stale = entry.getValue().get(i);
                arr[i] = stale.toMap(this.iidMap, relative, this.callStackSourceLoc);
            }
            SourceLocation entr = this.iidMap.get(entry.getKey());
            String string = relative ? Util.makeRelative(entr) : (srcLoc = entr == null ? null : entr.toString());
            String string2 = entry.getKey() == -1 ? "unknown" : (key = entry.getKey() == 0 ? "end of program" : srcLoc);
            if (resStale.containsKey(key)) {
                Map[] old = (Map[])resStale.get(key);
                Map[] newArr = Arrays.copyOf(old, old.length + arr.length);
                System.arraycopy(arr, 0, newArr, old.length, arr.length);
                resStale.put(key, newArr);
                continue;
            }
            resStale.put(key, arr);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        res.put("functionTrace", this.functionTrace);
        res.put("objectInfo", resStale);
        gson.toJson((Object)res, (Appendable)writer);
        writer.close();
    }
}

