/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jsa;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.java_websocket.WebSocket;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_17;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.tizen.web.jsa.jalangi.actions.JalangiActionDelegate;
import org.tizen.web.jsa.jalangi.socket.JalangiSocketClient;
import org.tizen.web.jsa.jalangi.socket.JalangiSocketServer;
import org.tizen.web.jsa.jalangi.util.CommandExecutor;
import org.tizen.web.jsa.jalangi.util.EnvironmentMgr;
import org.tizen.web.jsa.safe.bugdetecter.preferences.Settings;

public class JsaPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.tizen.web.jsa";
    private static JsaPlugin plugin;
    public static final String CONSOLE_NAME = "Stale Object Checker Console";
    private MessageConsoleStream mConsoleStream;
    private static MessageConsoleStream mConsoleErrorStream;
    public static volatile String debugUrl;
    public static Action actionStopRecord;
    private static final String TRACE_SIGNAL = "endTracing";
    private static final String STOP_TEXT_LABEL = "Stop Record";
    private static final String SHOW_TEXT_LABEL = "Show Result";
    private static final String CLIENT_IP = "127.0.0.1";
    private static final int PORT = 8085;
    private JalangiSocketServer socketServer;
    private JalangiSocketClient socketClient;

    static {
        debugUrl = "";
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.startSocketServer();
        this.initializeJSAConsole();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        JalangiActionDelegate.clearExecutionEnvironment();
    }

    public static JsaPlugin getDefault() {
        return plugin;
    }

    public void initializeJSAConsole() {
        MessageConsole myConsole = this.findConsole();
        this.mConsoleStream = myConsole.newMessageStream();
        mConsoleErrorStream = myConsole.newMessageStream();
        actionStopRecord = new Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Collection con = JsaPlugin.this.socketServer.connections();
                actionStopRecord.setEnabled(false);
                if (JalangiActionDelegate.isBrowserMode) {
                    Collection collection = con;
                    synchronized (collection) {
                        for (WebSocket c : con) {
                            c.send(JsaPlugin.TRACE_SIGNAL);
                        }
                        if (con.isEmpty()) {
                            JsaPlugin.printErrorToConsole("[Error] Can't find application client.");
                        }
                    }
                }
                try {
                    JsaPlugin.this.socketClient = new JalangiSocketClient(new URI("ws://127.0.0.1:8085"), JalangiSocketClient.DRAFT);
                    JsaPlugin.this.socketClient.connect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        actionStopRecord.setText(STOP_TEXT_LABEL);
        actionStopRecord.setToolTipText(STOP_TEXT_LABEL);
        actionStopRecord.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_STOP"));
        actionStopRecord.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_STOP_DISABLED"));
        actionStopRecord.setEnabled(false);
    }

    public void initializeDefaultPreferences(IPreferenceStore store) {
        String checkers = store.getString("SELECTED_RULE_CHECKER");
        if (Settings.isEmpty(checkers)) {
            store.setDefault("SELECTED_RULE_CHECKER", "30,31,32,33,34,36,38,39,51,52,50,53,54,55,56,57,58,59,67,68,69,61,63,60,62,64");
            if (!Settings.isSetConfigFile()) {
                Settings.writeConfigFile();
            }
        }
    }

    public MessageConsole findConsole() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (CONSOLE_NAME.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(CONSOLE_NAME, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public static void printErrorToConsole(Throwable e) {
        if (plugin != null) {
            JsaPlugin.printErrorToConsole(JsaPlugin.getErrorInfo(e));
        }
    }

    public static void printErrorToConsole(String msg) {
        if (plugin != null) {
            JsaPlugin.printToStream(mConsoleErrorStream, "", msg);
        }
    }

    public static void printToConsole(String msg) {
        if (plugin != null) {
            JsaPlugin.printToStream(JsaPlugin.plugin.mConsoleStream, "", msg);
        }
    }

    public static synchronized void printToStream(MessageConsoleStream stream, String tag, String msg) {
        if (plugin != null) {
            if (msg.startsWith("DEBUG URL: ") && msg.indexOf("http:") != -1) {
                debugUrl = msg.substring(msg.indexOf("http:"), msg.length());
            }
            String log = String.valueOf(msg) + "\n";
            stream.print(log);
        }
    }

    public static String getErrorInfo(Throwable t) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            return "\n" + sw.toString() + "\n";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "fail to get stack trace info";
        }
    }

    public static void redefineJSAConsole() {
        IContributionItem[] items;
        mConsoleErrorStream.setColor(Display.getDefault().getSystemColor(3));
        IViewPart viewpart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.console.ConsoleView");
        IToolBarManager toolbarMgr = viewpart.getViewSite().getActionBars().getToolBarManager();
        IContributionItem[] iContributionItemArray = items = toolbarMgr.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action;
            String text;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && (text = (action = ((ActionContributionItem)item).getAction()).getText()).equals(STOP_TEXT_LABEL)) {
                return;
            }
            ++n2;
        }
        toolbarMgr.insertBefore("launchGroup", (IAction)actionStopRecord);
        toolbarMgr.insertBefore("launchGroup", (IContributionItem)new Separator());
        viewpart.getViewSite().getActionBars().updateActionBars();
    }

    public static void setConsoleToolbarStop(Boolean enabled) {
        actionStopRecord.setEnabled(enabled.booleanValue());
    }

    private Image createImage(String file) {
        Bundle bundle = FrameworkUtil.getBundle(JsaPlugin.class);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/" + file), null);
        ImageDescriptor image = ImageDescriptor.createFromURL((URL)url);
        return image.createImage();
    }

    private void startSocketServer() {
        this.socketServer = new JalangiSocketServer(new InetSocketAddress(CLIENT_IP, 8085), (Draft)new Draft_17());
        this.socketServer.start();
    }

    private void stopSocket() {
        if (!JalangiActionDelegate.isBrowserMode) {
            this.socketClient.close();
        }
    }

    private class Show
    extends Thread {
        private Show() {
        }

        @Override
        public void run() {
            CommandExecutor.exec(EnvironmentMgr.Commands.LAUNCH_RESULT_VIEW, null, null);
        }
    }
}

