/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jsa.safe.bugdetecter.nature;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSAnalysisNature
implements IProjectNature {
    protected static final Logger logger = LoggerFactory.getLogger(JSAnalysisNature.class);
    public static final String JSA_NATURE = "org.tizen.web.jsa.JSAnalysisNature";
    private IProject project;

    public void configure() throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        boolean actualBuilderExist = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.tizen.web.jsa.JSAnalysisBuilder")) {
                actualBuilderExist = true;
                break;
            }
            ++i;
        }
        if (!actualBuilderExist) {
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 0, commands.length);
            ICommand webBuilderCommand = description.newCommand();
            webBuilderCommand.setBuilderName("org.tizen.web.jsa.JSAnalysisBuilder");
            newCommands[newCommands.length - 1] = webBuilderCommand;
            description.setBuildSpec(newCommands);
            this.getProject().setDescription(description, null);
        }
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static void setJsaNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (JSA_NATURE.equals(natures[i])) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = JSA_NATURE;
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }
}

