/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jsa.jalangi.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.web.jsa.JsaPlugin;
import org.tizen.web.jsa.jalangi.actions.JalangiActionDelegate;
import org.tizen.web.jsa.jalangi.util.CommandExecutor;
import org.tizen.web.jsa.jalangi.util.EnvironmentMgr;
import org.tizen.web.jsa.jalangi.util.JalangiCommandExecutor;
import org.tizen.web.jsa.jalangi.util.TizenConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MemoryLeakModule
extends Thread {
    public String jalangiDir = EnvironmentMgr.getJalangiDir();
    private File mldDir = new File(this.jalangiDir);
    public static final String JOB_ON_DEVICE = "Run memory leak check on device";
    public static final String JOB_ON_BROWSER = "Run memory leak check on chrome";
    private static final String INSTALLING_COMPLETE = "install complete";
    private static final String WIDGET_CREATED = "Finished package";
    private static final String LIFETIME_ANALYSIS_COMPLETE = "completing lifetime analysis...done";
    private static final String LISTENER_OPENED = "on http://localhost:8888";
    private static final String RUN_COMPLETE = "Recording  complete";
    private static final String TRACE_PROCESS_COMPLETE = "Finished processing enhanced trace";
    private static final String DEBUG_LAUNCHED = "Tizen application is successfully launched";
    private static final String DEBUG_LAUNCHED_FAILED = "Failed to install Tizen application";
    private static final String CONNECTION_ACCEPT = "Connection accepted.";
    private static final String LIFETIME_ANALYSIS_ERR1 = "lifetime analysis error!";
    private static final String LIFETIME_ANALYSIS_ERR2 = "Exception in thread";
    private static final int timeout = 2;
    private String projectPath;
    private boolean isBrowser = false;
    private String projectName;
    private Job job;
    private Job browserJob;
    static Timer timer;
    String targetId = null;
    List<String> targetIdList = new ArrayList<String>();

    @Override
    public void run() {
        super.run();
        if (this.isBrowser) {
            this.doMemoryLeakTestOnBrowser();
        } else {
            this.doMemoryLeakTest();
        }
    }

    public MemoryLeakModule(boolean browser) {
        this.projectName = EnvironmentMgr.getCurrentProjectName();
        this.projectPath = String.valueOf(EnvironmentMgr.isWindows ? String.valueOf(EnvironmentMgr.getWorkspacePath()) + File.separator + EnvironmentMgr.INSTRUMENT_OUTPUT : EnvironmentMgr.INSTRUMENT_OUTPUT) + File.separator + this.projectName;
        this.isBrowser = browser;
    }

    public boolean instrument(IProgressMonitor monitor) {
        if (timer != null) {
            timer.cancel();
        }
        monitor.subTask(" Instrumenting " + this.projectName);
        File outputDir = JalangiCommandExecutor.instrumentForMemoryLeak(this.isBrowser);
        TizenConfig config = TizenConfig.getInstance(new File(outputDir, "config.xml"));
        config.addPrivilegeToConfig();
        return true;
    }

    public void doMemoryLeakTest() {
        this.job = new JSAJob(JOB_ON_DEVICE){

            @Override
            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(MemoryLeakModule.JOB_ON_DEVICE, -1);
                if (MemoryLeakModule.this.job.getState() == 4) {
                    MemoryLeakModule.this.job.setName(":Instrumenting javascript files(1/7)");
                }
                JsaPlugin.printToConsole("\n--- Instrumenting '" + MemoryLeakModule.this.projectName + "' (1/7)");
                MemoryLeakModule.this.instrument(monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(10);
                IStatus jobStatus = MemoryLeakModule.this.runTestMemoryLeak(monitor);
                MemoryLeakModule.this.job.setName("");
                monitor.done();
                if (timer != null) {
                    timer.cancel();
                }
                return jobStatus;
            }

            protected void canceling() {
                JsaPlugin.setConsoleToolbarStop(false);
                JalangiActionDelegate.clearExecutionEnvironment();
                MemoryLeakModule.this.job.setName("");
                super.canceling();
            }
        };
        this.job.schedule();
    }

    public boolean profileExists() {
        if (!this.getProfile().exists()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)JalangiActionDelegate.getShell(), (String)"signing", (String)"Active secure profile is not set.Please check the signing configuratuons at \npreferences>Security Profiles  ");
                }
            });
        }
        return this.getProfile().exists();
    }

    public File getProfile() {
        File workSpacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        File profilesFile = new File(workSpacePath, ".metadata/.plugins/org.tizen.common.sign/profiles.xml");
        return profilesFile;
    }

    private String getNameOfProfiles(File profilesFile) {
        String name = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(profilesFile);
            NodeList list = doc.getElementsByTagName("profile");
            if (list.getLength() > 0) {
                Element element = (Element)list.item(0);
                name = element.getAttribute("name");
                if (list.getLength() > 1) {
                    JsaPlugin.printToConsole("warning: there are more then one profile node in profiles file");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JsaPlugin.printErrorToConsole(e);
        }
        return name;
    }

    private IStatus runTestMemoryLeak(final IProgressMonitor monitor) {
        if (!this.profileExists()) {
            return Status.CANCEL_STATUS;
        }
        File profile = this.getProfile();
        File tizenCliScript = new File(EnvironmentMgr.getTizenIdeCliDir(), EnvironmentMgr.Commands.CLI_SCRIPT_NAME);
        if (!tizenCliScript.exists()) {
            MessageDialog.openError((Shell)JalangiActionDelegate.getShell(), (String)"CLI Missing", (String)"Please install web CLI first ");
            return Status.CANCEL_STATUS;
        }
        if (this.job.getState() == 4) {
            this.job.setName(" Packaging  " + this.projectName + "(2/7)");
            JsaPlugin.printToConsole("\n--- Packaging '" + this.projectName + "'  (2/7)");
        }
        CommandExecutor.exec(String.valueOf(EnvironmentMgr.getSdbPath()) + " devices ", null, new CommandExecutor.InputStreamHandler(){

            @Override
            public void handler(InputStream is) {
                block13: {
                    BufferedReader br = null;
                    try {
                        try {
                            br = new BufferedReader(new InputStreamReader(is));
                            String str = null;
                            while ((str = br.readLine()) != null) {
                                if (str.split("\t").length < 3) continue;
                                MemoryLeakModule.this.targetIdList.add(str.split("\t")[0].trim());
                            }
                            br = null;
                        }
                        catch (Exception e) {
                            JsaPlugin.printErrorToConsole(e);
                            if (br == null) break block13;
                            try {
                                br.close();
                            }
                            catch (IOException e2) {
                                JsaPlugin.printErrorToConsole(e2);
                            }
                        }
                    }
                    finally {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException e) {
                                JsaPlugin.printErrorToConsole(e);
                            }
                        }
                    }
                }
            }
        });
        if (this.targetIdList.size() > 0) {
            for (String tid : this.targetIdList) {
                if (!tid.startsWith("emulator") && !EnvironmentMgr.isIp(tid)) {
                    this.targetId = tid;
                    break;
                }
                if (EnvironmentMgr.isIp(tid)) {
                    this.targetId = tid;
                    CommandExecutor.exec(String.valueOf(EnvironmentMgr.getSdbPath()) + " disconnect " + tid, null, null);
                    CommandExecutor.exec(String.valueOf(EnvironmentMgr.getSdbPath()) + " connect " + tid, null, null);
                    break;
                }
                this.targetId = tid;
            }
        }
        JsaPlugin.printToConsole("Target Device : " + this.targetId);
        if (this.targetId == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)JalangiActionDelegate.getShell(), (String)"Error", (String)"Please connect the target device to this PC.");
                }
            });
            JsaPlugin.printErrorToConsole("Error : Please connect the target device to this PC.");
            if (this.job != null) {
                this.job.cancel();
            }
            return Status.CANCEL_STATUS;
        }
        monitor.subTask(" Packaging  " + this.projectName);
        String setCliPath = EnvironmentMgr.isWindows ? String.valueOf(tizenCliScript.getAbsolutePath()) + " cli-config -g \"default.profiles.path=" + profile.getAbsolutePath() + "\"" : String.valueOf(tizenCliScript.getAbsolutePath()) + " cli-config -g default.profiles.path=" + profile.getAbsolutePath();
        CommandExecutor.exec(setCliPath, null, null);
        boolean hasRan = false;
        StringBuilder command = new StringBuilder();
        String sdbPath = EnvironmentMgr.getSdbPath();
        if (sdbPath != null) {
            command.append("node drivers/meminsight.js package --outputDir ").append(this.projectPath).append(" ").append(String.valueOf(this.projectPath) + "/").append(" --sdbPath " + sdbPath);
        } else {
            command.append("node drivers/meminsight.js package --outputDir ").append(this.projectPath).append(" ").append(String.valueOf(this.projectPath) + "/");
        }
        command.append(" --profilesName ").append(this.getNameOfProfiles(profile)).append(" --serial ").append(this.targetId).append(" --cliPath ").append(EnvironmentMgr.getTizenIdeCliDir().getAbsolutePath());
        CommandExecutor.exec(command.toString(), this.mldDir, new CommandExecutor.InputStreamHandler(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handler(InputStream is) {
                BufferedReader br = null;
                try {
                    try {
                        br = new BufferedReader(new InputStreamReader(is));
                        String str = null;
                        boolean installFailed = false;
                        while (!monitor.isCanceled()) {
                            str = br.readLine();
                            if (str == null) {
                                return;
                            }
                            JsaPlugin.printToConsole(str);
                            if (str.contains("processing result")) {
                                CMDProcessStateChecker.checkProcessState(str, MemoryLeakModule.this.job, "Install Tizen widget failed: " + str, 0L, null);
                            } else {
                                CMDProcessStateChecker.checkProcessState(str, MemoryLeakModule.this.job, str, 0L, null);
                            }
                            if (str.contains(MemoryLeakModule.DEBUG_LAUNCHED_FAILED)) {
                                installFailed = true;
                            }
                            if (installFailed && str.contains("Finished install")) {
                                JsaPlugin.printErrorToConsole("Error : Failed to install Tizen application.");
                            }
                            if (str.contains(MemoryLeakModule.INSTALLING_COMPLETE)) {
                                return;
                            }
                            if (!str.contains(MemoryLeakModule.WIDGET_CREATED)) continue;
                            if (MemoryLeakModule.this.job.getState() == 4) {
                                MemoryLeakModule.this.job.setName(" Installing  " + MemoryLeakModule.this.projectName + "(3/7)");
                            }
                            JsaPlugin.printToConsole("\n--- Installing '" + MemoryLeakModule.this.projectName + "'  (3/7)");
                            monitor.subTask(" Installing  " + MemoryLeakModule.this.projectName);
                            monitor.worked(20);
                        }
                        return;
                    }
                    catch (Exception e) {
                        JsaPlugin.printErrorToConsole(e);
                        if (br == null) return;
                        try {
                            br.close();
                        }
                        catch (IOException e2) {
                            JsaPlugin.printErrorToConsole(e2);
                        }
                        br = null;
                        CMDProcessStateChecker.completeCheckProcessState();
                        return;
                    }
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            JsaPlugin.printErrorToConsole(e);
                        }
                        br = null;
                        CMDProcessStateChecker.completeCheckProcessState();
                    }
                }
            }
        });
        monitor.worked(30);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            if (!hasRan) {
                if (this.job.getState() == 4) {
                    this.job.setName(" Launching  " + this.projectName + "(4/7)");
                }
                JsaPlugin.printToConsole("\n--- Launching '" + this.projectName + "'  (4/7)");
                monitor.subTask(" Launching  " + this.projectName);
                hasRan = true;
                String cmdStr = String.valueOf(EnvironmentMgr.Commands.EXECUTE_MLD_RUN_CLIENT) + this.projectPath;
                if (sdbPath != null) {
                    cmdStr = String.valueOf(cmdStr) + " --sdbPath " + sdbPath;
                }
                cmdStr = String.valueOf(cmdStr) + " --cliPath " + EnvironmentMgr.getTizenIdeCliDir().getAbsolutePath() + " --serial " + this.targetId;
                CommandExecutor.exec(cmdStr, this.mldDir, new CommandExecutor.InputStreamHandler(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void handler(InputStream is) {
                        BufferedReader br = null;
                        try {
                            try {
                                br = new BufferedReader(new InputStreamReader(is));
                                String str = null;
                                boolean needCheckState = false;
                                String promptMsg = null;
                                do {
                                    if (monitor.isCanceled()) return;
                                    str = br.readLine();
                                    if (str == null) {
                                        return;
                                    }
                                    JsaPlugin.printToConsole(str);
                                    if (str.contains(MemoryLeakModule.DEBUG_LAUNCHED)) {
                                        if (MemoryLeakModule.this.job.getState() == 4) {
                                            MemoryLeakModule.this.job.setName(" Testing  " + MemoryLeakModule.this.projectName + "(5/7)");
                                        }
                                        JsaPlugin.setConsoleToolbarStop(true);
                                        monitor.subTask(" Testing " + MemoryLeakModule.this.projectName);
                                        monitor.worked(30);
                                        needCheckState = true;
                                    }
                                    if (needCheckState && str.contains("Finished run")) {
                                        JsaPlugin.printToConsole("\n--- Testing '" + MemoryLeakModule.this.projectName + "'  (5/7)");
                                        JsaPlugin.printErrorToConsole("Start user event recording on target...");
                                        JsaPlugin.printErrorToConsole("(Push the red button on 'Console Toolbar' after user event recording.)");
                                    }
                                    if (needCheckState) {
                                        CMDProcessStateChecker.checkProcessState(str, MemoryLeakModule.this.job, null, 0L, null);
                                        continue;
                                    }
                                    promptMsg = str.contains("error: target offline") ? "Launching app failed, error: target offline" : str;
                                    CMDProcessStateChecker.checkProcessState(str, MemoryLeakModule.this.job, promptMsg, 0L, null);
                                } while (!str.contains(MemoryLeakModule.LIFETIME_ANALYSIS_COMPLETE));
                                timer = new Timer();
                                timer.schedule((TimerTask)new Task(), 120000L);
                                return;
                            }
                            catch (Exception e) {
                                JsaPlugin.printErrorToConsole(e);
                                if (br == null) return;
                                try {
                                    br.close();
                                }
                                catch (IOException e2) {
                                    JsaPlugin.printErrorToConsole(e2);
                                }
                                br = null;
                                CMDProcessStateChecker.completeCheckProcessState();
                                return;
                            }
                        }
                        finally {
                            if (br != null) {
                                try {
                                    br.close();
                                }
                                catch (IOException e) {
                                    JsaPlugin.printErrorToConsole(e);
                                }
                                br = null;
                                CMDProcessStateChecker.completeCheckProcessState();
                            }
                        }
                    }
                });
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.doInspectAction(monitor, false);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JsaPlugin.printErrorToConsole(e);
        }
        return Status.OK_STATUS;
    }

    public void doMemoryLeakTestOnBrowser() {
        this.browserJob = new JSAJob(JOB_ON_BROWSER){

            @Override
            protected IStatus run(final IProgressMonitor monitor) {
                try {
                    monitor.beginTask(MemoryLeakModule.JOB_ON_BROWSER, -1);
                    if (MemoryLeakModule.this.browserJob.getState() == 4) {
                        MemoryLeakModule.this.browserJob.setName(" Instrumenting javascript files(1/5)");
                        JsaPlugin.printToConsole("\n--- Instrumenting '" + MemoryLeakModule.this.projectName + "' (1/5)");
                    }
                    MemoryLeakModule.this.instrument(monitor);
                    monitor.worked(20);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (MemoryLeakModule.this.browserJob.getState() == 4) {
                        MemoryLeakModule.this.browserJob.setName(" Launching " + MemoryLeakModule.this.projectName + "(2/5)");
                        JsaPlugin.printToConsole("\n--- Launching '" + MemoryLeakModule.this.projectName + "'  (2/5)");
                    }
                    monitor.subTask(" Launching " + MemoryLeakModule.this.projectName);
                    CommandExecutor.exec(String.valueOf(EnvironmentMgr.Commands.EXECUTE_MLD_RUN) + MemoryLeakModule.this.projectPath, MemoryLeakModule.this.mldDir, new CommandExecutor.InputStreamHandler(){

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public void handler(InputStream is) {
                            BufferedReader br = null;
                            try {
                                try {
                                    br = new BufferedReader(new InputStreamReader(is));
                                    String str = null;
                                    boolean needCheckState = false;
                                    while (!monitor.isCanceled()) {
                                        str = br.readLine();
                                        if (str == null) {
                                            return;
                                        }
                                        JsaPlugin.printToConsole(str);
                                        if (str.contains(MemoryLeakModule.LISTENER_OPENED)) {
                                            if (MemoryLeakModule.this.browserJob.getState() == 4) {
                                                MemoryLeakModule.this.browserJob.setName(" Testing " + MemoryLeakModule.this.projectName + "(3/5)");
                                                JsaPlugin.printToConsole("\n--- Testing '" + MemoryLeakModule.this.projectName + "'  (3/5)");
                                                JsaPlugin.printErrorToConsole("\nStart user event recording on target...");
                                                JsaPlugin.printErrorToConsole("(Push the red button on 'Console Toolbar' after user event recording.)\n");
                                            }
                                            JsaPlugin.setConsoleToolbarStop(true);
                                            monitor.subTask(" Testing " + MemoryLeakModule.this.projectName);
                                            monitor.worked(40);
                                            new Thread(){

                                                @Override
                                                public void run() {
                                                    super.run();
                                                    JsaPlugin.printToConsole("Execute Chrome Browser...");
                                                    CommandExecutor.exec(EnvironmentMgr.Commands.LAUNCH_APP_ON_BROWSER, null, null);
                                                }
                                            }.start();
                                            monitor.worked(30);
                                        } else if (str.contains(MemoryLeakModule.RUN_COMPLETE)) {
                                            timer = new Timer();
                                            timer.schedule((TimerTask)new Task(), 120000L);
                                            MemoryLeakModule.this.doInspectAction(monitor, true);
                                        }
                                        if (str.contains(MemoryLeakModule.CONNECTION_ACCEPT)) {
                                            needCheckState = true;
                                        }
                                        if (!needCheckState) continue;
                                        CMDProcessStateChecker.checkProcessState(str, MemoryLeakModule.this.browserJob, null, 0L, null);
                                    }
                                    return;
                                }
                                catch (Exception e) {
                                    JsaPlugin.printErrorToConsole(e);
                                    if (br == null) return;
                                    try {
                                        br.close();
                                    }
                                    catch (IOException e2) {
                                        JsaPlugin.printErrorToConsole(e2);
                                    }
                                    br = null;
                                    CMDProcessStateChecker.completeCheckProcessState();
                                    return;
                                }
                            }
                            finally {
                                if (br != null) {
                                    try {
                                        br.close();
                                    }
                                    catch (IOException e) {
                                        JsaPlugin.printErrorToConsole(e);
                                    }
                                    br = null;
                                    CMDProcessStateChecker.completeCheckProcessState();
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JsaPlugin.printErrorToConsole(e);
                    if (timer != null) {
                        timer.cancel();
                    }
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                if (timer != null) {
                    timer.cancel();
                }
                return Status.OK_STATUS;
            }

            protected void canceling() {
                JsaPlugin.setConsoleToolbarStop(false);
                JalangiActionDelegate.clearExecutionEnvironment();
                MemoryLeakModule.this.browserJob.setName("");
                super.canceling();
            }
        };
        this.browserJob.schedule();
    }

    public void doInspectAction(final IProgressMonitor monitor, final Boolean onBrowser) {
        if (onBrowser.booleanValue()) {
            if (this.browserJob.getState() == 4) {
                this.browserJob.setName(" Preparing inspection " + this.projectName + "(4/5)");
            }
            JsaPlugin.printToConsole("\n--- Preparing inspection '" + this.projectName + "'  (4/5)");
        } else {
            if (this.job.getState() == 4) {
                this.job.setName(" Preparing inspection " + this.projectName + "(6/7)");
            }
            JsaPlugin.printToConsole("\n--- Preparing inspection '" + this.projectName + "'  (6/7)");
        }
        monitor.subTask(" Preparing inspection");
        class InspectStatus {
            private boolean traceCompleted = false;

            InspectStatus() {
            }

            public boolean isTraceCompleted() {
                return this.traceCompleted;
            }

            public void setTraceCompleted(boolean traceCompleted) {
                this.traceCompleted = traceCompleted;
            }
        }
        final InspectStatus inspect = new InspectStatus();
        Thread inspectThread = new Thread(){
            {
            }

            @Override
            public void run() {
                CommandExecutor.exec(String.valueOf(EnvironmentMgr.Commands.EXECUTE_MLD_INSPECT) + MemoryLeakModule.this.projectPath, MemoryLeakModule.this.mldDir, new CommandExecutor.InputStreamHandler(){
                    {
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void handler(InputStream is) {
                        BufferedReader br = null;
                        try {
                            try {
                                br = new BufferedReader(new InputStreamReader(is));
                                String str = null;
                                while (!monitor.isCanceled()) {
                                    str = br.readLine();
                                    if (str == null) {
                                        return;
                                    }
                                    JsaPlugin.printToConsole(str);
                                    if (!str.contains(MemoryLeakModule.TRACE_PROCESS_COMPLETE)) continue;
                                    if (timer != null) {
                                        timer.cancel();
                                    }
                                    if (onBrowser.booleanValue()) {
                                        if (MemoryLeakModule.this.browserJob.getState() == 4) {
                                            MemoryLeakModule.this.browserJob.setName(" Showing result(5/5)");
                                        }
                                        JsaPlugin.printToConsole("\n--- Showing '" + MemoryLeakModule.this.projectName + "'  (5/5)");
                                    } else {
                                        if (MemoryLeakModule.this.job.getState() == 4) {
                                            MemoryLeakModule.this.job.setName(" Showing result(7/7)");
                                        }
                                        JsaPlugin.printToConsole("\n--- Showing Result of '" + MemoryLeakModule.this.projectName + "'  (7/7)");
                                    }
                                    monitor.subTask(" Showing result");
                                    monitor.worked(10);
                                    CommandExecutor.exec(EnvironmentMgr.Commands.LAUNCH_RESULT_VIEW, null, null);
                                    inspect.setTraceCompleted(true);
                                }
                                return;
                            }
                            catch (Exception e) {
                                JsaPlugin.printErrorToConsole(e);
                                if (br == null) return;
                                try {
                                    br.close();
                                }
                                catch (IOException e2) {
                                    JsaPlugin.printErrorToConsole(e2);
                                }
                                br = null;
                                return;
                            }
                        }
                        finally {
                            if (br != null) {
                                try {
                                    br.close();
                                }
                                catch (IOException e) {
                                    JsaPlugin.printErrorToConsole(e);
                                }
                                br = null;
                            }
                        }
                    }
                });
            }
        };
        inspectThread.start();
        while (!monitor.isCanceled() && !inspect.isTraceCompleted()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static class CMDProcessStateChecker {
        private Timer timer = null;
        private long errTime = 0L;
        private long timeout = 0L;
        private String errMsg = "";
        private Job job = null;
        private static CMDProcessStateChecker checker = null;
        private TimerTask checkTask = null;

        private CMDProcessStateChecker(String inputMsg, Job job, long errTime, long timeout) {
            this.errTime = errTime;
            this.errMsg = inputMsg;
            this.job = job;
            this.timeout = timeout;
        }

        public static void checkProcessState(String inputMsg, Job currentTask, String promptMsg, long timeout, String timeoutMsg) {
            if (checker == null && inputMsg != null) {
                checker = new CMDProcessStateChecker(inputMsg, currentTask, System.currentTimeMillis(), timeout);
            }
            if (checker != null) {
                checker.updateErrInfo(inputMsg, System.currentTimeMillis());
                if (inputMsg.contains(MemoryLeakModule.LIFETIME_ANALYSIS_ERR1) || inputMsg.contains(MemoryLeakModule.LIFETIME_ANALYSIS_ERR2) || inputMsg.contains("Tizen Configuration Error") || inputMsg.contains("Failed to uninstall") || inputMsg.matches("\\s*processing result\\s*:\\s*.+\\[\\d+\\]\\s*failed") || inputMsg.contains("error: target offline")) {
                    checker.checkOuterProcessState(true, promptMsg);
                } else if (timeout > 0L) {
                    checker.checkOuterProcessState(false, timeoutMsg);
                }
            }
        }

        public static void completeCheckProcessState() {
            if (checker != null) {
                CMDProcessStateChecker.checker.job = null;
                if (CMDProcessStateChecker.checker.timer != null) {
                    CMDProcessStateChecker.checker.timer.cancel();
                }
                CMDProcessStateChecker.checker.timer = null;
                checker = null;
            }
        }

        private void clearChecker() {
            if (this.job != null) {
                this.job.cancel();
            }
            checker = null;
        }

        private void updateErrInfo(String errMsg, long errTime) {
            this.errTime = errTime;
            this.errMsg = errMsg;
        }

        private void showMessageToUser(final String msg) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Information", (String)msg);
                    JalangiActionDelegate.clearExecutionEnvironment();
                }
            });
        }

        private void checkOuterProcessState(boolean hasError, final String msg) {
            if (hasError) {
                checker.clearChecker();
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                    this.checkTask = null;
                }
                this.showMessageToUser(msg == null ? "Stale Object Checker occured an internal error." : msg);
            } else {
                if (this.timer == null) {
                    this.timer = new Timer();
                }
                if (this.checkTask != null) {
                    this.checkTask.cancel();
                }
                this.timer.purge();
                this.checkTask = new TimerTask(){

                    @Override
                    public void run() {
                        if (checker != null && System.currentTimeMillis() - checker.errTime >= CMDProcessStateChecker.this.timeout * 1000L) {
                            CMDProcessStateChecker.this.showMessageToUser(msg == null ? "Stale Object Checker has stopped responsing." : msg);
                            checker.clearChecker();
                        }
                    }
                };
                this.timer.schedule(this.checkTask, this.timeout * 1000L);
            }
        }
    }

    static class JSAJob
    extends Job {
        private String Family = "JSA";

        public JSAJob(String jobName) {
            super(jobName);
        }

        public boolean belongsTo(Object family) {
            return family.equals(this.Family);
        }

        protected IStatus run(IProgressMonitor monitor) {
            return null;
        }
    }

    class Task
    extends TimerTask {
        Task() {
        }

        @Override
        public void run() {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Information", (String)"Stale Object Checker has stopped responsing.");
                    if (MemoryLeakModule.this.job != null) {
                        MemoryLeakModule.this.job.cancel();
                    }
                    if (MemoryLeakModule.this.browserJob != null) {
                        MemoryLeakModule.this.browserJob.cancel();
                    }
                }
            });
        }
    }
}

