/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jsa.safe.bugdetecter.ui.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.web.jsa.safe.bugdetecter.core.BugItem;
import org.tizen.web.jsa.safe.bugdetecter.ui.model.JSFile;
import org.tizen.web.jsa.safe.bugdetecter.ui.model.JSInfo;

public class JSFileModel {
    private IProject project;
    private ArrayList<JSFile> JSFiles = null;
    private int ErrorsCount = 0;
    private int WarningsCount = 0;

    public JSFileModel(IProject project) {
        this.project = project;
        this.JSFiles = new ArrayList();
    }

    public JSFileModel() {
        this.JSFiles = new ArrayList();
    }

    public void setExternalJSFileList(ArrayList<String> jsList) {
        this.JSFiles.clear();
        for (String item : jsList) {
            Path path = new Path(item);
            String filePath = path.toOSString();
            JSFile js = new JSFile();
            js.setName(path.lastSegment());
            js.setPath(filePath);
            js.setAbsolutePath(filePath);
            if (!this.checkFile((IPath)path)) {
                js.setExists(false);
            } else {
                js.setExists(true);
            }
            this.JSFiles.add(js);
        }
    }

    public void addExternalJSFileList(String jsPath) {
        Path path = new Path(jsPath);
        String filePath = path.toOSString();
        JSFile js = new JSFile();
        js.setName(path.lastSegment());
        js.setPath(filePath);
        js.setAbsolutePath(filePath);
        if (!this.checkFile((IPath)path)) {
            js.setExists(false);
        } else {
            js.setExists(true);
        }
        this.JSFiles.add(js);
    }

    public void setJSFileList(ArrayList<String> jsList) {
        this.JSFiles.clear();
        for (String item : jsList) {
            Path path = new Path(item);
            String filePath = path.makeRelativeTo(this.project.getLocation()).toOSString();
            JSFile js = new JSFile();
            js.setName(path.lastSegment());
            js.setPath(filePath);
            js.setAbsolutePath(item);
            if (!this.checkFile((IPath)path)) {
                js.setExists(false);
            } else {
                js.setExists(true);
            }
            this.JSFiles.add(js);
        }
    }

    public void addJSBug(BugItem bug) {
        JSFile errorJs = new JSFile();
        errorJs.setName(bug.message);
        errorJs.setExists(false);
        this.JSFiles.add(errorJs);
    }

    public void setJSBugList(ArrayList<BugItem> jsList) {
        for (BugItem item : jsList) {
            if (item.bugLevel == 100) {
                JSFile errorJs = new JSFile();
                errorJs.setName(item.message);
                errorJs.setExists(false);
                this.JSFiles.add(errorJs);
                continue;
            }
            Path path = new Path(item.filePath);
            String filePath = path.makeRelativeTo(this.project.getLocation()).toOSString();
            JSFile js = this.isContain(filePath);
            if (js == null) {
                js = new JSFile();
                js.setName(path.lastSegment());
                js.setPath(filePath);
                js.setAbsolutePath(item.filePath);
                if (!this.checkFile((IPath)path)) {
                    js.setExists(false);
                } else {
                    js.setExists(true);
                }
                this.JSFiles.add(js);
            }
            JSInfo info = this.generateJsInfo(item);
            js.addInfo(info);
            if (info.getBugLevel().endsWith("ERROR")) {
                ++this.ErrorsCount;
                continue;
            }
            ++this.WarningsCount;
        }
    }

    public JSInfo generateJsInfo(BugItem item) {
        JSInfo info = new JSInfo();
        info.setBugMessage(item.bugLevel, item.bugCategory, item.message);
        info.setLineNumber(item.lineNumber);
        return info;
    }

    public JSFile isContain(String jsPath) {
        for (JSFile file : this.JSFiles) {
            if (!file.getPath().equals(jsPath)) continue;
            return file;
        }
        return null;
    }

    public List<JSFile> getCategories() {
        return this.JSFiles;
    }

    public boolean checkFile(IPath path) {
        return path.toFile().exists();
    }

    public void addJSFileToFirst(String item) {
        Path path = new Path(item);
        String filePath = path.makeRelativeTo(this.project.getLocation()).toOSString();
        JSFile js = new JSFile();
        js.setName(path.lastSegment());
        js.setPath(filePath);
        js.setAbsolutePath(item);
        if (!this.checkFile((IPath)path)) {
            js.setExists(false);
        } else {
            js.setExists(true);
        }
        this.JSFiles.add(0, js);
    }

    public void addJSFileToLast(String item) {
        Path path = new Path(item);
        String filePath = path.makeRelativeTo(this.project.getLocation()).toOSString();
        JSFile js = new JSFile();
        js.setName(path.lastSegment());
        js.setPath(filePath);
        js.setAbsolutePath(item);
        if (!this.checkFile((IPath)path)) {
            js.setExists(false);
        } else {
            js.setExists(true);
        }
        this.JSFiles.add(js);
    }

    public void removeFirstFile() {
        this.JSFiles.remove(0);
    }

    public void removeLastFile() {
        this.JSFiles.remove(this.JSFiles.size() - 1);
    }

    public int getWarningsCount() {
        return this.WarningsCount;
    }

    public int getErrorsCount() {
        return this.ErrorsCount;
    }

    public void removeItem(String item) {
        for (JSFile file : this.JSFiles) {
            if (!file.getPath().endsWith(item)) continue;
            this.JSFiles.remove(file);
            return;
        }
    }

    public ArrayList<String> getNotExistFiles() {
        ArrayList<String> list = new ArrayList<String>();
        for (JSFile file : this.JSFiles) {
            if (file.isExists()) continue;
            list.add(file.getAbsolutePath());
        }
        return list;
    }
}

