/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.text;

import edu.rice.cs.plt.collect.IndexedOneToOneRelation;
import edu.rice.cs.plt.collect.OneToOneRelation;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.LazyThunk;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.recur.RecurUtil;
import edu.rice.cs.plt.text.Bracket;
import edu.rice.cs.plt.tuple.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextUtil {
    public static final String NEWLINE = System.getProperty("line.separator", "\n");
    public static final String NEWLINE_PATTERN = "\\r\\n|\\n|\\r";
    private static final Thunk<OneToOneRelation<Character, String>> XML_ENTITIES = LazyThunk.make(new Thunk<OneToOneRelation<Character, String>>(){

        @Override
        public OneToOneRelation<Character, String> value() {
            IndexedOneToOneRelation<Character, String> result = new IndexedOneToOneRelation<Character, String>();
            result.add(Character.valueOf('\"'), "quot");
            result.add(Character.valueOf('&'), "amp");
            result.add(Character.valueOf('\''), "apos");
            result.add(Character.valueOf('<'), "lt");
            result.add(Character.valueOf('>'), "gt");
            return result;
        }
    });
    private static final Thunk<OneToOneRelation<Character, String>> HTML_ENTITIES = LazyThunk.make(new Thunk<OneToOneRelation<Character, String>>(){

        @Override
        public OneToOneRelation<Character, String> value() {
            IndexedOneToOneRelation<Character, String> result = new IndexedOneToOneRelation<Character, String>();
            result.add(Character.valueOf('\''), "#39");
            result.add(Character.valueOf('\"'), "quot");
            result.add(Character.valueOf('&'), "amp");
            result.add(Character.valueOf('<'), "lt");
            result.add(Character.valueOf('>'), "gt");
            result.add(Character.valueOf('\u00a0'), "nbsp");
            result.add(Character.valueOf('\u00a1'), "iexcl");
            result.add(Character.valueOf('\u00a2'), "cent");
            result.add(Character.valueOf('\u00a3'), "pound");
            result.add(Character.valueOf('\u00a4'), "curren");
            result.add(Character.valueOf('\u00a5'), "yen");
            result.add(Character.valueOf('\u00a6'), "brvbar");
            result.add(Character.valueOf('\u00a7'), "sect");
            result.add(Character.valueOf('\u00a8'), "uml");
            result.add(Character.valueOf('\u00a9'), "copy");
            result.add(Character.valueOf('\u00aa'), "ordf");
            result.add(Character.valueOf('\u00ab'), "laquo");
            result.add(Character.valueOf('\u00ac'), "not");
            result.add(Character.valueOf('\u00ad'), "shy");
            result.add(Character.valueOf('\u00ae'), "reg");
            result.add(Character.valueOf('\u00af'), "macr");
            result.add(Character.valueOf('\u00b0'), "deg");
            result.add(Character.valueOf('\u00b1'), "plusmn");
            result.add(Character.valueOf('\u00b2'), "sup2");
            result.add(Character.valueOf('\u00b3'), "sup3");
            result.add(Character.valueOf('\u00b4'), "acute");
            result.add(Character.valueOf('\u00b5'), "micro");
            result.add(Character.valueOf('\u00b6'), "para");
            result.add(Character.valueOf('\u00b7'), "middot");
            result.add(Character.valueOf('\u00b8'), "cedil");
            result.add(Character.valueOf('\u00b9'), "sup1");
            result.add(Character.valueOf('\u00ba'), "ordm");
            result.add(Character.valueOf('\u00bb'), "raquo");
            result.add(Character.valueOf('\u00bc'), "frac14");
            result.add(Character.valueOf('\u00bd'), "frac12");
            result.add(Character.valueOf('\u00be'), "frac34");
            result.add(Character.valueOf('\u00bf'), "iquest");
            result.add(Character.valueOf('\u00c0'), "Agrave");
            result.add(Character.valueOf('\u00c1'), "Aacute");
            result.add(Character.valueOf('\u00c2'), "Acirc");
            result.add(Character.valueOf('\u00c3'), "Atilde");
            result.add(Character.valueOf('\u00c4'), "Auml");
            result.add(Character.valueOf('\u00c5'), "Aring");
            result.add(Character.valueOf('\u00c6'), "AElig");
            result.add(Character.valueOf('\u00c7'), "Ccedil");
            result.add(Character.valueOf('\u00c8'), "Egrave");
            result.add(Character.valueOf('\u00c9'), "Eacute");
            result.add(Character.valueOf('\u00ca'), "Ecirc");
            result.add(Character.valueOf('\u00cb'), "Euml");
            result.add(Character.valueOf('\u00cc'), "Igrave");
            result.add(Character.valueOf('\u00cd'), "Iacute");
            result.add(Character.valueOf('\u00ce'), "Icirc");
            result.add(Character.valueOf('\u00cf'), "Iuml");
            result.add(Character.valueOf('\u00d0'), "ETH");
            result.add(Character.valueOf('\u00d1'), "Ntilde");
            result.add(Character.valueOf('\u00d2'), "Ograve");
            result.add(Character.valueOf('\u00d3'), "Oacute");
            result.add(Character.valueOf('\u00d4'), "Ocirc");
            result.add(Character.valueOf('\u00d5'), "Otilde");
            result.add(Character.valueOf('\u00d6'), "Ouml");
            result.add(Character.valueOf('\u00d7'), "times");
            result.add(Character.valueOf('\u00d8'), "Oslash");
            result.add(Character.valueOf('\u00d9'), "Ugrave");
            result.add(Character.valueOf('\u00da'), "Uacute");
            result.add(Character.valueOf('\u00db'), "Ucirc");
            result.add(Character.valueOf('\u00dc'), "Uuml");
            result.add(Character.valueOf('\u00dd'), "Yacute");
            result.add(Character.valueOf('\u00de'), "THORN");
            result.add(Character.valueOf('\u00df'), "szlig");
            result.add(Character.valueOf('\u00e0'), "agrave");
            result.add(Character.valueOf('\u00e1'), "aacute");
            result.add(Character.valueOf('\u00e2'), "acirc");
            result.add(Character.valueOf('\u00e3'), "atilde");
            result.add(Character.valueOf('\u00e4'), "auml");
            result.add(Character.valueOf('\u00e5'), "aring");
            result.add(Character.valueOf('\u00e6'), "aelig");
            result.add(Character.valueOf('\u00e7'), "ccedil");
            result.add(Character.valueOf('\u00e8'), "egrave");
            result.add(Character.valueOf('\u00e9'), "eacute");
            result.add(Character.valueOf('\u00ea'), "ecirc");
            result.add(Character.valueOf('\u00eb'), "euml");
            result.add(Character.valueOf('\u00ec'), "igrave");
            result.add(Character.valueOf('\u00ed'), "iacute");
            result.add(Character.valueOf('\u00ee'), "icirc");
            result.add(Character.valueOf('\u00ef'), "iuml");
            result.add(Character.valueOf('\u00f0'), "eth");
            result.add(Character.valueOf('\u00f1'), "ntilde");
            result.add(Character.valueOf('\u00f2'), "ograve");
            result.add(Character.valueOf('\u00f3'), "oacute");
            result.add(Character.valueOf('\u00f4'), "ocirc");
            result.add(Character.valueOf('\u00f5'), "otilde");
            result.add(Character.valueOf('\u00f6'), "ouml");
            result.add(Character.valueOf('\u00f7'), "divide");
            result.add(Character.valueOf('\u00f8'), "oslash");
            result.add(Character.valueOf('\u00f9'), "ugrave");
            result.add(Character.valueOf('\u00fa'), "uacute");
            result.add(Character.valueOf('\u00fb'), "ucirc");
            result.add(Character.valueOf('\u00fc'), "uuml");
            result.add(Character.valueOf('\u00fd'), "yacute");
            result.add(Character.valueOf('\u00fe'), "thorn");
            result.add(Character.valueOf('\u00ff'), "yuml");
            result.add(Character.valueOf('\u0152'), "OElig");
            result.add(Character.valueOf('\u0153'), "oelig");
            result.add(Character.valueOf('\u0160'), "Scaron");
            result.add(Character.valueOf('\u0161'), "scaron");
            result.add(Character.valueOf('\u0178'), "Yuml");
            result.add(Character.valueOf('\u0192'), "fnof");
            result.add(Character.valueOf('\u02c6'), "circ");
            result.add(Character.valueOf('\u02dc'), "tilde");
            result.add(Character.valueOf('\u0391'), "Alpha");
            result.add(Character.valueOf('\u0392'), "Beta");
            result.add(Character.valueOf('\u0393'), "Gamma");
            result.add(Character.valueOf('\u0394'), "Delta");
            result.add(Character.valueOf('\u0395'), "Epsilon");
            result.add(Character.valueOf('\u0396'), "Zeta");
            result.add(Character.valueOf('\u0397'), "Eta");
            result.add(Character.valueOf('\u0398'), "Theta");
            result.add(Character.valueOf('\u0399'), "Iota");
            result.add(Character.valueOf('\u039a'), "Kappa");
            result.add(Character.valueOf('\u039b'), "Lambda");
            result.add(Character.valueOf('\u039c'), "Mu");
            result.add(Character.valueOf('\u039d'), "Nu");
            result.add(Character.valueOf('\u039e'), "Xi");
            result.add(Character.valueOf('\u039f'), "Omicron");
            result.add(Character.valueOf('\u03a0'), "Pi");
            result.add(Character.valueOf('\u03a1'), "Rho");
            result.add(Character.valueOf('\u03a3'), "Sigma");
            result.add(Character.valueOf('\u03a4'), "Tau");
            result.add(Character.valueOf('\u03a5'), "Upsilon");
            result.add(Character.valueOf('\u03a6'), "Phi");
            result.add(Character.valueOf('\u03a7'), "Chi");
            result.add(Character.valueOf('\u03a8'), "Psi");
            result.add(Character.valueOf('\u03a9'), "Omega");
            result.add(Character.valueOf('\u03b1'), "alpha");
            result.add(Character.valueOf('\u03b2'), "beta");
            result.add(Character.valueOf('\u03b3'), "gamma");
            result.add(Character.valueOf('\u03b4'), "delta");
            result.add(Character.valueOf('\u03b5'), "epsilon");
            result.add(Character.valueOf('\u03b6'), "zeta");
            result.add(Character.valueOf('\u03b7'), "eta");
            result.add(Character.valueOf('\u03b8'), "theta");
            result.add(Character.valueOf('\u03b9'), "iota");
            result.add(Character.valueOf('\u03ba'), "kappa");
            result.add(Character.valueOf('\u03bb'), "lambda");
            result.add(Character.valueOf('\u03bc'), "mu");
            result.add(Character.valueOf('\u03bd'), "nu");
            result.add(Character.valueOf('\u03be'), "xi");
            result.add(Character.valueOf('\u03bf'), "omicron");
            result.add(Character.valueOf('\u03c0'), "pi");
            result.add(Character.valueOf('\u03c1'), "rho");
            result.add(Character.valueOf('\u03c2'), "sigmaf");
            result.add(Character.valueOf('\u03c3'), "sigma");
            result.add(Character.valueOf('\u03c4'), "tau");
            result.add(Character.valueOf('\u03c5'), "upsilon");
            result.add(Character.valueOf('\u03c6'), "phi");
            result.add(Character.valueOf('\u03c7'), "chi");
            result.add(Character.valueOf('\u03c8'), "psi");
            result.add(Character.valueOf('\u03c9'), "omega");
            result.add(Character.valueOf('\u03d1'), "thetasym");
            result.add(Character.valueOf('\u03d2'), "upsih");
            result.add(Character.valueOf('\u03d6'), "piv");
            result.add(Character.valueOf('\u2002'), "ensp");
            result.add(Character.valueOf('\u2003'), "emsp");
            result.add(Character.valueOf('\u2009'), "thinsp");
            result.add(Character.valueOf('\u200c'), "zwnj");
            result.add(Character.valueOf('\u200d'), "zwj");
            result.add(Character.valueOf('\u200e'), "lrm");
            result.add(Character.valueOf('\u200f'), "rlm");
            result.add(Character.valueOf('\u2013'), "ndash");
            result.add(Character.valueOf('\u2014'), "mdash");
            result.add(Character.valueOf('\u2018'), "lsquo");
            result.add(Character.valueOf('\u2019'), "rsquo");
            result.add(Character.valueOf('\u201a'), "sbquo");
            result.add(Character.valueOf('\u201c'), "ldquo");
            result.add(Character.valueOf('\u201d'), "rdquo");
            result.add(Character.valueOf('\u201e'), "bdquo");
            result.add(Character.valueOf('\u2020'), "dagger");
            result.add(Character.valueOf('\u2021'), "Dagger");
            result.add(Character.valueOf('\u2022'), "bull");
            result.add(Character.valueOf('\u2026'), "hellip");
            result.add(Character.valueOf('\u2030'), "permil");
            result.add(Character.valueOf('\u2032'), "prime");
            result.add(Character.valueOf('\u2033'), "Prime");
            result.add(Character.valueOf('\u2039'), "lsaquo");
            result.add(Character.valueOf('\u203a'), "rsaquo");
            result.add(Character.valueOf('\u203e'), "oline");
            result.add(Character.valueOf('\u2044'), "frasl");
            result.add(Character.valueOf('\u20ac'), "euro");
            result.add(Character.valueOf('\u2111'), "image");
            result.add(Character.valueOf('\u2118'), "weierp");
            result.add(Character.valueOf('\u211c'), "real");
            result.add(Character.valueOf('\u2122'), "trade");
            result.add(Character.valueOf('\u2135'), "alefsym");
            result.add(Character.valueOf('\u2190'), "larr");
            result.add(Character.valueOf('\u2191'), "uarr");
            result.add(Character.valueOf('\u2192'), "rarr");
            result.add(Character.valueOf('\u2193'), "darr");
            result.add(Character.valueOf('\u2194'), "harr");
            result.add(Character.valueOf('\u21b5'), "crarr");
            result.add(Character.valueOf('\u21d0'), "lArr");
            result.add(Character.valueOf('\u21d1'), "uArr");
            result.add(Character.valueOf('\u21d2'), "rArr");
            result.add(Character.valueOf('\u21d3'), "dArr");
            result.add(Character.valueOf('\u21d4'), "hArr");
            result.add(Character.valueOf('\u2200'), "forall");
            result.add(Character.valueOf('\u2202'), "part");
            result.add(Character.valueOf('\u2203'), "exist");
            result.add(Character.valueOf('\u2205'), "empty");
            result.add(Character.valueOf('\u2207'), "nabla");
            result.add(Character.valueOf('\u2208'), "isin");
            result.add(Character.valueOf('\u2209'), "notin");
            result.add(Character.valueOf('\u220b'), "ni");
            result.add(Character.valueOf('\u220f'), "prod");
            result.add(Character.valueOf('\u2211'), "sum");
            result.add(Character.valueOf('\u2212'), "minus");
            result.add(Character.valueOf('\u2217'), "lowast");
            result.add(Character.valueOf('\u221a'), "radic");
            result.add(Character.valueOf('\u221d'), "prop");
            result.add(Character.valueOf('\u221e'), "infin");
            result.add(Character.valueOf('\u2220'), "ang");
            result.add(Character.valueOf('\u2227'), "and");
            result.add(Character.valueOf('\u2228'), "or");
            result.add(Character.valueOf('\u2229'), "cap");
            result.add(Character.valueOf('\u222a'), "cup");
            result.add(Character.valueOf('\u222b'), "int");
            result.add(Character.valueOf('\u2234'), "there4");
            result.add(Character.valueOf('\u223c'), "sim");
            result.add(Character.valueOf('\u2245'), "cong");
            result.add(Character.valueOf('\u2248'), "asymp");
            result.add(Character.valueOf('\u2260'), "ne");
            result.add(Character.valueOf('\u2261'), "equiv");
            result.add(Character.valueOf('\u2264'), "le");
            result.add(Character.valueOf('\u2265'), "ge");
            result.add(Character.valueOf('\u2282'), "sub");
            result.add(Character.valueOf('\u2283'), "sup");
            result.add(Character.valueOf('\u2284'), "nsub");
            result.add(Character.valueOf('\u2286'), "sube");
            result.add(Character.valueOf('\u2287'), "supe");
            result.add(Character.valueOf('\u2295'), "oplus");
            result.add(Character.valueOf('\u2297'), "otimes");
            result.add(Character.valueOf('\u22a5'), "perp");
            result.add(Character.valueOf('\u22c5'), "sdot");
            result.add(Character.valueOf('\u2308'), "lceil");
            result.add(Character.valueOf('\u2309'), "rceil");
            result.add(Character.valueOf('\u230a'), "lfloor");
            result.add(Character.valueOf('\u230b'), "rfloor");
            result.add(Character.valueOf('\u2329'), "lang");
            result.add(Character.valueOf('\u232a'), "rang");
            result.add(Character.valueOf('\u25ca'), "loz");
            result.add(Character.valueOf('\u2660'), "spades");
            result.add(Character.valueOf('\u2663'), "clubs");
            result.add(Character.valueOf('\u2665'), "hearts");
            result.add(Character.valueOf('\u2666'), "diams");
            return result;
        }
    });

    private TextUtil() {
    }

    public static String toString(Object o) {
        return RecurUtil.safeToString(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SizedIterable<String> getLines(String s) {
        AbstractIterable result = IterUtil.empty();
        BufferedReader r = new BufferedReader(new StringReader(s));
        try {
            String line = r.readLine();
            while (line != null) {
                result = IterUtil.compose(result, line);
                line = r.readLine();
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                r.close();
            }
            catch (IOException e) {}
        }
        return result;
    }

    public static String repeat(String s, int copies) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < copies; ++i) {
            result.append(s);
        }
        return result.toString();
    }

    public static String repeat(char c, int copies) {
        char[] result = new char[copies];
        Arrays.fill(result, c);
        return String.valueOf(result);
    }

    public static String padLeft(String s, char c, int length) {
        StringBuilder result = new StringBuilder();
        int delta = length - s.length();
        for (int i = 0; i < delta; ++i) {
            result.append(c);
        }
        result.append(s);
        return result.toString();
    }

    public static String padRight(String s, char c, int length) {
        StringBuilder result = new StringBuilder();
        result.append(s);
        int delta = length - s.length();
        for (int i = 0; i < delta; ++i) {
            result.append(c);
        }
        return result.toString();
    }

    public static boolean contains(String s, int character) {
        return s.indexOf(character) >= 0;
    }

    public static boolean contains(String s, String piece) {
        return s.indexOf(piece) >= 0;
    }

    public static boolean containsAny(String s, int ... characters) {
        for (int c : characters) {
            if (!TextUtil.contains(s, c)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(String s, String ... pieces) {
        for (String piece : pieces) {
            if (!TextUtil.contains(s, piece)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(String s, int ... characters) {
        for (int c : characters) {
            if (TextUtil.contains(s, c)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(String s, String ... pieces) {
        for (String piece : pieces) {
            if (TextUtil.contains(s, piece)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsIgnoreCase(String s, String piece) {
        return s.toLowerCase().indexOf(piece.toLowerCase()) >= 0;
    }

    public static boolean containsAnyIgnoreCase(String s, String ... pieces) {
        for (String piece : pieces) {
            if (!TextUtil.contains(s, piece)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllIgnoreCase(String s, String ... pieces) {
        for (String piece : pieces) {
            if (TextUtil.contains(s, piece)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithAny(String s, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!s.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithAny(String s, String ... suffixes) {
        for (String suffix : suffixes) {
            if (!s.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static int indexOfFirst(String s, int ... characters) {
        int result = -1;
        for (int c : characters) {
            int index = s.indexOf(c);
            if (index < 0 || result >= 0 && index >= result) continue;
            result = index;
        }
        return result;
    }

    public static int indexOfFirst(String s, String ... pieces) {
        int result = -1;
        for (String piece : pieces) {
            int index = s.indexOf(piece);
            if (index < 0 || result >= 0 && index >= result) continue;
            result = index;
        }
        return result;
    }

    public static String prefix(String s, int delim) {
        int index = s.indexOf(delim);
        return index == -1 ? s : s.substring(0, index);
    }

    public static String removePrefix(String s, int delim) {
        int index = s.indexOf(delim);
        return index == -1 ? s : s.substring(index + 1);
    }

    public static String suffix(String s, int delim) {
        int index = s.lastIndexOf(delim);
        return index == -1 ? s : s.substring(index + 1);
    }

    public static String removeSuffix(String s, int delim) {
        int index = s.lastIndexOf(delim);
        return index == -1 ? s : s.substring(0, index);
    }

    public static SplitString splitWithParens(String s, String delimRegex) {
        return new StringSplitter(s, delimRegex, 0, Bracket.PARENTHESES).split();
    }

    public static SplitString splitWithParens(String s, String delimRegex, int limit) {
        return new StringSplitter(s, delimRegex, limit, Bracket.PARENTHESES).split();
    }

    public static SplitString split(String s, String delimRegex, Bracket ... brackets) {
        return new StringSplitter(s, delimRegex, 0, brackets).split();
    }

    public static SplitString split(String s, String delimRegex, int limit, Bracket ... brackets) {
        return new StringSplitter(s, delimRegex, limit, brackets).split();
    }

    public static String toHexString(byte[] bs) {
        return TextUtil.toHexString(bs, 0, bs.length);
    }

    public static String toHexString(byte[] bs, int offset, int length) {
        StringBuilder result = new StringBuilder();
        for (int i = offset; i < offset + length; ++i) {
            if (i > offset) {
                result.append(' ');
            }
            byte b = bs[i];
            result.append(Character.forDigit((b & 0xF0) >> 4, 16));
            result.append(Character.forDigit(b & 0xF, 16));
        }
        return result.toString();
    }

    public static boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isOctalDigit(char c) {
        return c >= '0' && c <= '7';
    }

    public static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static String unicodeEscape(String s) {
        return new UnicodeTranslator(){

            protected void handleStandardChar(char c, boolean backslashed) {
                if (c > '\u007f') {
                    if (backslashed) {
                        this._result.append("\\u005c");
                    }
                    this._result.append("\\u");
                    this._result.append(TextUtil.padLeft(Integer.toHexString(c), '0', 4));
                    this._changed = true;
                } else {
                    if (backslashed) {
                        this._result.append('\\');
                    }
                    this._result.append(c);
                }
            }

            protected void handlePartialEscape(String escape) {
                this._result.append("\\u005cu");
                this._result.append(escape);
                this._changed = true;
            }

            protected void handleCompleteEscape(String escape) {
                this._result.append("\\uu");
                this._result.append(escape);
                this._changed = true;
            }
        }.value(s);
    }

    public static String unicodeUnescapeOnce(String s) {
        return new UnicodeTranslator(){

            protected void handleStandardChar(char c, boolean backslashed) {
                if (backslashed) {
                    this._result.append('\\');
                }
                this._result.append(c);
            }

            protected void handlePartialEscape(String escape) {
                throw new IllegalArgumentException("Expected a hexadecimal digit after '\\u" + escape + "'");
            }

            protected void handleCompleteEscape(String escape) {
                if (escape.charAt(0) == 'u') {
                    this._result.append('\\');
                    this._result.append(escape);
                } else {
                    this._result.append((char)Integer.parseInt(escape, 16));
                }
                this._changed = true;
            }
        }.value(s);
    }

    public static String unicodeUnescape(String s) {
        return new UnicodeTranslator(){

            protected void handleStandardChar(char c, boolean backslashed) {
                if (backslashed) {
                    this._result.append('\\');
                }
                this._result.append(c);
            }

            protected void handlePartialEscape(String escape) {
                throw new IllegalArgumentException("Expected a hexadecimal digit after '\\u" + escape + "'");
            }

            protected void handleCompleteEscape(String escape) {
                int firstDigit = escape.lastIndexOf(117) + 1;
                this._result.append((char)Integer.parseInt(escape.substring(firstDigit), 16));
                this._changed = true;
            }
        }.value(s);
    }

    public static String javaEscape(String s) {
        return new StringTranslator(){

            protected void processChar(char c) {
                switch (c) {
                    case '\b': {
                        this._result.append("\\b");
                        this._changed = true;
                        break;
                    }
                    case '\t': {
                        this._result.append("\\t");
                        this._changed = true;
                        break;
                    }
                    case '\n': {
                        this._result.append("\\n");
                        this._changed = true;
                        break;
                    }
                    case '\f': {
                        this._result.append("\\f");
                        this._changed = true;
                        break;
                    }
                    case '\r': {
                        this._result.append("\\r");
                        this._changed = true;
                        break;
                    }
                    case '\"': {
                        this._result.append("\\\"");
                        this._changed = true;
                        break;
                    }
                    case '\'': {
                        this._result.append("\\'");
                        this._changed = true;
                        break;
                    }
                    case '\\': {
                        this._result.append("\\\\");
                        this._changed = true;
                        break;
                    }
                    default: {
                        if (c < ' ' || c == '\u007f') {
                            this._result.append('\\');
                            this._result.append(TextUtil.padLeft(Integer.toOctalString(c), '0', 3));
                            this._changed = true;
                            break;
                        }
                        this._result.append(c);
                    }
                }
            }

            protected void finish() {
            }
        }.value(s);
    }

    public static String javaUnescape(String s) {
        return new StringTranslator(){
            private JState _state = JState.START;
            private final StringBuilder _buffer = new StringBuilder();

            private void reset(char c) {
                this._result.append((char)Integer.parseInt(this._buffer.toString(), 8));
                this._buffer.delete(0, this._buffer.length());
                this._state = JState.START;
                if (c == '\\') {
                    this._state = JState.BACKSLASH;
                    this._changed = true;
                } else {
                    this._result.append(c);
                }
            }

            protected void processChar(char c) {
                block0 : switch (this._state) {
                    case START: {
                        if (c == '\\') {
                            this._state = JState.BACKSLASH;
                            this._changed = true;
                            break;
                        }
                        this._result.append(c);
                        break;
                    }
                    case BACKSLASH: {
                        switch (c) {
                            case 'b': {
                                this._result.append('\b');
                                this._state = JState.START;
                                break block0;
                            }
                            case 't': {
                                this._result.append('\t');
                                this._state = JState.START;
                                break block0;
                            }
                            case 'n': {
                                this._result.append('\n');
                                this._state = JState.START;
                                break block0;
                            }
                            case 'f': {
                                this._result.append('\f');
                                this._state = JState.START;
                                break block0;
                            }
                            case 'r': {
                                this._result.append('\r');
                                this._state = JState.START;
                                break block0;
                            }
                            case '\"': {
                                this._result.append('\"');
                                this._state = JState.START;
                                break block0;
                            }
                            case '\'': {
                                this._result.append('\'');
                                this._state = JState.START;
                                break block0;
                            }
                            case '\\': {
                                this._result.append('\\');
                                this._state = JState.START;
                                break block0;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': {
                                this._buffer.append(c);
                                this._state = JState.DIG1;
                                break block0;
                            }
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': {
                                this._buffer.append(c);
                                this._state = JState.DIG2;
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException("'" + c + "' after '\\'");
                    }
                    case DIG1: {
                        if (TextUtil.isOctalDigit(c)) {
                            this._buffer.append(c);
                            this._state = JState.DIG2;
                            break;
                        }
                        this.reset(c);
                        break;
                    }
                    case DIG2: {
                        if (TextUtil.isOctalDigit(c)) {
                            this._buffer.append(c);
                            this._state = JState.DIG3;
                            break;
                        }
                        this.reset(c);
                        break;
                    }
                    case DIG3: {
                        this.reset(c);
                    }
                }
            }

            protected void finish() {
                switch (this._state) {
                    case START: {
                        break;
                    }
                    case BACKSLASH: {
                        throw new IllegalArgumentException("Nothing after after '\\'");
                    }
                    default: {
                        this._result.append((char)Integer.parseInt(this._buffer.toString(), 8));
                    }
                }
            }
        }.value(s);
    }

    public static String regexEscape(String s) {
        return new StringTranslator(){

            protected void processChar(char c) {
                switch (c) {
                    case '\t': {
                        this._result.append("\\t");
                        this._changed = true;
                        break;
                    }
                    case '\n': {
                        this._result.append("\\n");
                        this._changed = true;
                        break;
                    }
                    case '\r': {
                        this._result.append("\\r");
                        this._changed = true;
                        break;
                    }
                    case '\f': {
                        this._result.append("\\f");
                        this._changed = true;
                        break;
                    }
                    case '\u0007': {
                        this._result.append("\\a");
                        this._changed = true;
                        break;
                    }
                    case '\u001b': {
                        this._result.append("\\e");
                        this._changed = true;
                        break;
                    }
                    default: {
                        if (c < ' ' || c == '\u007f') {
                            this._result.append("\\x");
                            this._result.append(TextUtil.padLeft(Integer.toHexString(c), '0', 2));
                            this._changed = true;
                            break;
                        }
                        if (c > ' ' && c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z' && c < '\u007f') {
                            this._result.append('\\');
                            this._result.append(c);
                            this._changed = true;
                            break;
                        }
                        this._result.append(c);
                    }
                }
            }

            protected void finish() {
            }
        }.value(s);
    }

    public static String sgmlEscape(String s, final Map<Character, String> entities, final boolean convertToAscii) {
        return new StringTranslator(){

            protected void processChar(char c) {
                String entity = (String)entities.get(Character.valueOf(c));
                if (entity != null) {
                    this._result.append('&');
                    this._result.append(entity);
                    this._result.append(';');
                    this._changed = true;
                } else if (convertToAscii && c > '\u007f') {
                    this._result.append("&#");
                    this._result.append((int)c);
                    this._result.append(';');
                    this._changed = true;
                } else {
                    this._result.append(c);
                }
            }

            protected void finish() {
            }
        }.value(s);
    }

    public static String sgmlUnescape(String s, final Map<String, Character> entities) {
        return new StringTranslator(){
            private SGMLState _state = SGMLState.START;
            private final StringBuilder _buffer = new StringBuilder();

            private void reset() {
                this._buffer.delete(0, this._buffer.length());
                this._state = SGMLState.START;
            }

            protected void processChar(char c) {
                switch (this._state) {
                    case START: {
                        if (c == '&') {
                            this._state = SGMLState.AMP;
                            this._changed = true;
                            break;
                        }
                        this._result.append(c);
                        break;
                    }
                    case AMP: {
                        if (c == '#') {
                            this._state = SGMLState.NUM;
                            break;
                        }
                        if (c == ';') {
                            throw new IllegalArgumentException("Missing entity name");
                        }
                        this._state = SGMLState.NAME;
                        this._buffer.append(c);
                        break;
                    }
                    case NAME: {
                        if (c == ';') {
                            Character namedChar = (Character)entities.get(this._buffer.toString());
                            if (namedChar == null) {
                                throw new IllegalArgumentException("Unrecognized entity name: '" + this._buffer.toString() + "'");
                            }
                            this._result.append(namedChar.charValue());
                            this.reset();
                            break;
                        }
                        this._buffer.append(c);
                        break;
                    }
                    case NUM: {
                        if (c == 'x') {
                            this._state = SGMLState.HEX_DIGITS;
                            break;
                        }
                        if (TextUtil.isDecimalDigit(c)) {
                            this._state = SGMLState.DEC_DIGITS;
                            this._buffer.append(c);
                            break;
                        }
                        throw new IllegalArgumentException("Expected decimal digit: '" + c + "'");
                    }
                    case HEX_DIGITS: {
                        if (c == ';') {
                            if (this._buffer.length() == 0) {
                                throw new IllegalArgumentException("Expected hexadecimal digit: ';'");
                            }
                            this._result.append((char)Integer.parseInt(this._buffer.toString(), 16));
                            this.reset();
                            break;
                        }
                        if (TextUtil.isHexDigit(c)) {
                            this._buffer.append(c);
                            break;
                        }
                        throw new IllegalArgumentException("Expected hexadecimal digit: '" + c + "'");
                    }
                    case DEC_DIGITS: {
                        if (c == ';') {
                            this._result.append((char)Integer.parseInt(this._buffer.toString()));
                            this.reset();
                            break;
                        }
                        if (TextUtil.isDecimalDigit(c)) {
                            this._buffer.append(c);
                            break;
                        }
                        throw new IllegalArgumentException("Expected decimal digit: '" + c + "'");
                    }
                }
            }

            protected void finish() {
                if (this._state != SGMLState.START) {
                    throw new IllegalArgumentException("Unfinished entity");
                }
            }
        }.value(s);
    }

    public static String xmlEscape(String s) {
        return TextUtil.sgmlEscape(s, XML_ENTITIES.value().functionMap(), true);
    }

    public static String xmlEscape(String s, boolean convertToAscii) {
        return TextUtil.sgmlEscape(s, XML_ENTITIES.value().functionMap(), convertToAscii);
    }

    public static String xmlUnescape(String s) {
        return TextUtil.sgmlUnescape(s, XML_ENTITIES.value().injectionMap());
    }

    public static String htmlEscape(String s) {
        return TextUtil.sgmlEscape(s, HTML_ENTITIES.value().functionMap(), true);
    }

    public static String htmlUnescape(String s) {
        return TextUtil.sgmlUnescape(s, HTML_ENTITIES.value().injectionMap());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SGMLState {
        START,
        AMP,
        NAME,
        NUM,
        HEX_DIGITS,
        DEC_DIGITS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JState {
        START,
        BACKSLASH,
        DIG1,
        DIG2,
        DIG3;

    }

    private static abstract class UnicodeTranslator
    extends StringTranslator {
        private State _state = State.START;
        private StringBuilder _buffer = new StringBuilder();

        UnicodeTranslator() {
        }

        protected abstract void handleStandardChar(char var1, boolean var2);

        protected abstract void handlePartialEscape(String var1);

        protected abstract void handleCompleteEscape(String var1);

        private void reset(char c) {
            this.handlePartialEscape(this._buffer.toString());
            this._buffer.delete(0, this._buffer.length());
            this._state = State.START;
            if (c == '\\') {
                this._state = State.BACKSLASH;
            } else {
                this.handleStandardChar(c, false);
            }
        }

        protected final void processChar(char c) {
            switch (this._state) {
                case START: {
                    if (c == '\\') {
                        this._state = State.BACKSLASH;
                        break;
                    }
                    this.handleStandardChar(c, false);
                    break;
                }
                case BACKSLASH: {
                    if (c == 'u') {
                        this._state = State.U;
                        break;
                    }
                    this.handleStandardChar(c, true);
                    this._state = State.START;
                    break;
                }
                case U: {
                    if (TextUtil.isHexDigit(c)) {
                        this._buffer.append(c);
                        this._state = State.DIG1;
                        break;
                    }
                    if (c == 'u') break;
                    this.reset(c);
                    break;
                }
                case DIG1: {
                    if (TextUtil.isHexDigit(c)) {
                        this._buffer.append(c);
                        this._state = State.DIG2;
                        break;
                    }
                    this.reset(c);
                    break;
                }
                case DIG2: {
                    if (TextUtil.isHexDigit(c)) {
                        this._buffer.append(c);
                        this._state = State.DIG3;
                        break;
                    }
                    this.reset(c);
                    break;
                }
                case DIG3: {
                    if (TextUtil.isHexDigit(c)) {
                        this._buffer.append(c);
                        this.handleCompleteEscape(this._buffer.toString());
                        this._buffer.delete(0, this._buffer.length());
                        this._state = State.START;
                        break;
                    }
                    this.reset(c);
                }
            }
        }

        protected final void finish() {
            switch (this._state) {
                case START: {
                    break;
                }
                case BACKSLASH: {
                    this.handleStandardChar('\\', false);
                    break;
                }
                default: {
                    this.handlePartialEscape(this._buffer.toString());
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum State {
            START,
            BACKSLASH,
            U,
            DIG1,
            DIG2,
            DIG3;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class StringTranslator
    implements Lambda<String, String> {
        protected final StringBuilder _result = new StringBuilder();
        protected boolean _changed = false;

        StringTranslator() {
        }

        @Override
        public final String value(String s) {
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                this.processChar(s.charAt(i));
            }
            this.finish();
            return this._changed ? this._result.toString() : s;
        }

        protected abstract void processChar(char var1);

        protected abstract void finish();
    }

    private static class StringSplitter {
        private final List<String> _splits;
        private final List<String> _delims;
        private final String _s;
        private final Matcher _delim;
        private final Bracket[] _brackets;
        private final Matcher[] _lefts;
        private final Matcher[] _rights;
        private final LinkedList<Integer> _stack;
        private int _remaining;

        public StringSplitter(String s, String delimRegex, int limit, Bracket ... brackets) {
            if (limit > 0 && limit < 10) {
                this._splits = new ArrayList<String>(limit);
                this._delims = new ArrayList<String>(limit);
            } else {
                this._splits = new ArrayList<String>();
                this._delims = new ArrayList<String>();
            }
            this._s = s;
            this._delim = Pattern.compile(delimRegex).matcher(this._s);
            this._brackets = brackets;
            this._lefts = new Matcher[this._brackets.length];
            this._rights = new Matcher[this._brackets.length];
            for (int i = 0; i < this._brackets.length; ++i) {
                this._lefts[i] = this._brackets[i].left().matcher(this._s);
                this._rights[i] = this._brackets[i].right().matcher(this._s);
            }
            this._stack = new LinkedList();
            this._remaining = limit;
        }

        public SplitString split() {
            int rest = 0;
            int cursor = 0;
            while (this._remaining != 1) {
                if (this._delim.find()) {
                    int dStart = this._delim.start();
                    int dEnd = this._delim.end();
                    this.processStack(cursor, dStart, false);
                    if (this._stack.isEmpty()) {
                        this._splits.add(this._s.substring(rest, dStart));
                        this._delims.add(this._s.substring(dStart, dEnd));
                        if (this._remaining > 1) {
                            --this._remaining;
                        }
                        rest = dEnd;
                        cursor = dEnd;
                        continue;
                    }
                    cursor = this.processStack(dStart, this._s.length(), true);
                    this._delim.region(cursor, this._s.length());
                    continue;
                }
                this._remaining = 1;
            }
            return new SplitString(this._splits, this._delims, this._s.substring(rest));
        }

        private int processStack(int rangeStart, int rangeEnd, boolean stopWhenEmpty) {
            boolean searchLefts;
            Boolean[] leftMatches = new Boolean[this._lefts.length];
            Boolean[] rightMatches = new Boolean[this._rights.length];
            int cursor = rangeStart;
            boolean bl = searchLefts = this._stack.isEmpty() || this._brackets[this._stack.getFirst()].nests();
            while (!(cursor >= rangeEnd || stopWhenEmpty && this._stack.isEmpty())) {
                Boolean matched;
                Matcher m;
                int i;
                int first = rangeEnd;
                int firstIndex = -1;
                boolean firstIsLeft = false;
                if (!this._stack.isEmpty()) {
                    i = this._stack.getFirst();
                    m = this._rights[i];
                    matched = rightMatches[i];
                    if (matched == null || matched.booleanValue() && m.start() < cursor || !matched.booleanValue() && m.regionEnd() < first) {
                        rightMatches[i] = matched = Boolean.valueOf(m.region(cursor, first).find());
                    }
                    if (matched.booleanValue() && m.start() < first) {
                        first = m.start();
                        firstIndex = i;
                        firstIsLeft = false;
                    }
                }
                if (searchLefts) {
                    for (i = 0; i < this._lefts.length; ++i) {
                        m = this._lefts[i];
                        matched = leftMatches[i];
                        if (matched == null || matched.booleanValue() && m.start() < cursor || !matched.booleanValue() && m.regionEnd() < first) {
                            leftMatches[i] = matched = Boolean.valueOf(m.region(cursor, first).find());
                        }
                        if (!matched.booleanValue() || m.start() >= first) continue;
                        first = m.start();
                        firstIndex = i;
                        firstIsLeft = true;
                    }
                }
                if (first < rangeEnd) {
                    if (firstIsLeft) {
                        this._stack.addFirst(firstIndex);
                        cursor = this._lefts[firstIndex].end();
                        searchLefts = this._brackets[firstIndex].nests();
                        continue;
                    }
                    this._stack.removeFirst();
                    cursor = this._rights[firstIndex].end();
                    searchLefts = true;
                    continue;
                }
                cursor = rangeEnd;
            }
            return cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SplitString
    implements Serializable {
        private final List<String> _splits;
        private final List<String> _delims;
        private final String _rest;

        private SplitString(List<String> splits, List<String> delims, String rest) {
            this._splits = Collections.unmodifiableList(splits);
            this._delims = Collections.unmodifiableList(delims);
            this._rest = rest;
        }

        public List<String> splits() {
            return this._splits;
        }

        public List<String> delimiters() {
            return this._delims;
        }

        public String rest() {
            return this._rest;
        }

        public String[] array() {
            String[] result = new String[this._splits.size() + 1];
            this._splits.toArray(result);
            result[this._splits.size()] = this._rest;
            return result;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("SplitString: ");
            for (Pair pair : IterUtil.zip(this._splits, this._delims)) {
                result.append("(").append((String)pair.first()).append(") ");
                result.append("[").append((String)pair.second()).append("] ");
            }
            result.append("+ (").append(this._rest).append(")");
            return result.toString();
        }
    }
}

