/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.iter.EmptyIterator;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollapsedIterator<T>
implements Iterator<T>,
Composite {
    private Iterator<? extends T> _i = EmptyIterator.make();
    private Iterator<? extends T> _last;
    private final Iterator<? extends Iterator<? extends T>> _rest;

    public CollapsedIterator(Iterator<? extends Iterator<? extends T>> iters) {
        this._rest = iters;
        this.advance();
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._rest) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._rest) + 1;
    }

    @Override
    public boolean hasNext() {
        return this._i.hasNext();
    }

    @Override
    public T next() {
        T result = this._i.next();
        this._last = this._i;
        this.advance();
        return result;
    }

    @Override
    public void remove() {
        this._last.remove();
    }

    private void advance() {
        while (!this._i.hasNext() && this._rest.hasNext()) {
            this._i = this._rest.next();
        }
    }

    public static <T> CollapsedIterator<T> make(Iterator<? extends Iterator<? extends T>> iters) {
        return new CollapsedIterator<T>(iters);
    }
}

