/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.context;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.samsung.memoryanalysis.context.Variable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Context {
    private final Context parent;
    private final String iidString;
    private Map<String, Variable> variables = HashMapFactory.make();
    private Set<String> referencedNames = HashSetFactory.make();
    private boolean isLive = true;

    public Context getParent() {
        return this.parent;
    }

    private Context() {
        this.iidString = "GLOBAL";
        this.parent = null;
    }

    public boolean isLive() {
        return this.isLive;
    }

    public Context(Context parent, String iidString) {
        this.iidString = iidString;
        if (parent == null) {
            throw new IllegalArgumentException("Null parent only allowed for global");
        }
        this.parent = parent;
    }

    public static Context makeGlobal() {
        return new Context();
    }

    public boolean isGlobal() {
        return this.parent == null;
    }

    public void newVariable(int iid, String name, int objectId) {
        if (!this.variables.containsKey(name)) {
            this.variables.put(name, new Variable(iid, objectId));
        }
    }

    public boolean hasVariable(String name) {
        return this.variables.containsKey(name);
    }

    public void markReferenced(Set<String> names) {
        if (names == null) {
            return;
        }
        this.referencedNames.addAll(names);
    }

    public Set<String> seal() {
        HashSet work = HashSetFactory.make(this.referencedNames);
        Context c = this;
        while (!c.isGlobal()) {
            for (Map.Entry<String, Variable> v : c.variables.entrySet()) {
                if (!work.contains(v.getKey())) continue;
                v.getValue().makeReferenced();
                work.remove(v.getKey());
            }
            c = c.parent;
        }
        this.referencedNames = null;
        this.isLive = false;
        HashSet res = HashSetFactory.make();
        for (Map.Entry<String, Variable> v : this.variables.entrySet()) {
            if (v.getValue().isReferenced()) continue;
            res.add(v.getKey());
        }
        for (String s : res) {
            this.variables.remove(s);
        }
        this.variables = Collections.unmodifiableMap(this.variables);
        return res;
    }

    public String toString() {
        return "C(" + this.iidString + ")";
    }

    public Context writeToVariable(int iid, String name, int objectId) {
        Context c = this;
        while (c != null) {
            if (c.hasVariable(name)) {
                c.variables.get(name).setValue(objectId);
                return c;
            }
            if (c.isGlobal()) {
                c.newVariable(iid, name, objectId);
                return c;
            }
            c = c.parent;
        }
        throw new IllegalStateException();
    }
}

