// Generated by CoffeeScript 1.8.0
(function() {
  var align, col, colors, helpers, i18n, sloc, stat;

  sloc = require('../sloc');

  i18n = require('../i18n');

  helpers = require('../helpers');

  align = helpers.alignRight;

  col = 20;

  colors = {
    source: "green",
    comment: "cyan",
    empty: "yellow"
  };

  stat = function(data, options) {
    var c, i, k, n, str, x;
    if (data.badFile) {
      return "" + (align(i18n.en.Error, col)) + " :  " + i18n.en.BadFile;
    }
    str = (function() {
      var _i, _len, _ref, _results;
      _ref = options.keys;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        k = _ref[_i];
        if (!((x = data.stats[k]) != null)) {
          continue;
        }
        n = ((c = colors[k]) != null) && ((i = String(x)[c]) != null) ? i : x;
        _results.push("" + (align(i18n.en[k], col)) + " :  " + n);
      }
      return _results;
    })();
    return str.join('\n');
  };

  module.exports = function(data, options, fmtOpts) {
    var badFiles, bl, d, f, fileCount, result, _ref;
    if (options == null) {
      options = {};
    }
    if (((_ref = options.keys) != null ? _ref.length : void 0) === 1 && !options.reportDetails) {
      return data.summary[options.keys[0]];
    }
    if (options.keys == null) {
      options.keys = sloc.keys;
    }
    result = "\n---------- " + i18n.en.Result + " ------------\n\n";
    result += stat({
      stats: data.summary
    }, options);
    badFiles = data.files.filter(function(x) {
      return x.badFile;
    });
    fileCount = data.files.length - badFiles.length;
    result += "\n\n" + i18n.en.NumberOfFilesRead + " :  " + fileCount;
    if (bl = badFiles.length > 0) {
      result += "\n" + (align(i18n.en.BrokenFiles, col)) + " :  " + (String(badFiles.length).red);
    }
    if (options.details && data.files.length > 1) {
      result += "\n\n---------- " + i18n.en.Details + " -----------\n";
      d = (function() {
        var _i, _len, _ref1, _results;
        _ref1 = data.files;
        _results = [];
        for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
          f = _ref1[_i];
          _results.push("\n\n--- " + f.path + "\n\n" + (stat(f, options)));
        }
        return _results;
      })();
      result += d.join('');
    }
    return result += "\n\n------------------------------\n";
  };

}).call(this);
