/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.view;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;

public class mxSpaceManager
extends mxEventSource {
    protected mxGraph graph;
    protected boolean enabled;
    protected boolean shiftRightwards;
    protected boolean shiftDownwards;
    protected boolean extendParents;
    protected mxEventSource.mxIEventListener resizeHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object source, mxEventObject evt) {
            if (mxSpaceManager.this.isEnabled()) {
                mxSpaceManager.this.cellsResized((Object[])evt.getProperty("cells"));
            }
        }
    };

    public mxSpaceManager(mxGraph graph) {
        this.setGraph(graph);
    }

    public boolean isCellIgnored(Object cell) {
        return !this.getGraph().getModel().isVertex(cell);
    }

    public boolean isCellShiftable(Object cell) {
        return this.getGraph().getModel().isVertex(cell) && this.getGraph().isCellMovable(cell);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean isShiftRightwards() {
        return this.shiftRightwards;
    }

    public void setShiftRightwards(boolean shiftRightwards) {
        this.shiftRightwards = shiftRightwards;
    }

    public boolean isShiftDownwards() {
        return this.shiftDownwards;
    }

    public void setShiftDownwards(boolean shiftDownwards) {
        this.shiftDownwards = shiftDownwards;
    }

    public boolean isExtendParents() {
        return this.extendParents;
    }

    public void setExtendParents(boolean extendParents) {
        this.extendParents = extendParents;
    }

    public mxGraph getGraph() {
        return this.graph;
    }

    public void setGraph(mxGraph graph) {
        if (this.graph != null) {
            this.graph.removeListener(this.resizeHandler);
        }
        this.graph = graph;
        if (this.graph != null) {
            this.graph.addListener("resizeCells", this.resizeHandler);
            this.graph.addListener("foldCells", this.resizeHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cellsResized(Object[] cells) {
        if (cells != null) {
            mxIGraphModel model = this.getGraph().getModel();
            model.beginUpdate();
            try {
                for (int i = 0; i < cells.length; ++i) {
                    if (this.isCellIgnored(cells[i])) continue;
                    this.cellResized(cells[i]);
                    break;
                }
            }
            finally {
                model.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cellResized(Object cell) {
        mxGraph graph = this.getGraph();
        mxGraphView view = graph.getView();
        mxIGraphModel model = graph.getModel();
        mxCellState state = view.getState(cell);
        mxCellState pstate = view.getState(model.getParent(cell));
        if (state != null && pstate != null) {
            Object[] cells = this.getCellsToShift(state);
            mxGeometry geo = model.getGeometry(cell);
            if (cells != null && geo != null) {
                mxPoint tr = view.getTranslate();
                double scale = view.getScale();
                double x0 = state.getX() - pstate.getOrigin().getX() - tr.getX() * scale;
                double y0 = state.getY() - pstate.getOrigin().getY() - tr.getY() * scale;
                double right = state.getX() + state.getWidth();
                double bottom = state.getY() + state.getHeight();
                double dx = state.getWidth() - geo.getWidth() * scale + x0 - geo.getX() * scale;
                double dy = state.getHeight() - geo.getHeight() * scale + y0 - geo.getY() * scale;
                double fx = 1.0 - geo.getWidth() * scale / state.getWidth();
                double fy = 1.0 - geo.getHeight() * scale / state.getHeight();
                model.beginUpdate();
                try {
                    for (int i = 0; i < cells.length; ++i) {
                        if (cells[i] == cell || !this.isCellShiftable(cells[i])) continue;
                        this.shiftCell(cells[i], dx, dy, x0, y0, right, bottom, fx, fy, this.isExtendParents() && graph.isExtendParent(cells[i]));
                    }
                }
                finally {
                    model.endUpdate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shiftCell(Object cell, double dx, double dy, double x0, double y0, double right, double bottom, double fx, double fy, boolean extendParent) {
        mxIGraphModel model;
        mxGeometry geo;
        mxGraph graph = this.getGraph();
        mxCellState state = graph.getView().getState(cell);
        if (state != null && (geo = (model = graph.getModel()).getGeometry(cell)) != null) {
            model.beginUpdate();
            try {
                if (this.isShiftRightwards()) {
                    if (state.getX() >= right) {
                        geo = (mxGeometry)geo.clone();
                        geo.translate(-dx, 0.0);
                    } else {
                        double tmpDx = Math.max(0.0, state.getX() - x0);
                        geo = (mxGeometry)geo.clone();
                        geo.translate(-fx * tmpDx, 0.0);
                    }
                }
                if (this.isShiftDownwards()) {
                    if (state.getY() >= bottom) {
                        geo = (mxGeometry)geo.clone();
                        geo.translate(0.0, -dy);
                    } else {
                        double tmpDy = Math.max(0.0, state.getY() - y0);
                        geo = (mxGeometry)geo.clone();
                        geo.translate(0.0, -fy * tmpDy);
                    }
                    if (geo != model.getGeometry(cell)) {
                        model.setGeometry(cell, geo);
                        if (extendParent) {
                            graph.extendParent(cell);
                        }
                    }
                }
            }
            finally {
                model.endUpdate();
            }
        }
    }

    protected Object[] getCellsToShift(mxCellState state) {
        mxGraph graph = this.getGraph();
        Object parent = graph.getModel().getParent(state.getCell());
        boolean down = this.isShiftDownwards();
        boolean right = this.isShiftRightwards();
        return graph.getCellsBeyond(state.getX() + (down ? 0.0 : state.getWidth()), state.getY() + (down && right ? 0.0 : state.getHeight()), parent, right, down);
    }

    public void destroy() {
        this.setGraph(null);
    }
}

