/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jsa.jalangi.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.tizen.web.jsa.JsaPlugin;
import org.tizen.web.jsa.jalangi.util.EnvironmentMgr;

public class CommandExecutor {
    public static void execJalangiCommand(String command) {
        File dir = new File(EnvironmentMgr.getJalangiDir());
        CommandExecutor.exec(command, dir, null);
    }

    public static void exec(String cmdString, File directory, InputStreamHandler handler) {
        block20: {
            InputStream is = null;
            ArrayList<String> command = new ArrayList<String>();
            if (EnvironmentMgr.isWindows) {
                command.add("cmd");
                command.add("/c");
            } else if (EnvironmentMgr.isMac) {
                command.add("/bin/bash");
                command.add("-c");
            } else {
                command.add("/bin/sh");
                command.add("-c");
            }
            command.add(cmdString);
            if (handler == null) {
                handler = new LineHandler(){

                    @Override
                    void realLine(String line) {
                    }
                };
            }
            Process proc = null;
            try {
                try {
                    proc = CommandExecutor.startProcess(command, directory);
                    if (handler != null) {
                        is = proc.getInputStream();
                        handler.handler(is);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JsaPlugin.printErrorToConsole(e);
                    if (proc != null) {
                        proc.destroy();
                    }
                    if (is == null) break block20;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    is = null;
                }
            }
            finally {
                if (proc != null) {
                    proc.destroy();
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    is = null;
                }
            }
        }
    }

    public static Process startProcess(ArrayList<String> cmdarray, File directory) throws IOException {
        Map<String, String> env;
        ProcessBuilder pb;
        if (EnvironmentMgr.isWindows) {
            pb = new ProcessBuilder(cmdarray);
            env = pb.environment();
            String newPath = env.get("Path");
            newPath = String.valueOf(EnvironmentMgr.NODE_BINARY_HOME) + File.pathSeparatorChar + newPath;
            env.put("Path", newPath);
        } else if (EnvironmentMgr.isMac) {
            pb = new ProcessBuilder(cmdarray);
            env = pb.environment();
            String newPath = env.get("PATH");
            newPath = String.valueOf(EnvironmentMgr.NODE_BINARY_HOME) + File.separator + "bin" + File.pathSeparatorChar + newPath;
            env.put("PATH", newPath);
        } else {
            pb = new ProcessBuilder(cmdarray);
            env = pb.environment();
            String newPath = env.get("PATH");
            newPath = String.valueOf(EnvironmentMgr.NODE_BINARY_HOME) + File.separator + "bin" + File.pathSeparatorChar + newPath;
            env.put("PATH", newPath);
        }
        pb.directory(directory);
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        return proc;
    }

    public static interface InputStreamHandler {
        public void handler(InputStream var1);
    }

    public static abstract class LineHandler
    implements InputStreamHandler {
        @Override
        public void handler(InputStream is) {
            block13: {
                BufferedReader br = null;
                try {
                    try {
                        br = new BufferedReader(new InputStreamReader(is));
                        String str = null;
                        while ((str = br.readLine()) != null) {
                            this.realLine(str);
                        }
                        br = null;
                    }
                    catch (Exception e) {
                        JsaPlugin.printErrorToConsole(e);
                        if (br == null) break block13;
                        try {
                            br.close();
                        }
                        catch (IOException e2) {
                            JsaPlugin.printErrorToConsole(e2);
                        }
                    }
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            JsaPlugin.printErrorToConsole(e);
                        }
                    }
                }
            }
        }

        abstract void realLine(String var1);
    }
}

