/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.shell;

import edu.rice.cs.plt.tuple.Option;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.List;
import kr.ac.kaist.jsaf.Shell;
import kr.ac.kaist.jsaf.analysis.cfg.CFG;
import kr.ac.kaist.jsaf.analysis.cfg.CFGBuilder;
import kr.ac.kaist.jsaf.analysis.cfg.DotWriter$;
import kr.ac.kaist.jsaf.analysis.typing.AddressManager$;
import kr.ac.kaist.jsaf.analysis.typing.Config$;
import kr.ac.kaist.jsaf.analysis.typing.InitHeap;
import kr.ac.kaist.jsaf.analysis.visualization.Visualization;
import kr.ac.kaist.jsaf.exceptions.StaticError;
import kr.ac.kaist.jsaf.exceptions.UserError;
import kr.ac.kaist.jsaf.nodes.IRRoot;
import kr.ac.kaist.jsaf.nodes_util.NodeUtil$;
import kr.ac.kaist.jsaf.useful.Pair;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CFGMain$
implements ScalaObject {
    public static final CFGMain$ MODULE$;

    static {
        new CFGMain$();
    }

    /*
     * WARNING - void declaration
     */
    public int cfgBuilder() {
        void var3_3;
        if (Shell.params.FileNames.length == 0) {
            throw new UserError("Need a file to build a control flow graph.");
        }
        List fileNames = JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.wrapRefArray((Object[])Shell.params.FileNames));
        String fileName = Shell.params.FileNames[0];
        AddressManager$.MODULE$.reset();
        if (Shell.params.opt_Test) {
            Config$.MODULE$.setTestMode(Shell.params.opt_Test);
            System.out.println("Test mode enabled.");
        }
        if (Shell.params.opt_Dom) {
            Config$.MODULE$.setDomMode();
            System.out.println("DOM mode enabled.");
        }
        if (Shell.params.opt_Tizen) {
            Config$.MODULE$.setTizenMode();
            System.out.println("Tizen mode enabled.");
        }
        if (Shell.params.opt_jQuery) {
            Config$.MODULE$.setJQueryMode();
            System.out.println("jQuery mode enabled.");
        }
        if (Shell.params.opt_Library) {
            Config$.MODULE$.setLibMode(Shell.params.opt_Library);
            System.out.println("Library mode enabled.");
        }
        Config$.MODULE$.setDefaultUnrollingCount(Shell.params.opt_unrollingCount);
        Config$.MODULE$.setDefaultForinUnrollingCount(Shell.params.opt_forinunrollingCount);
        int return_code = 0;
        Option<IRRoot> irOpt = Shell.fileToIR(fileNames, Shell.toOption(Shell.params.opt_OutFileName));
        if (irOpt.isSome()) {
            if (Shell.params.opt_loop) {
                Config$.MODULE$.setLoopMode();
            }
            IRRoot ir = (IRRoot)irOpt.unwrap();
            CFGBuilder builder = new CFGBuilder(ir);
            CFG cfg = builder.build();
            List<StaticError> errors = builder.getErrors();
            Object object = errors.isEmpty() ? BoxedUnit.UNIT : BoxesRunTime.boxToInteger((int)Shell.reportErrors(NodeUtil$.MODULE$.getFileName(ir), Shell.flattenErrors(errors), (Option<Pair<FileWriter, BufferedWriter>>)Option.none()));
            if (Shell.params.opt_Model) {
                InitHeap init = new InitHeap(cfg);
                init.initialize();
            }
            if (Shell.params.opt_Visual) {
                System.out.println("\nSeparating graphs...");
                Visualization vs = new Visualization(null, fileName, Shell.toOption(Shell.params.opt_OutFileName), cfg);
                vs.run(false);
            } else if (Shell.params.opt_OutFileName == null) {
                cfg.dump();
            } else {
                String outfile = Shell.params.opt_OutFileName;
                DotWriter$.MODULE$.write(cfg, new StringBuilder().append((Object)outfile).append((Object)".dot").toString(), new StringBuilder().append((Object)outfile).append((Object)".svg").toString(), "dot");
            }
        } else {
            return_code = -2;
        }
        return (int)var3_3;
    }

    private CFGMain$() {
        MODULE$ = this;
    }
}

