/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.graph.EdgeFilteredNumberedGraph;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.Path;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Acyclic {
    private Acyclic() {
    }

    public static <T> boolean isAcyclic(NumberedGraph<T> G, T root) {
        IBinaryNaturalRelation r = Acyclic.computeBackEdges(G, root);
        Iterator it = r.iterator();
        return !it.hasNext();
    }

    public static <T> IBinaryNaturalRelation computeBackEdges(NumberedGraph<T> G, T root) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        BasicNaturalRelation result = new BasicNaturalRelation();
        HashSet visited = HashSetFactory.make();
        HashSet onstack = HashSetFactory.make();
        Acyclic.dfs(result, root, G, visited, onstack);
        return result;
    }

    private static <T> void dfs(BasicNaturalRelation result, T root, NumberedGraph<T> G, Set<T> visited, Set<T> onstack) {
        visited.add(root);
        onstack.add(root);
        Iterator<T> it = G.getSuccNodes(root);
        while (it.hasNext()) {
            T dstNode = it.next();
            if (onstack.contains(dstNode)) {
                int src = G.getNumber(root);
                int dst = G.getNumber(dstNode);
                result.add(src, dst);
            }
            if (visited.contains(dstNode)) continue;
            Acyclic.dfs(result, dstNode, G, visited, onstack);
        }
        onstack.remove(root);
    }

    public static <T> boolean hasIncomingBackEdges(Path p, NumberedGraph<T> G, T root) {
        IBinaryNaturalRelation backedges = Acyclic.computeBackEdges(G, root);
        for (int index = 0; index < p.size(); ++index) {
            int gn = p.get(index);
            Iterator predIter = G.getPredNodes(G.getNode(gn));
            while (predIter.hasNext()) {
                if (!backedges.contains(G.getNumber(predIter.next()), gn)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> Collection<Path> computeAcyclicPaths(NumberedGraph<T> G, T root, T src, T sink, int max) {
        HashSet<Path> result = HashSetFactory.make();
        EdgeFilteredNumberedGraph acyclic = new EdgeFilteredNumberedGraph(G, Acyclic.computeBackEdges(G, root));
        HashSet worklist = HashSetFactory.make();
        Path sinkPath = Path.make(G.getNumber(sink));
        worklist.add(sinkPath);
        while (!worklist.isEmpty() && result.size() <= max) {
            Path p = (Path)worklist.iterator().next();
            worklist.remove(p);
            int first = p.get(0);
            if (first == G.getNumber(src)) {
                result.add(p);
                continue;
            }
            IntIterator it = acyclic.getPredNodeNumbers(acyclic.getNode(first)).intIterator();
            while (it.hasNext()) {
                worklist.add(Path.prepend(it.next(), p));
            }
        }
        return result;
    }
}

