/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Writer;
import kr.ac.kaist.jsaf.nodes.TabPrintWriter;
import kr.ac.kaist.jsaf.nodes.TreeWalker;

public class LosslessStringWalker
extends TreeWalker {
    protected final TabPrintWriter _out;

    public LosslessStringWalker(Writer writer, int tabSize) {
        this._out = new TabPrintWriter(writer, tabSize);
    }

    protected void openingDelim(char c) {
        this._out.print(c);
        this._out.indent();
    }

    protected void closingDelim(char c) {
        this._out.unindent();
        this._out.startLine("" + c);
    }

    @Override
    public boolean visitNode(Object node, String type, int fields) {
        this._out.print(type);
        this.openingDelim(':');
        return true;
    }

    @Override
    public boolean visitNodeField(String name, Object value) {
        this._out.startLine(name);
        this._out.print(" = ");
        return true;
    }

    @Override
    public void endNode(Object node, String type, int fields) {
        this._out.unindent();
    }

    @Override
    public boolean visitIterated(Object iterable) {
        this.openingDelim('{');
        return true;
    }

    @Override
    public boolean visitIteratedElement(int index, Object element) {
        this._out.startLine("* ");
        return true;
    }

    @Override
    public void endIterated(Object iterable, int size) {
        if (size > 0) {
            this._out.startLine();
        }
        this._out.unindent();
        this._out.print("}");
    }

    @Override
    public boolean visitNonEmptyOption(Object option) {
        this.openingDelim('(');
        this._out.startLine();
        return true;
    }

    @Override
    public void endNonEmptyOption(Object option) {
        this.closingDelim(')');
    }

    @Override
    public void visitEmptyOption(Object option) {
        this._out.print('~');
    }

    @Override
    public boolean visitTuple(Object tuple, int arity) {
        this.openingDelim('(');
        return true;
    }

    @Override
    public boolean visitTupleElement(int index, Object element) {
        if (index > 0) {
            this._out.startLine(", ");
        }
        return true;
    }

    @Override
    public void endTuple(Object tuple, int arity) {
        this.closingDelim(')');
    }

    @Override
    public void visitString(String s) {
        this._out.print('\"');
        this._out.printEscaped(s);
        this._out.print('\"');
    }

    @Override
    public void visitUnknownObject(Object o) {
        this.printSerialized(o);
        this._out.print(' ');
        this._out.printEscaped(o);
    }

    @Override
    public void visitNull() {
        this._out.print('_');
    }

    @Override
    public void visitBoolean(boolean b) {
        this._out.print(b);
    }

    @Override
    public void visitByte(byte b) {
        this._out.print(b);
    }

    @Override
    public void visitShort(short s) {
        this._out.print(s);
    }

    @Override
    public void visitInt(int i) {
        this._out.print(i);
    }

    @Override
    public void visitLong(long l) {
        this._out.print(l);
    }

    @Override
    public void visitChar(char c) {
        this._out.print('\'');
        this._out.printEscaped(Character.valueOf(c));
        this._out.print('\'');
    }

    @Override
    public void visitFloat(float f) {
        this._out.print(Float.toHexString(f));
    }

    @Override
    public void visitDouble(double d) {
        this._out.print(Double.toHexString(d));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printSerialized(Object o) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try (ObjectOutputStream objOut = new ObjectOutputStream(bs);){
            objOut.writeObject(o);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (byte b : bs.toByteArray()) {
            int unsigned = b & 0xFF;
            String num = Integer.toHexString(unsigned);
            if (num.length() == 1) {
                this._out.print("0");
            }
            this._out.print(num);
        }
    }
}

