/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jsa.safe.bugdetecter.ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.ProjectUtil;
import org.tizen.web.jsa.safe.bugdetecter.core.AnalysisDriver;
import org.tizen.web.jsa.safe.bugdetecter.nature.JSAnalysisNature;
import org.tizen.web.jsa.safe.bugdetecter.preferences.OSChecker;
import org.tizen.web.jsa.safe.bugdetecter.preferences.Settings;

public class AnalysisAction
extends AbstractHandler
implements IObjectActionDelegate {
    private IWorkbenchPart part;
    private ISelection selection;
    private IProject project;
    private ArrayList<String> jsFiles;

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }

    public void run(IAction action) {
        if (this.selection.isEmpty() || !(this.selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structured = (IStructuredSelection)this.selection;
        this.project = (IProject)structured.getFirstElement();
        this.doJSAnalysis(this.part.getSite().getShell());
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        this.project = this.getActiveProject(window);
        this.jsFiles = this.getSelectedFiles(window);
        Shell parentShell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        this.doJSAnalysis(parentShell);
        return null;
    }

    public void doJSAnalysis(Shell shell) {
        if (!this.validationTizenProject()) {
            MessageDialog.openError((Shell)shell, (String)"JS Code Analysis", (String)"Analyzer cannot find 'config.xml'.\nPlease check the selected project.");
            return;
        }
        try {
            ArrayList<String> CommandAgrs = this.buildCommandAgrs();
            if (CommandAgrs == null) {
                MessageDialog.openError((Shell)shell, (String)"JS Code Analysis", (String)("Analyzer library & DB not found in " + Settings.toolsPath + File.separator + "jsa" + "\nPlease check the configurations."));
            } else {
                JSAnalysisNature.setJsaNature(this.project);
                AnalysisDriver driver = new AnalysisDriver(shell, this.project);
                driver.analyze(CommandAgrs);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<String> buildCommandAgrs() throws IOException, URISyntaxException {
        ArrayList<String> tizenAPICheckCmd;
        String mobile21;
        String wearable23;
        TizenProjectDescription projectDes = ProjectUtil.getTizenProjectDescription((IProject)this.project);
        String platformName = projectDes.getPlatformName();
        String enabledCheckers = Settings.getStore().getString("SELECTED_RULE_CHECKER");
        String jsaToolsPath = "jsa";
        Boolean isWindow = false;
        isWindow = OSChecker.isWindows();
        ArrayList<String> Command2 = new ArrayList<String>();
        if (isWindow.booleanValue()) {
            Command2.add("cmd");
            Command2.add("/c");
        }
        Command2.add("java");
        Command2.add("-Xss32m");
        Command2.add("-Xmx512m");
        Command2.add("-cp");
        String safeJarPath = String.valueOf(Settings.toolsPath) + File.separator + jsaToolsPath + File.separator + "jsa-engine-1.1.jar";
        File safeJar = new File(safeJarPath);
        String jarLibsPath = String.valueOf(Settings.toolsPath) + File.separator + jsaToolsPath + File.separator + "lib";
        File libJar = new File(jarLibsPath);
        if (!(safeJar.exists() && libJar.exists() && libJar.isDirectory())) {
            return null;
        }
        Command2.add(String.valueOf(safeJarPath) + File.pathSeparator + jarLibsPath + File.separator + "*" + File.pathSeparator + ".");
        Command2.add("kr.ac.kaist.jsaf.Shell");
        Command2.add("ss-analysis");
        if (this.jsFiles == null) {
            Command2.add("-dir");
            Command2.add(this.project.getLocation().toOSString());
        } else if (this.jsFiles != null) {
            Command2.add("-js");
            Command2.addAll(this.jsFiles);
        }
        String dbPath = String.valueOf(Settings.toolsPath) + File.separator + jsaToolsPath + File.separator + "db";
        if (platformName.contains("mobile-2.3.1")) {
            String mobile23 = String.valueOf(dbPath) + File.separator + "mobile-2.3.db";
            if (new File(mobile23).exists()) {
                Command2.add("-widldb");
                Command2.add(mobile23);
            }
        } else if (platformName.contains("wearable-2.3.1")) {
            wearable23 = String.valueOf(dbPath) + File.separator + "wearable-2.3.db";
            if (new File(wearable23).exists()) {
                Command2.add("-widldb");
                Command2.add(wearable23);
            }
        } else if (platformName.contains("mobile-2.3")) {
            mobile21 = String.valueOf(dbPath) + File.separator + "mobile-2.3.db";
            if (new File(mobile21).exists()) {
                Command2.add("-widldb");
                Command2.add(mobile21);
            }
        } else if (platformName.contains("wearable-2.3")) {
            wearable23 = String.valueOf(dbPath) + File.separator + "wearable-2.3.db";
            if (new File(wearable23).exists()) {
                Command2.add("-widldb");
                Command2.add(wearable23);
            }
        } else if (platformName.contains("mobile-2.4")) {
            mobile21 = String.valueOf(dbPath) + File.separator + "mobile-2.4.db";
            if (new File(mobile21).exists()) {
                Command2.add("-widldb");
                Command2.add(mobile21);
            }
        } else if (platformName.contains("wearable-2.4")) {
            wearable23 = String.valueOf(dbPath) + File.separator + "wearable-2.3.db";
            if (new File(wearable23).exists()) {
                Command2.add("-widldb");
                Command2.add(wearable23);
            }
        } else if (platformName.contains("mobile-3.0")) {
            String mobile30 = String.valueOf(dbPath) + File.separator + "mobile-3.0.db";
            if (new File(mobile30).exists()) {
                Command2.add("-widldb");
                Command2.add(mobile30);
            }
        } else if (platformName.contains("wearable-3.0")) {
            String wearable30 = String.valueOf(dbPath) + File.separator + "wearable-3.0.db";
            if (new File(wearable30).exists()) {
                Command2.add("-widldb");
                Command2.add(wearable30);
            }
        } else if (platformName.contains("mobile")) {
            String mobile24 = String.valueOf(dbPath) + File.separator + "mobile-2.4.db";
            if (new File(mobile24).exists()) {
                Command2.add("-widldb");
                Command2.add(mobile24);
            }
        } else {
            wearable23 = String.valueOf(dbPath) + File.separator + "wearable-2.3.db";
            if (new File(wearable23).exists()) {
                Command2.add("-widldb");
                Command2.add(wearable23);
            }
        }
        if ((tizenAPICheckCmd = this.buildTizenAPICheckAgrs(enabledCheckers, platformName)) != null) {
            Command2.addAll(tizenAPICheckCmd);
        }
        Command2.add("-codingGuide");
        Command2.add("-jsa-plugin");
        Command2.add("-nostop");
        File configFile = new File(String.valueOf(Settings.toolsPath) + File.separator + jsaToolsPath + File.separator + "config.json");
        if (configFile.exists()) {
            Command2.add("-option");
            Command2.add(configFile.getAbsolutePath());
        }
        Command2.add("-timeout");
        Command2.add("360");
        return Command2;
    }

    public ArrayList<String> buildTizenAPICheckAgrs(String checkersNum, String platformName) throws IOException {
        ArrayList<String> Command2 = new ArrayList<String>();
        if (checkersNum.contains("38")) {
            Command2.add("-tizen-version-check");
            Command2.add(platformName);
        }
        if (checkersNum.contains("39")) {
            File widlprocxmlFile;
            String widlprocxmlPath = String.valueOf(InstallPathConfig.getPlatformDir().getAbsolutePath()) + File.separator + platformName;
            if (new File(widlprocxmlPath).exists()) {
                widlprocxmlPath = String.valueOf(widlprocxmlPath) + File.separator + "widlprocxmls" + File.separator + "tizen.widlprocxml";
            }
            if ((widlprocxmlFile = new File(widlprocxmlPath)).exists()) {
                Command2.add("-tizen-privilege-check");
                Command2.add(widlprocxmlFile.getCanonicalPath());
            }
        } else {
            return null;
        }
        return Command2;
    }

    public boolean validationTizenProject() {
        IFile appConfig = this.project.getFile("config.xml");
        if (!appConfig.exists()) {
            String projectPath = this.project.getLocation().toOSString();
            File indexFileA = new File(String.valueOf(projectPath) + File.separator + "index.html");
            File indexFileB = new File(String.valueOf(projectPath) + File.separator + "index.htm");
            if (!indexFileA.exists() && !indexFileB.exists()) {
                return false;
            }
        }
        return true;
    }

    private ArrayList<String> getSelectedFiles(IWorkbenchWindow window) {
        ArrayList<String> fileList = new ArrayList<String>();
        ISelectionService selectionService = window.getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection selectionsElement = (IStructuredSelection)selection;
            for (Object item : selectionsElement) {
                String res;
                if (!(item instanceof IResource) || (res = ((IResource)item).getFileExtension()) == null || !res.equals("js")) continue;
                fileList.add(((IResource)item).getLocation().toOSString());
            }
        }
        if (fileList.isEmpty()) {
            return null;
        }
        return fileList;
    }

    private IProject getActiveProject(IWorkbenchWindow window) {
        ISelectionService selectionService = window.getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection selectionsElement = (IStructuredSelection)selection;
            Object element = selectionsElement.getFirstElement();
            if (element instanceof IResource) {
                this.project = ((IResource)element).getProject();
            }
        } else {
            IEditorInput input;
            IEditorPart editorPart = window.getActivePage().getActiveEditor();
            if (editorPart != null && (input = editorPart.getEditorInput()) instanceof IFileEditorInput) {
                IFileEditorInput feinput = (IFileEditorInput)input;
                IFile file = feinput.getFile();
                this.project = file.getProject();
            }
        }
        return this.project;
    }
}

