/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.shell;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kr.ac.kaist.jsaf.bug_detector.BugItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvaceResultFormatter {
    private DocumentBuilderFactory docFactory = null;
    private DocumentBuilder docBuilder = null;
    private Document doc = null;

    public SvaceResultFormatter() {
        try {
            this.docFactory = DocumentBuilderFactory.newInstance();
            this.docBuilder = this.docFactory.newDocumentBuilder();
            this.doc = this.docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void printOutSvaceResult(ArrayList<BugItem> alarmList, String projectName, String outPath) {
        try {
            Element warningsXml = this.buildWarnings(alarmList);
            Element warningsExXml = this.buildEXWarnings(alarmList);
            Document docXml = this.buildSvresXml(warningsXml, warningsExXml, projectName);
            this.fileOut(docXml, outPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Element buildWarnings(ArrayList<BugItem> alarmList) {
        int id = 0;
        Document warningDoc = this.doc;
        Element rootElement = warningDoc.createElement("warnings");
        for (BugItem item : alarmList) {
            Element info = warningDoc.createElement("WarnInfo");
            info.setAttribute("id", String.valueOf(id));
            info.setAttribute("warnClass", String.valueOf(item.bugCategory));
            info.setAttribute("line", String.valueOf(item.lineNumber));
            info.setAttribute("file", this.getSourcePath(item.filePath));
            info.setAttribute("msg", item.message);
            info.setAttribute("status", "Default");
            info.setAttribute("details", "");
            info.setAttribute("comment", "");
            rootElement.appendChild(info);
            ++id;
        }
        return rootElement;
    }

    private Element buildEXWarnings(ArrayList<BugItem> alarmList) {
        int id = 0;
        Document warningDoc = this.doc;
        Element rootElement = warningDoc.createElement("warnings");
        for (BugItem item : alarmList) {
            Element infoEx = warningDoc.createElement("WarnInfoEx");
            rootElement.appendChild(infoEx);
            infoEx.setAttribute("id", String.valueOf(id));
            infoEx.setAttribute("zRate", "0.0");
            Element traces = warningDoc.createElement("traces");
            infoEx.appendChild(traces);
            Element RoleTraceInfo = warningDoc.createElement("RoleTraceInfo");
            RoleTraceInfo.setAttribute("role", "defect");
            traces.appendChild(RoleTraceInfo);
            Element locations = warningDoc.createElement("locations");
            RoleTraceInfo.appendChild(locations);
            Element LocInfo2 = warningDoc.createElement("LocInfo");
            LocInfo2.setAttribute("file", this.getSourcePath(item.filePath));
            LocInfo2.setAttribute("line", String.valueOf(item.lineNumber));
            LocInfo2.setAttribute("spec", "false");
            LocInfo2.setAttribute("info", "defect");
            locations.appendChild(LocInfo2);
            Element userAttributes = warningDoc.createElement("userAttributes");
            userAttributes.setAttribute("class", "tree-map");
            infoEx.appendChild(userAttributes);
            Element entry_01 = warningDoc.createElement("entry");
            userAttributes.appendChild(entry_01);
            Element string_01 = warningDoc.createElement("string");
            string_01.setTextContent(".comment");
            Element string_02 = warningDoc.createElement("string");
            entry_01.appendChild(string_01);
            entry_01.appendChild(string_02);
            Element entry_02 = warningDoc.createElement("entry");
            userAttributes.appendChild(entry_02);
            Element string_03 = warningDoc.createElement("string");
            string_03.setTextContent(".status");
            Element string_04 = warningDoc.createElement("string");
            string_04.setTextContent("Default");
            entry_02.appendChild(string_03);
            entry_02.appendChild(string_04);
            rootElement.appendChild(infoEx);
            ++id;
        }
        return rootElement;
    }

    private Document buildSvresXml(Element warningsXml, Element exWarningsXml, String appName) {
        Element rootElement = this.doc.createElement("object-stream");
        this.doc.appendChild(rootElement);
        Element svresVer = this.doc.createElement("SvResVersion");
        svresVer.setTextContent("2.0:Svace results format");
        Element svresResults = this.doc.createElement("SvResResults");
        rootElement.appendChild(svresVer);
        rootElement.appendChild(svresResults);
        Element projectName = this.doc.createElement("projectName");
        projectName.setTextContent(appName);
        Element projectSrcDir = this.doc.createElement("projectSrcDir");
        svresResults.appendChild(projectName);
        svresResults.appendChild(projectSrcDir);
        svresResults.appendChild(warningsXml);
        Element svresResultsEx = this.doc.createElement("SvResResultsEx");
        rootElement.appendChild(svresResultsEx);
        Element projectNameEx = this.doc.createElement("projectName");
        projectName.setTextContent(appName);
        svresResultsEx.appendChild(projectNameEx);
        svresResultsEx.appendChild(exWarningsXml);
        return this.doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileOut(Document docXml, String outPath) throws IOException {
        try (OutputStreamWriter fw = null;){
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(docXml);
            StringWriter sw = new StringWriter();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, new StreamResult(sw));
            String SvResContent = sw.getBuffer().toString();
            SvResContent = SvResContent.substring(55);
            fw = new FileWriter(new File(outPath));
            fw.write(SvResContent);
        }
    }

    private String getSourcePath(String path) {
        File src = new File(path);
        String srcPath = "";
        try {
            if (src.exists()) {
                srcPath = src.getCanonicalPath();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return srcPath;
    }
}

