/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.referencecounter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.functions.VoidFunction;
import com.samsung.memoryanalysis.context.Context;
import com.samsung.memoryanalysis.context.ContextAwareAnalysis;
import com.samsung.memoryanalysis.context.ContextListener;
import com.samsung.memoryanalysis.options.MemoryAnalysisOptions;
import com.samsung.memoryanalysis.referencecounter.AccessPath;
import com.samsung.memoryanalysis.referencecounter.DummyUnreachabilityAnalysis;
import com.samsung.memoryanalysis.referencecounter.UnreachabilityAwareAnalysis;
import com.samsung.memoryanalysis.referencecounter.heap.ContextOrObjectId;
import com.samsung.memoryanalysis.referencecounter.heap.HeapEdge;
import com.samsung.memoryanalysis.referencecounter.heap.ReferenceCountedHeapGraph;
import com.samsung.memoryanalysis.referencecounter.heap.Unreachability;
import com.samsung.memoryanalysis.traceparser.IIDMap;
import com.samsung.memoryanalysis.traceparser.SourceLocation;
import com.samsung.memoryanalysis.traceparser.Timer;
import com.samsung.memoryanalysis.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ReferenceCounter<T>
implements ContextAwareAnalysis<T> {
    private final ReferenceCountedHeapGraph graph;
    private final MemoryAnalysisOptions options;
    private Timer timer;
    private IIDMap iidMap;
    private final Set<Integer> returnValues = HashSetFactory.make();
    private final Set<Integer> ignoredObjects = HashSetFactory.make();
    private final Map<Integer, SourceLocation> allocationSites = HashMapFactory.make();
    private final Map<Integer, String> endOutput = HashMapFactory.make();
    private final UnreachabilityAwareAnalysis<T> client;
    private final Set<Integer> domNodes = HashSetFactory.make();
    private ContextListener contextInfo;
    public Map<Integer, Set<AccessPath>> accessPaths = HashMapFactory.make();

    public ReferenceCounter(ReferenceCountedHeapGraph e, UnreachabilityAwareAnalysis<T> client, MemoryAnalysisOptions o) {
        this.graph = e;
        this.options = o;
        this.client = client != null ? client : new DummyUnreachabilityAnalysis();
        e.setUnreachableCallback(new VoidFunction<Unreachability>(){

            public void apply(Unreachability f) {
                if (ReferenceCounter.this.ignoredObjects.contains(f.objId)) {
                    return;
                }
                ReferenceCounter.this.client.unreachableObject(f.iid, f.objId, f.time, ReferenceCounter.this.graph.getOutDegree(f.objId));
                if (ReferenceCounter.this.isRCVerbose()) {
                    SourceLocation allocSourceLoc = (SourceLocation)ReferenceCounter.this.allocationSites.get(f.objId);
                    assert (allocSourceLoc != null) : "no allocation site map entry for " + f.objId;
                    ReferenceCounter.this.endOutput.put(f.objId, String.format("Id: %-5d Alloc: %-40s Time: %-10d Loc: %s", f.objId, Util.makeRelative(allocSourceLoc), f.time, Util.makeRelative(ReferenceCounter.this.iidMap.get(f.iid))));
                }
            }
        });
        int cycleQueueLimit = o.getCycleQueuelimit();
        if (cycleQueueLimit != -1) {
            e.setCycleQueueLimit(cycleQueueLimit);
        }
    }

    public ReferenceCounter(ReferenceCountedHeapGraph e, UnreachabilityAwareAnalysis<T> client) {
        this(e, client, new MemoryAnalysisOptions());
    }

    @Override
    public void init(Timer timer, ContextListener list, IIDMap iidMap) {
        this.timer = timer;
        this.graph.setTimer(timer);
        this.iidMap = iidMap;
        this.contextInfo = list;
        this.graph.newContext(list.getGlobal(), 0);
        this.client.init(timer, iidMap);
        Map<Integer, Integer> map = this.options.getAccessPathObjects();
        if (map != null) {
            for (Map.Entry<Integer, Integer> e : map.entrySet()) {
                final Integer objectId = e.getKey();
                Integer printAtTime = e.getValue();
                timer.registerAlarm(printAtTime.intValue(), new VoidFunction<Long>(){

                    public void apply(Long v) {
                        ReferenceCounter.this.computeAccessPath(objectId);
                    }
                });
            }
        }
    }

    private void computeAccessPath(int objectId) {
        Set<AccessPath> p = new AccessPathComputer(ContextOrObjectId.make(objectId)).run();
        this.accessPaths.put(objectId, p);
    }

    private String getIID(ContextOrObjectId node) {
        switch (node.type) {
            case ID: {
                return this.allocationSites.get(node.getId()).toString();
            }
            case CONTEXT: {
                return node.getContext().toString();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void declare(int iid, String name, int objectId, Context context) {
        if (this.options.isIgnoreArguments() && name.equals("arguments")) {
            this.ignoredObjects.add(objectId);
        }
        this.graph.addContextReference(context, name, objectId, iid);
        this.graph.handleValue(objectId);
        this.client.declare(iid, name, objectId);
    }

    @Override
    public void create(int iid, int objectId) {
        if (objectId != 1) {
            this.graph.newObject(objectId);
            this.saveAllocationSite(objectId, iid);
            this.graph.handleValue(objectId);
        }
        this.client.create(iid, objectId, this.timer.currentTime(), this.domNodes.contains(objectId));
    }

    @Override
    public void createFun(int iid, int objectId, int prototypeId, int functionEnterIID, Set<String> namesReferencedByClosures, Context context) {
        this.graph.newObject(objectId);
        this.graph.newObject(prototypeId);
        if (!context.isGlobal()) {
            this.graph.addClosureReference(objectId, context);
        }
        this.graph.addObjectReference(objectId, "prototype", prototypeId, iid);
        this.saveAllocationSite(objectId, iid);
        this.saveAllocationSite(prototypeId, iid);
        this.graph.handleValue(objectId);
        this.graph.handleValue(prototypeId);
        this.client.createFun(iid, objectId, prototypeId, functionEnterIID, namesReferencedByClosures, context, this.timer.currentTime());
    }

    private void saveAllocationSite(int objectId, int iid) {
        this.allocationSites.put(objectId, this.iidMap.get(iid));
    }

    @Override
    public void putField(int iid, int baseId, String offset, int objectId) {
        if (this.ignoredObjects.contains(baseId)) {
            this.graph.handleValue(objectId);
            return;
        }
        this.graph.addObjectReference(baseId, offset, objectId, iid);
        this.graph.handleValue(objectId);
        this.client.putField(iid, baseId, offset, objectId);
    }

    @Override
    public void write(int iid, String name, int objectId, Context context) {
        this.graph.addContextReference(context, name, objectId, iid);
        this.graph.handleValue(objectId);
        this.client.write(iid, name, objectId);
    }

    @Override
    public void lastUse(int objectId, int iid, int time) {
        this.client.lastUse(objectId, iid, time);
    }

    @Override
    public void functionEnter(int iid, int funId, int callSiteIID, Context newContext) {
        this.graph.newContext(newContext, funId);
        this.client.functionEnter(iid, funId, callSiteIID, newContext, this.timer.currentTime());
    }

    @Override
    public void functionExit(int iid, Context calleeContext, Context callerContext, Set<String> unReferenced) {
        this.graph.contextSealed(calleeContext, unReferenced, iid);
        this.graph.flush(iid, this.returnValues, this.contextInfo.getLiveContexts());
        this.graph.functionExit(this.returnValues);
        this.client.functionExit(iid, calleeContext, unReferenced, this.timer.currentTime());
    }

    @Override
    public void topLevelFlush(int iid, Context currentContext) {
        this.graph.flush(iid, this.returnValues, this.contextInfo.getLiveContexts());
        this.client.topLevelFlush(iid);
    }

    @Override
    public T endExecution(Context global, Set<String> globalNames) {
        this.graph.contextSealed(global, globalNames, 0);
        this.graph.endFlush(0, this.returnValues, this.contextInfo.getLiveContexts());
        if (this.isTesting()) {
            this.graph.checkEmpty();
        }
        if (this.isRCVerbose()) {
            Collection<String> sortedVals = new TreeMap<Integer, String>(this.endOutput).values();
            for (String s : sortedVals) {
                System.out.println(s);
            }
        }
        this.accessPathJson();
        return this.client.endExecution(this.timer.currentTime());
    }

    private void accessPathJson() {
        if (!this.accessPaths.isEmpty()) {
            HashMap json = HashMapFactory.make();
            for (Map.Entry<Integer, Set<AccessPath>> x : this.accessPaths.entrySet()) {
                HashMap pathInfo = HashMapFactory.make();
                ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>();
                for (AccessPath p : x.getValue()) {
                    l.add(p.toMap());
                }
                pathInfo.put("accessPaths", l);
                json.put(x.getKey().toString(), pathInfo);
            }
            Gson out = new GsonBuilder().setPrettyPrinting().create();
            out.toJson((Object)json, (Appendable)System.out);
        }
    }

    @Override
    public void updateIID(int objId, int newIID) {
        this.saveAllocationSite(objId, newIID);
        this.client.updateIID(objId, newIID);
    }

    @Override
    public void debug(int iid, int oid, Context currentContext) {
        this.graph.flushCycleQueue(this.returnValues, ReferenceCountedHeapGraph.FlushType.FORCE, this.contextInfo.getLiveContexts());
        if (this.isTesting()) {
            System.out.printf("%s : RC(%s) = %d\n", Util.makeRelative(this.iidMap.get(iid)), Util.makeRelative(this.allocationSites.get(oid)), this.graph.referenceCount(oid));
        }
        this.client.debug(iid, oid);
    }

    private boolean isTesting() {
        return System.getProperty("testing", "").equals("yes");
    }

    private boolean isRCVerbose() {
        return System.getProperty("rcverbose", "").equals("yes");
    }

    @Override
    public void returnStmt(int objId) {
        this.returnValues.add(objId);
        this.client.returnStmt(objId);
    }

    @Override
    public void createDomNode(int iid, int objectId) {
        this.domNodes.add(objectId);
        this.create(iid, objectId);
    }

    @Override
    public void addDOMChild(int parentId, int childId) {
        this.graph.addDOMChildReference(parentId, childId);
        this.client.addDOMChild(parentId, childId, this.timer.currentTime());
    }

    @Override
    public void removeDOMChild(int parentId, int childId) {
        this.graph.removeDOMChildReference(parentId, childId);
        this.client.removeDOMChild(parentId, childId, this.timer.currentTime());
    }

    @Override
    public void addToChildSet(int iid, ContextOrObjectId parentNode, String name, ContextOrObjectId childNode) {
        this.graph.addToChildSet(parentNode, name, childNode);
        this.client.addToChildSet(iid, parentNode.getId(), name, childNode.getId());
    }

    @Override
    public void removeFromChildSet(int iid, ContextOrObjectId parentNode, String name, ContextOrObjectId childNode) {
        this.graph.removeFromChildSet(parentNode, name, childNode, iid);
        this.client.removeFromChildSet(iid, parentNode.getId(), name, childNode.getId());
    }

    @Override
    public void domRoot(int nodeId) {
        this.client.domRoot(nodeId);
    }

    @Override
    public void scriptEnter(int iid, String filename) {
        this.client.scriptEnter(iid, filename);
    }

    @Override
    public void scriptExit(int iid) {
        this.client.scriptExit(iid);
    }

    public class AccessPathComputer {
        private int MAX_AP = 10;
        final ContextOrObjectId node;
        final Set<ContextOrObjectId> visited;
        Set<AccessPath> res = HashSetFactory.make();

        public AccessPathComputer(ContextOrObjectId node) {
            this.node = node;
            this.visited = HashSetFactory.make();
        }

        private void walker(ContextOrObjectId current, Deque<AccessPath.AccessPathElement> path) throws RuntimeException {
            this.visited.add(current);
            if (this.isLive(current)) {
                this.res.add(new AccessPath(ReferenceCounter.this.getIID(this.node), new ArrayList<AccessPath.AccessPathElement>(path)));
                if (this.res.size() > this.MAX_AP) {
                    throw new RuntimeException();
                }
            } else {
                Set<HeapEdge> incoming = ReferenceCounter.this.graph.incoming(current);
                for (HeapEdge edge : incoming) {
                    ContextOrObjectId from = edge.getFrom();
                    if (this.visited.contains(from)) {
                        return;
                    }
                    String name = edge.getName();
                    AccessPath.AccessPathElement ape = new AccessPath.AccessPathElement(name, ReferenceCounter.this.getIID(from));
                    path.addFirst(ape);
                    this.walker(from, path);
                    path.removeFirst();
                }
            }
            this.visited.remove(current);
        }

        private boolean isLive(ContextOrObjectId node) {
            return node.type == ContextOrObjectId.Type.CONTEXT && node.getContext().isLive();
        }

        public Set<AccessPath> run() {
            try {
                this.walker(this.node, new LinkedList<AccessPath.AccessPathElement>());
            }
            catch (RuntimeException tooManyPaths) {
                return this.res;
            }
            return this.res;
        }
    }
}

