/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jsa.jalangi.util;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.internal.Workbench;
import org.tizen.web.jsa.JsaPlugin;
import org.tizen.web.jsa.jalangi.util.CommandExecutor;
import org.tizen.web.jsa.safe.bugdetecter.preferences.OSChecker;
import org.tizen.web.jsa.safe.bugdetecter.preferences.Settings;

public class EnvironmentMgr {
    private static String strProjectPath = "";
    private static IProject project = null;
    private static String strHostIP = "127.0.0.2";
    public static boolean isWindows = OSChecker.isWindows();
    public static boolean isMac = OSChecker.isMac();
    public static final String JSA_TOOL_FOLDER = "jalangi";
    public static final String INSTRUMENT_OUTPUT = isWindows ? ".tmp" : "/tmp";
    public static final String JSA_TOOL_HOME = String.valueOf(Settings.toolsPath) + File.separator + "jsa" + File.separator + "jalangi";
    public static final String NODE_BINARY_HOME = String.valueOf(Settings.toolsPath) + File.separator + "jsa" + File.separator + "nodejs";
    private static double version = -1.0;

    public static String getSdbPath() {
        return String.valueOf(EnvironmentMgr.getSdbDir().getAbsolutePath()) + File.separator + "sdb";
    }

    public static String getProjectPath() {
        strProjectPath = EnvironmentMgr.getCurrentProjectPath();
        return strProjectPath;
    }

    public static String getHostIP() {
        return strHostIP;
    }

    public static String getJalangiDir() {
        return JSA_TOOL_HOME;
    }

    public static String getCurrentProjectPath() {
        IProject project = EnvironmentMgr.getCurrentProject();
        if (project != null) {
            return EnvironmentMgr.getCurrentProject().getLocation().toString();
        }
        return strProjectPath;
    }

    public static String getProjectPathNew() {
        return strProjectPath;
    }

    public static String getCurrentProjectName() {
        IProject curPrj = EnvironmentMgr.getCurrentProject();
        String curPrjName = null;
        if (curPrj != null) {
            curPrjName = EnvironmentMgr.getCurrentProject().getName();
        }
        return curPrjName;
    }

    public static IProject getCurrentProject() {
        return EnvironmentMgr.getCurrentProject(null);
    }

    public static void setProjectPath(String projectPath) {
        strProjectPath = projectPath;
    }

    public static void setProject(IProject inproject) {
        project = inproject;
    }

    public static IProject getProject() {
        return project;
    }

    public static IProject getCurrentProject(ISelection selection) {
        if (selection == null) {
            ISelectionService selectionService = Workbench.getInstance().getActiveWorkbenchWindow().getSelectionService();
            selection = selectionService.getSelection();
        }
        IProject project = null;
        if (selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IResource) {
                project = ((IResource)element).getProject();
            } else if (element instanceof IJavaElement) {
                IJavaProject jProject = ((IJavaElement)element).getJavaProject();
                project = jProject.getProject();
            }
        }
        return project;
    }

    public static File getSdbDir() {
        File sdbDir = new File(Settings.toolsPath);
        return sdbDir;
    }

    public static File getTizenIdeCliDir() {
        return new File(Settings.toolsPath, "ide" + File.separator + "bin");
    }

    public static double getNodeVersion() {
        version = -1.0;
        CommandExecutor.exec("node -v", null, new CommandExecutor.LineHandler(){

            @Override
            void realLine(String line) {
                try {
                    String[] ver = line.split("\\.");
                    version = Double.parseDouble(String.valueOf(ver[1]) + "." + ver[2]);
                }
                catch (Exception exception) {}
            }
        });
        return version;
    }

    public static boolean checkSettings() {
        Shell shell = Display.getCurrent().getActiveShell();
        JsaPlugin.printToConsole("--- Initialize Check Stale Object");
        File jalangiDir = new File(EnvironmentMgr.getJalangiDir());
        if (!jalangiDir.exists() || !jalangiDir.isDirectory()) {
            MessageDialog.openInformation((Shell)shell, (String)"Error", (String)"Please check jalangi engine location.");
            return false;
        }
        JsaPlugin.printToConsole("Analyzer Engine Path : " + jalangiDir.getAbsolutePath());
        double currentNode = EnvironmentMgr.getNodeVersion();
        if (currentNode == -1.0 || currentNode <= 10.25) {
            File nodePath = new File(NODE_BINARY_HOME);
            if (!nodePath.exists() || !nodePath.isDirectory()) {
                MessageDialog.openInformation((Shell)shell, (String)"Error", (String)("Can't found Node.js binay in " + NODE_BINARY_HOME));
                return false;
            }
            JsaPlugin.printToConsole("Node.js Path : " + nodePath.getAbsolutePath() + " (v" + currentNode + ")");
        } else {
            MessageDialog.openInformation((Shell)shell, (String)"Error", (String)"Node.js version is wrong, We recommend v0.10.25.");
        }
        if (EnvironmentMgr.getCurrentProject() == null) {
            MessageDialog.openInformation((Shell)shell, (String)"Information", (String)"Please select a project to check stale object.");
            return false;
        }
        IProject project = EnvironmentMgr.getCurrentProject();
        EnvironmentMgr.setProject(project);
        JsaPlugin.printToConsole("Project Path : " + project.getLocation().toOSString());
        return true;
    }

    public static String getWorkspacePath() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toString();
    }

    public static boolean isIp(String ip) {
        String regex = "\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\:\\d{1,5}\\b";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(ip);
        return m.matches();
    }

    public static class Commands {
        private static final String LAUNCH_CHROME = isWindows ? "start chrome.exe" : (isMac ? "open -a \"Google Chrome\"" : "google-chrome");
        private static final String LAUNCH_MLD = isWindows ? "node drivers/meminsight.js" : "./bin/meminsight";
        private static final String KILL_PROCESS = isWindows ? "tskill" : "killall";
        public static final String CLI_SCRIPT_NAME = isWindows ? "tizen.bat" : "tizen.sh";
        public static final String LAUNCH_APP_ON_BROWSER = String.valueOf(LAUNCH_CHROME) + " http://localhost:8888";
        public static final String LAUNCH_RESULT_VIEW = String.valueOf(LAUNCH_CHROME) + " http://localhost:9000";
        public static final String EXECUTE_MLD_INSPECT = String.valueOf(LAUNCH_MLD) + " inspect ";
        public static final String EXECUTE_MLD_RUN = String.valueOf(LAUNCH_MLD) + " run ";
        public static final String EXECUTE_MLD_RUN_CLIENT = String.valueOf(LAUNCH_MLD) + " run --client ";
        public static final String KILL_NODEJS = String.valueOf(KILL_PROCESS) + " node";
        public static final String KILL_SDB = String.valueOf(KILL_PROCESS) + " sdb";
    }
}

