/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.useful;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.ac.kaist.jsaf.useful.F;
import kr.ac.kaist.jsaf.useful.Fn2;
import kr.ac.kaist.jsaf.useful.NI;
import kr.ac.kaist.jsaf.useful.NotFound;
import kr.ac.kaist.jsaf.useful.Pair;
import kr.ac.kaist.jsaf.useful.PureList;
import kr.ac.kaist.jsaf.useful.StringMap;

public class Useful {
    static final String localMilliIso8601Format = "yyyy-MM-dd'T'HH:mm:ss.SSSzzz";
    public static final DateFormat localMilliDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSzzz");
    public static final Pattern envVar = Pattern.compile("[$][{][-A-Za-z0-9_.]+[}]");
    static final int INTRO_LEN = 2;
    static final int OUTRO_LEN = 1;
    public static final StringMap sysMap = new StringMap.ComposedMaps(new StringMap.FromSysProps(), new StringMap.FromEnv());

    public static String localNow(Date d) {
        return localMilliDateFormat.format(d);
    }

    public static String timeStamp() {
        return Useful.localNow(new Date());
    }

    public static <K, V> TreeMap<K, V> treeMap(Comparator<K> comp, Map<? extends K, ? extends V> map2) {
        TreeMap<? extends K, ? extends V> result = new TreeMap<K, V>(comp);
        result.putAll(map2);
        return result;
    }

    public static <T> String listInParens(Collection<T> l) {
        return Useful.listInDelimiters("(", l, ")");
    }

    public static <T> String listInCurlies(Collection<T> l) {
        return Useful.listInDelimiters("{", l, "}");
    }

    public static <T> String listInCurlies(Object[] l) {
        return Useful.listInDelimiters("{", l, "}");
    }

    public static <T> String listInDelimiters(String left, Collection<T> l, String right) {
        return Useful.listInDelimiters(left, l, right, ",");
    }

    public static <T> String listInDelimiters(String left, Object[] l, String right) {
        return Useful.listInDelimiters(left, l, right, ",");
    }

    public static <T> String listInDelimiters(String left, Iterable<T> l, String right, String sep) {
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        boolean first = true;
        for (T x : l) {
            if (first) {
                first = false;
            } else {
                sb.append(sep);
            }
            sb.append(String.valueOf(x));
        }
        sb.append(right);
        return sb.toString();
    }

    public static <T> String listInDelimiters(String left, Object[] l, String right, String sep) {
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        boolean first = true;
        if (l != null) {
            for (Object x : l) {
                if (first) {
                    first = false;
                } else {
                    sb.append(sep);
                }
                sb.append(String.valueOf(x));
            }
        }
        sb.append(right);
        return sb.toString();
    }

    public static <T> String listTranslatedInDelimiters(String left, Object[] l, String right, String sep, F<Object, String> foreach) {
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        boolean first = true;
        if (l != null) {
            for (Object x : l) {
                if (first) {
                    first = false;
                } else {
                    sb.append(sep);
                }
                sb.append(foreach.apply(x));
            }
        }
        sb.append(right);
        return sb.toString();
    }

    public static <T> String listTranslatedInDelimiters(String left, Iterable<T> l, String right, String sep, F<Object, String> foreach) {
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        boolean first = true;
        if (l != null) {
            for (T x : l) {
                if (first) {
                    first = false;
                } else {
                    sb.append(sep);
                }
                sb.append(foreach.apply(x));
            }
        }
        sb.append(right);
        return sb.toString();
    }

    public static String coordInDelimiters(String left, int[] l, int hi, String right) {
        return Useful.coordInDelimiters(left, l, 0, hi, right);
    }

    public static String coordInDelimiters(String left, int[] l, String right) {
        return Useful.coordInDelimiters(left, l, 0, l.length, right);
    }

    public static String coordInDelimiters(String left, int[] l, int lo, int hi, String right) {
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        boolean first = true;
        for (int i = lo; i < hi; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(String.valueOf(l[i]));
        }
        sb.append(right);
        return sb.toString();
    }

    public static <T, U> String listsInParens(List<T> l1, List<U> l2) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean first = true;
        for (Object x : l1) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(String.valueOf(x));
        }
        for (Object x : l2) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(String.valueOf(x));
        }
        sb.append(")");
        return sb.toString();
    }

    public static <T> String dottedList(List<T> l) {
        if (l.size() == 1) {
            return String.valueOf(l.get(0));
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T x : l) {
            if (first) {
                first = false;
            } else {
                sb.append(".");
            }
            sb.append(String.valueOf(x));
        }
        return sb.toString();
    }

    public static String backtrace(int start, int count) {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < start + count && i < trace.length; ++i) {
            if (i > start) {
                sb.append("\n");
            }
            sb.append(String.valueOf(trace[i]));
        }
        return sb.toString();
    }

    public static <T> String listInOxfords(List<T> l) {
        return Useful.listInDelimiters("[\\", l, "\\]");
    }

    public static String inOxfords(String string1, String string2, String string3) {
        return "[\\" + string1 + ", " + string2 + ", " + string3 + "\\]";
    }

    public static String inOxfords(String string1, String string2) {
        return "[\\" + string1 + ", " + string2 + "\\]";
    }

    public static String inOxfords(String string1) {
        return "[\\" + string1 + "\\]";
    }

    public static <T> Set<List<T>> setProduct(Set<List<T>> s1, Set<T> s2) {
        HashSet<List<T>> result = new HashSet<List<T>>();
        for (List<T> list : s1) {
            for (T elt : s2) {
                ArrayList<T> java_is_not_a_functional_language = new ArrayList<T>(list);
                java_is_not_a_functional_language.add(elt);
                result.add(java_is_not_a_functional_language);
            }
        }
        return result;
    }

    public static <T, U, V> Set<V> setProduct(Set<T> t, Set<U> u, Fn2<T, U, V> product) {
        HashSet<V> result = new HashSet<V>();
        for (T i : t) {
            for (U j : u) {
                result.add(product.apply(i, j));
            }
        }
        return result;
    }

    public static <T, U> Set<U> applyToAll(Set<T> s, F<T, U> verb) {
        HashSet<U> result = new HashSet<U>();
        for (T i : s) {
            result.add(verb.apply(i));
        }
        return result;
    }

    public static <T> Set<T> matchingSubset(Iterable<T> s, F<T, Boolean> verb) {
        HashSet<T> result = new HashSet<T>();
        for (T i : s) {
            if (!verb.apply(i).booleanValue()) continue;
            result.add(i);
        }
        return result;
    }

    public static <T, U> List<U> applyToAll(List<T> s, F<T, U> verb) {
        ArrayList<U> result = new ArrayList<U>();
        for (T i : s) {
            result.add(verb.apply(i));
        }
        return result;
    }

    public static <T> Boolean andReduction(Collection<T> s, F<T, Boolean> verb) {
        for (T i : s) {
            if (verb.apply(i).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static <T> Boolean orReduction(Collection<T> s, F<T, Boolean> verb) {
        for (T i : s) {
            if (!verb.apply(i).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static <T> List<T> applyToAllPossiblyReusing(List<T> s, F<T, T> verb) {
        int j = 0;
        for (T i : s) {
            T new_i = verb.apply(i);
            if (new_i != i) {
                int k = 0;
                ArrayList<T> result = new ArrayList<T>(s.size());
                for (T ii : s) {
                    result.add(k < j ? ii : (k == j ? new_i : verb.apply(ii)));
                    ++k;
                }
                return result;
            }
            ++j;
        }
        return s;
    }

    public static <T, U> List<U> applyToAllAppending(Collection<T> s, F<T, U> verb, List<U> result) {
        for (T i : s) {
            result.add(verb.apply(i));
        }
        return result;
    }

    public static <T, U> Set<U> applyToAllInserting(Collection<T> s, F<T, U> verb, Set<U> result) {
        for (T i : s) {
            result.add(verb.apply(i));
        }
        return result;
    }

    public static <T, U> Set<U> applyToAllInserting(List<T> s, F<T, U> verb, Set<U> result) {
        for (T i : s) {
            result.add(verb.apply(i));
        }
        return result;
    }

    public static <T> Set<T> set(Iterable<T> xs) {
        HashSet<T> result = new HashSet<T>();
        for (T x : xs) {
            if (x == null) continue;
            result.add(x);
        }
        return result;
    }

    public static <T> Set<T> set() {
        return Collections.emptySet();
    }

    public static <T> Set<T> set(T x1) {
        HashSet<T> result = new HashSet<T>();
        result.add(x1);
        return result;
    }

    public static <T> Set<T> set(T x1, T x2) {
        HashSet<T> result = new HashSet<T>();
        result.add(x1);
        result.add(x2);
        return result;
    }

    public static <T> Set<T> set(T x1, T x2, T x3) {
        HashSet<T> result = new HashSet<T>();
        result.add(x1);
        result.add(x2);
        result.add(x3);
        return result;
    }

    public static <T> Set<T> union(Iterable<? extends Collection<T>> xs) {
        HashSet<T> result = new HashSet<T>();
        for (Collection<T> x : xs) {
            if (x == null) continue;
            result.addAll(x);
        }
        return result;
    }

    public static <T> Set<T> union(Collection<T> x1, Collection<T> x2, Collection<T> x3, Collection<T> x4) {
        HashSet<T> result = new HashSet<T>();
        result.addAll(x1);
        result.addAll(x2);
        result.addAll(x3);
        result.addAll(x4);
        return result;
    }

    public static <T> Set<T> union(Collection<T> x1, Collection<T> x2, Collection<T> x3, Collection<T> x4, Collection<T> x5, Collection<T> x6) {
        HashSet<T> result = new HashSet<T>();
        result.addAll(x1);
        result.addAll(x2);
        result.addAll(x3);
        result.addAll(x4);
        result.addAll(x5);
        result.addAll(x6);
        return result;
    }

    public static <T> Set<T> union(Collection<T> x1, Collection<T> x2, Collection<T> x3) {
        HashSet<T> result = new HashSet<T>();
        result.addAll(x1);
        result.addAll(x2);
        result.addAll(x3);
        return result;
    }

    public static <T> Set<T> union(Collection<T> x1, Collection<T> x2) {
        HashSet<T> result = new HashSet<T>();
        result.addAll(x1);
        result.addAll(x2);
        return result;
    }

    public static <T> Set<T> difference(Collection<T> x1, Collection<T> x2) {
        HashSet<T> result = new HashSet<T>();
        result.addAll(x1);
        result.removeAll(x2);
        return result;
    }

    public static <T> T clampedGet(List<T> l, int j) {
        int s = l.size();
        return j < s ? l.get(j) : l.get(s - 1);
    }

    public static <U> List<U> list(List<? extends U> all) {
        ArrayList<? extends U> l = new ArrayList<U>();
        l.addAll(all);
        return l;
    }

    public static <U> List<U> list(U[] all) {
        ArrayList<U> l = new ArrayList<U>(all.length);
        for (U x : all) {
            l.add(x);
        }
        return l;
    }

    public static <T> List<T> list(Iterable<? extends T> xs) {
        ArrayList<Object> result = xs instanceof Collection ? new ArrayList(((Collection)xs).size()) : new ArrayList<T>();
        for (T x : xs) {
            result.add(x);
        }
        return result;
    }

    public static <T, U> List<U> filteredList(Iterable<? extends T> l, F<T, U> f) {
        ArrayList<U> result = new ArrayList<U>();
        for (T t : l) {
            U u = f.apply(t);
            if (u == null) continue;
            result.add(u);
        }
        return result;
    }

    public static <T> List<T> filter(Iterable<? extends T> l, final F<T, Boolean> f) {
        return Useful.filteredList(l, new F<T, T>(){

            @Override
            public T apply(T t) {
                if (((Boolean)f.apply(t)).booleanValue()) {
                    return t;
                }
                return null;
            }
        });
    }

    public static <T, U> List<T> convertList(Iterable<? extends U> list) {
        return Useful.filteredList(list, new F<U, T>(){

            @Override
            public T apply(U u) {
                return u;
            }
        });
    }

    public static <T, U> SortedSet<U> filteredSortedSet(Iterable<? extends T> l, F<T, U> f, Comparator<U> c) {
        TreeSet<U> result = new TreeSet<U>(c);
        for (T t : l) {
            U u = f.apply(t);
            if (u == null) continue;
            result.add(u);
        }
        return result;
    }

    public static <T> List<T> list(T x1, T x2, T x3, T x4) {
        ArrayList<T> result = new ArrayList<T>(4);
        result.add(x1);
        result.add(x2);
        result.add(x3);
        result.add(x4);
        return result;
    }

    public static <T> List<T> list(T x1, T x2, T x3) {
        ArrayList<T> result = new ArrayList<T>(3);
        result.add(x1);
        result.add(x2);
        result.add(x3);
        return result;
    }

    public static <T> List<T> list(T x1, T x2) {
        ArrayList<T> result = new ArrayList<T>(2);
        result.add(x1);
        result.add(x2);
        return result;
    }

    public static <T, U> Map<T, U> map(List<T> x1, List<U> x2) {
        HashMap result = new HashMap();
        return Useful.map(x1, x2, result);
    }

    public static <T, U> Map<T, U> map(List<T> x1, List<U> x2, Map<T, U> result) {
        int l = x1.size();
        for (int i = 0; i < l; ++i) {
            result.put(x1.get(i), x2.get(i));
        }
        return result;
    }

    public static <T> List<T> list(T x1) {
        ArrayList<T> result = new ArrayList<T>(1);
        result.add(x1);
        return result;
    }

    public static <T> List<T> list() {
        return Collections.emptyList();
    }

    public static <U, T extends U> List<U> list(List<T> rest, U last) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.addAll(rest);
        l.add(last);
        return l;
    }

    public static <U, T extends U> List<U> list(U first, List<T> rest) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(first);
        l.addAll(rest);
        return l;
    }

    public static <T> List<T> immutableTrimmedList(List<T> x) {
        int l = x.size();
        if (l == 0) {
            return Collections.emptyList();
        }
        if (l == 1) {
            return Collections.singletonList(x.get(0));
        }
        return new ArrayList<T>(x);
    }

    public static <T> List<T> immutableTrimmedList(PureList<T> x) {
        int l = x.size();
        if (l == 0) {
            return Collections.emptyList();
        }
        if (l == 1) {
            return Collections.singletonList(x.iterator().next());
        }
        ArrayList<T> a = new ArrayList<T>(l);
        for (T y : x) {
            a.add(y);
        }
        return a;
    }

    public static <T> List<T> cons(T x, List<T> y) {
        return Useful.prepend(x, y);
    }

    public static <T> List<T> prepend(T x, List<T> y) {
        ArrayList<T> result = new ArrayList<T>(1 + y.size());
        result.add(x);
        result.addAll(y);
        return result;
    }

    public static <T> List<T> removeIndex(int i, List<T> y) {
        int l = y.size();
        if (i == 0) {
            return y.subList(1, l);
        }
        if (i == l - 1) {
            return y.subList(0, l - 1);
        }
        ArrayList<T> result = new ArrayList<T>(y.size() - 1);
        result.addAll(y.subList(0, i));
        result.addAll(y.subList(i + 1, l));
        return result;
    }

    public static <T, U> List<U> prependMapped(T x, List<T> y, F<T, U> f) {
        ArrayList<U> result = new ArrayList<U>(1 + y.size());
        result.add(f.apply(x));
        for (T t : y) {
            result.add(f.apply(t));
        }
        return result;
    }

    public static <T> List<T> concat(Iterable<Collection<T>> xs) {
        ArrayList<T> result = new ArrayList<T>();
        for (Collection<T> x : xs) {
            result.addAll(x);
        }
        result.trimToSize();
        return result;
    }

    public static <T> List<? extends T> questionMarkList(List<? extends T> list) {
        return list;
    }

    public static <T> List<T> concat(Collection<? extends T> x1, Collection<? extends T> x2) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(x1);
        result.addAll(x2);
        result.trimToSize();
        return result;
    }

    public static <T> List<T> concat(Collection<T> x1) {
        ArrayList<T> result = new ArrayList<T>(x1);
        return result;
    }

    public static <T> List<T> concat() {
        ArrayList result = new ArrayList();
        return result;
    }

    public static <T> T singleValue(Set<T> s) {
        int si = s.size();
        if (si == 0) {
            throw new Error("Empty set where singleton expected");
        }
        if (si > 1) {
            throw new Error("Multiple-element set where singleton expected");
        }
        Iterator<T> i$ = s.iterator();
        if (i$.hasNext()) {
            T e = i$.next();
            return e;
        }
        return NI.np();
    }

    public static <T extends Comparable<T>, U extends Comparable<U>> int compare(T a, T b, U c, U d) {
        int x = a.compareTo(b);
        if (x != 0) {
            return x;
        }
        return c.compareTo(d);
    }

    public static <T extends Comparable<T>, U extends Comparable<U>, V extends Comparable<V>> int compare(T a, T b, U c, U d, V e, V f) {
        int x = a.compareTo(b);
        if (x != 0) {
            return x;
        }
        x = c.compareTo(d);
        if (x != 0) {
            return x;
        }
        return e.compareTo(f);
    }

    public static <T extends Comparable<T>, U extends Comparable<U>, V extends Comparable<V>, W extends Comparable<W>> int compare(T a, T b, U c, U d, V e, V f, W g, W h) {
        int x = a.compareTo(b);
        if (x != 0) {
            return x;
        }
        x = c.compareTo(d);
        if (x != 0) {
            return x;
        }
        x = e.compareTo(f);
        if (x != 0) {
            return x;
        }
        return g.compareTo(h);
    }

    public static <T> int compare(T a, T b, Comparator<T> c1, Comparator<T> c2) {
        int x = c1.compare(a, b);
        if (x != 0) {
            return x;
        }
        return c2.compare(a, b);
    }

    public static <T> int compare(T a, T b, Comparator<T> c1, Comparator<T> c2, Comparator<T> c3) {
        int x = c1.compare(a, b);
        if (x != 0) {
            return x;
        }
        x = c2.compare(a, b);
        if (x != 0) {
            return x;
        }
        return c3.compare(a, b);
    }

    public static int countMatches(String input, String to_match) {
        int j = 0;
        int l = to_match.length();
        if (l == 0) {
            return input.length() == 0 ? 1 : 0;
        }
        int i = input.indexOf(to_match);
        while (i != -1) {
            ++j;
            i = input.indexOf(to_match, i + l);
        }
        return j;
    }

    public static String extractAfterMatch(String input, String to_match) throws NotFound {
        int i = input.indexOf(to_match);
        if (i == -1) {
            throw new NotFound();
        }
        return input.substring(i + to_match.length());
    }

    public static String extractBeforeMatchOrAll(String input, String to_match) {
        int i = input.indexOf(to_match);
        if (i == -1) {
            return input;
        }
        return input.substring(0, i);
    }

    public static String extractBeforeMatch(String input, String to_match) throws NotFound {
        int i = input.indexOf(to_match);
        if (i == -1) {
            throw new NotFound();
        }
        return input.substring(0, i);
    }

    public static String extractBetweenMatch(String input, String before, String after) {
        int b = input.indexOf(before);
        if (b == -1) {
            return null;
        }
        input = input.substring(b + before.length());
        if (after == null) {
            return input;
        }
        int a = input.indexOf(after);
        if (a == -1) {
            return null;
        }
        return input.substring(0, a);
    }

    public static String replace(String original, String search2, String replace) {
        int searchLength = search2.length();
        if (searchLength == 0) {
            throw new IllegalArgumentException("Cannot replace empty string");
        }
        StringBuilder sb = new StringBuilder(original.length() + Math.max(0, replace.length() - search2.length()));
        int start = 0;
        int at = original.indexOf(search2);
        while (at != -1) {
            sb.append(original.substring(start, at));
            sb.append(replace);
            start = at + searchLength;
            at = original.indexOf(search2, start);
        }
        if (start == 0) {
            return original;
        }
        sb.append(original.substring(start));
        return sb.toString();
    }

    public static String replace(String original, String search2, String replace, int count) {
        int searchLength = search2.length();
        if (searchLength == 0) {
            throw new IllegalArgumentException("Cannot replace empty string");
        }
        StringBuilder sb = new StringBuilder(original.length() + Math.max(0, replace.length() - search2.length()));
        int start = 0;
        int at = original.indexOf(search2);
        while (at != -1 && --count >= 0) {
            sb.append(original.substring(start, at));
            sb.append(replace);
            start = at + searchLength;
            at = original.indexOf(search2, start);
        }
        if (start == 0) {
            return original;
        }
        sb.append(original.substring(start));
        return sb.toString();
    }

    public static String substring(String s, int start, int end) {
        int l = s.length();
        if (start > l) {
            start = l;
        }
        if (end > l) {
            end = l;
        }
        if (start < 0) {
            start = l + start;
        }
        if (end < 0) {
            end = l + end;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (start > end) {
            start = end;
        }
        return s.substring(start, end);
    }

    public static int commonPrefixLength(String s1, String s2) {
        int i;
        for (i = 0; i < s1.length() && i < s2.length() && s1.charAt(i) == s2.charAt(i); ++i) {
        }
        return i;
    }

    public static int commonPrefixLengthCI(String s1, String s2) {
        int i;
        for (i = 0; i < s1.length() && i < s2.length() && Character.toUpperCase(s1.charAt(i)) == Character.toUpperCase(s2.charAt(i)); ++i) {
        }
        return i;
    }

    public static BufferedReader utf8BufferedFileReader(File f) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), Charset.forName("UTF-8")));
    }

    public static Pair<FileWriter, BufferedWriter> filenameToBufferedWriter(String filename) throws IOException {
        FileWriter fw;
        try {
            fw = new FileWriter(filename);
        }
        catch (IOException ex) {
            int last_slash = filename.lastIndexOf(47);
            if (last_slash == -1) {
                throw ex;
            }
            String dir = filename.substring(0, last_slash);
            Useful.ensureDirectoryExists(dir);
            fw = new FileWriter(filename);
        }
        return new Pair<FileWriter, BufferedWriter>(fw, new BufferedWriter(fw));
    }

    public static boolean olderThanOrMissing(String resultFile, String inputFile) throws FileNotFoundException {
        File res = new File(resultFile);
        File inp = new File(inputFile);
        if (!inp.exists()) {
            throw new FileNotFoundException(inputFile);
        }
        return Useful.olderThanOrMissing(res, inp.lastModified());
    }

    public static boolean olderThanOrMissing(String resultFile, long inputFileDate) {
        File res = new File(resultFile);
        return Useful.olderThanOrMissing(res, inputFileDate);
    }

    public static boolean olderThanOrMissing(File resultFile, long inputFileDate) {
        return !resultFile.exists() || resultFile.lastModified() < inputFileDate;
    }

    public static String substituteVars(String e) {
        return Useful.substituteVars(e, envVar, 2, 1);
    }

    public static String substituteVars(String e, StringMap map2) {
        return Useful.substituteVars(e, envVar, 2, 1, map2);
    }

    public static String substituteVarsCompletely(String e, StringMap map2, int limit) {
        return Useful.substituteVarsCompletely(e, map2, limit, envVar, 2, 1);
    }

    public static String substituteVarsCompletely(String e, StringMap map2, int limit, Pattern vpat, int v_intro, int v_outro) {
        String initial_e = e;
        String old_e = e;
        e = Useful.substituteVars(e, vpat, v_intro, v_outro, map2);
        while (old_e != e && limit-- > 0) {
            old_e = e;
            e = Useful.substituteVars(e, vpat, v_intro, v_outro, map2);
        }
        if (limit <= 0) {
            throw new Error("String substitution failed to terminate, input=" + initial_e + ", " + " non-final result=" + e);
        }
        return e;
    }

    public static String substituteVars(String e, Pattern varPat, int intro_len, int outro_len) {
        return Useful.substituteVars(e, varPat, intro_len, outro_len, sysMap);
    }

    public static String substituteVars(String e, Pattern varPat, int intro_len, int outro_len, StringMap map2) {
        Matcher m = varPat.matcher(e);
        int lastMatchEnd = 0;
        StringBuilder newE = null;
        while (m.find()) {
            if (newE == null) {
                newE = new StringBuilder();
            }
            MatchResult mr = m.toMatchResult();
            newE.append(e.substring(lastMatchEnd, mr.start()));
            lastMatchEnd = mr.end();
            String toReplace = e.substring(mr.start() + intro_len, mr.end() - outro_len);
            String candidate = map2.get(toReplace);
            if (candidate == null) {
                candidate = "";
            }
            newE.append(candidate);
        }
        if (newE != null) {
            newE.append(e.substring(lastMatchEnd));
            e = newE.toString();
        }
        return e;
    }

    public static String ensureDirectoryExists(String s) throws Error {
        File f = new File(s);
        if (f.exists()) {
            if (!f.isDirectory()) {
                throw new Error("Necessary 'directory' " + s + " is not a directory");
            }
        } else if (!f.mkdirs()) {
            throw new Error("Failed to create directory " + s);
        }
        return s;
    }

    public static void use(Object o) {
    }

    public static void use(int i) {
    }

    public static void use(boolean b) {
    }
}

