/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jsa.safe.bugdetecter.core;

import java.util.ArrayList;
import java.util.HashMap;

public class BugFilter {
    private static HashMap<String, ArrayList<String>> filterKeyMap = new HashMap();

    static {
        String[] SystemInfoProperty = new String[]{"level", "isCharging", "load", "units", "type", "capacity", "availableCapacity", "isRemovable", "isRemoveable", "resolutionWidth", "resolutionHeight", "dotsPerInchWidth", "dotsPerInchHeight", "physicalWidth", "physicalHeight", "brightness", "status", "isAutoRotation", "model", "manufacturer", "buildVersion", "language", "country", "networkType", "status", "ssid", "ipAddress", "ipv6Address", "signalStrength", "status", "apn", "ipAddress", "ipv6Address", "mcc", "mnc", "cellId", "lac", "isRoaming", "isFlightMode", "imei", "state", "operatorName", "msisdn", "iccid", "mcc", "mnc", "msin", "spn", "isVideoOutputOn"};
        String[] BluetoothProfileHandler = new String[]{"registerSinkApplication", "connectToSource"};
        String[] Content = new String[]{"geolocation", "album", "artists", "duration", "width", "height", "album", "genres", "artists", "composers", "lyrics", "copyright", "bitrate", "trackNumber", "duration", "geolocation", "width", "height", "orientation"};
        String[] CalendarItem = new String[]{"dueDate", "completedDate", "progress", "isDetached", "endDate", "availability", "recurrenceRule", "expandRecurrence"};
        String[] HumanActivityData = new String[]{"stepStatus", "speed", "walkingFrequency", "cumulativeDistance", "cumulativeCalorie", "cumulativeTotalStepCount", "cumulativeWalkStepCount", "cumulativeRunStepCount", "stepCountDifferences", "stepStatus", "speed", "walkingFrequency", "accumulativeDistance", "accumulativeCalorie", "accumulativeTotalStepCount", "accumulativeWalkStepCount", "accumulativeRunStepCount", "stepCountDifferences", "heartRate", "rRInterval", "gpsInfo"};
        String[] Sensor = new String[]{"getLightSensorData", "getMagneticSensorData", "getPressureSensorData", "getProximitySensorData", "getUltravioletSensorData"};
        String[] SensorData = new String[]{"lightLevel", "x", "y", "z", "accuracy", "pressure", "proximityState", "ultravioletLevel"};
        String[] Notification = new String[]{"statusType", "iconPath", "subIconPath", "number", "detailInfo", "ledColor", "ledOnPeriod", "ledOffPeriod", "backgroundImagePath", "thumbnails", "soundPath", "vibration", "appControl", "appId", "progressType", "progressValue"};
        BugFilter.addKeySet("SystemInfoProperty", SystemInfoProperty);
        BugFilter.addKeySet("BluetoothProfileHandler", BluetoothProfileHandler);
        BugFilter.addKeySet("Content", Content);
        BugFilter.addKeySet("CalendarItem", CalendarItem);
        BugFilter.addKeySet("HumanActivityData", HumanActivityData);
        BugFilter.addKeySet("Sensor", Sensor);
        BugFilter.addKeySet("SensorData", SensorData);
        BugFilter.addKeySet("Notification", Notification);
    }

    private BugFilter() {
    }

    public static void addKeySet(String interfaceName, String[] propertys) {
        ArrayList<String> propertyItems = new ArrayList<String>();
        String[] stringArray = propertys;
        int n = propertys.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            propertyItems.add(item);
            ++n2;
        }
        filterKeyMap.put(interfaceName, propertyItems);
    }

    public static boolean isFilteringWebAPI(int bugCategory, String message) {
        if (30 != bugCategory) {
            return false;
        }
        String regex = "is not found in the API";
        if (!message.contains(regex)) {
            return false;
        }
        int idxB = message.indexOf(regex);
        String attributeName = message.substring(5, idxB - 1);
        String interfaceName = message.substring(idxB + regex.length() + 1, message.length() - 1);
        if (filterKeyMap.containsKey(interfaceName)) {
            ArrayList<String> attributeList = filterKeyMap.get(interfaceName);
            return attributeList.contains(attributeName);
        }
        return false;
    }
}

