/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jsa.safe.bugdetecter.core;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.tizen.web.jsa.safe.bugdetecter.core.BugItem;

public class ProblemsReporter {
    public static final String BUGDETECTOR_MARKER_ID = "org.tizen.web.jsa.bugdetecter.marker";

    private ProblemsReporter() {
    }

    public static void reportItem(IProject project, BugItem bug) throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (ProblemsReporter.checkTimeBound(bug)) {
            return;
        }
        if (bug.bugLevel < 4) {
            return;
        }
        String rawPath = bug.filePath;
        File rawFile = new File(rawPath);
        if (!rawFile.exists()) {
            return;
        }
        URI uri = rawFile.toURI();
        IFile[] files = workspaceRoot.findFilesForLocationURI(uri);
        if (files.length > 0) {
            IMarker marker = files[0].createMarker(BUGDETECTOR_MARKER_ID);
            marker.setAttribute("priority", 2);
            StringBuilder makerType = new StringBuilder();
            switch (bug.bugLevel) {
                case 1: {
                    marker.setAttribute("severity", 2);
                    makerType.append("[Reference Error]");
                    break;
                }
                case 2: {
                    marker.setAttribute("severity", 2);
                    makerType.append("[Type Error]");
                    break;
                }
                case 3: {
                    marker.setAttribute("severity", 1);
                    makerType.append("[Type Warning]");
                    break;
                }
                case 4: {
                    marker.setAttribute("severity", 2);
                    makerType.append("[Web API Usage Rule]");
                    break;
                }
                case 5: {
                    marker.setAttribute("severity", 1);
                    makerType.append("[Web API Warning]");
                    break;
                }
                case 6: {
                    switch (bug.bugCategory) {
                        case 50: {
                            marker.setAttribute("severity", 2);
                            break;
                        }
                        case 51: {
                            marker.setAttribute("severity", 1);
                            break;
                        }
                        case 52: {
                            marker.setAttribute("severity", 1);
                            break;
                        }
                        case 53: {
                            marker.setAttribute("severity", 0);
                            break;
                        }
                        case 54: {
                            marker.setAttribute("severity", 0);
                            break;
                        }
                        case 55: {
                            marker.setAttribute("severity", 0);
                            break;
                        }
                        case 56: {
                            marker.setAttribute("severity", 0);
                            break;
                        }
                        case 57: {
                            marker.setAttribute("severity", 0);
                            break;
                        }
                        case 58: {
                            marker.setAttribute("severity", 1);
                            break;
                        }
                        case 60: {
                            marker.setAttribute("severity", 0);
                            break;
                        }
                        case 61: {
                            marker.setAttribute("severity", 1);
                            break;
                        }
                        case 62: {
                            marker.setAttribute("severity", 0);
                            break;
                        }
                        case 63: {
                            marker.setAttribute("severity", 1);
                            break;
                        }
                        case 64: {
                            marker.setAttribute("severity", 0);
                            break;
                        }
                        case 67: {
                            marker.setAttribute("severity", 2);
                            break;
                        }
                        case 68: {
                            marker.setAttribute("severity", 2);
                            break;
                        }
                        case 69: {
                            marker.setAttribute("severity", 2);
                            break;
                        }
                        case 1000: {
                            marker.setAttribute("severity", 2);
                            break;
                        }
                        default: {
                            marker.setAttribute("severity", 0);
                        }
                    }
                    makerType.append("[Coding Rule]");
                    break;
                }
            }
            makerType.append(bug.message);
            marker.setAttribute("message", (Object)makerType.toString());
            marker.setAttribute("lineNumber", bug.lineNumber);
        }
    }

    public static boolean checkTimeBound(BugItem item) {
        return item.bugLevel == 100;
    }

    public static void clear(IProject project) throws CoreException {
        project.deleteMarkers(BUGDETECTOR_MARKER_ID, true, 2);
    }
}

