/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.useful;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kr.ac.kaist.jsaf.useful.Cons;
import kr.ac.kaist.jsaf.useful.Empty;
import kr.ac.kaist.jsaf.useful.Fn;

public abstract class PureList<T>
implements Iterable<T> {
    public static <T> PureList<T> make(T ... elts) {
        PureList result = new Empty<T>();
        for (int i = elts.length - 1; i >= 0; --i) {
            result = ((PureList)result).cons(elts[i]);
        }
        return result;
    }

    public static <T> PureList<T> make(T e1, T e2) {
        PureList result = new Empty<T>();
        result = result.cons(e2);
        result = result.cons(e1);
        return result;
    }

    public static <T> PureList<T> make(T e1) {
        PureList result = new Empty<T>();
        result = ((PureList)result).cons(e1);
        return result;
    }

    public static <T> PureList<T> make() {
        Empty result = new Empty();
        return result;
    }

    public static <T> PureList<T> fromJavaList(List<T> elts) {
        PureList result = new Empty<T>();
        for (T elt : elts) {
            result = ((PureList)result).cons(elt);
        }
        return result.reverse();
    }

    public List<T> toJavaList() {
        LinkedList result = new LinkedList();
        PureList remainder = this;
        while (!remainder.isEmpty()) {
            Cons _remainder = (Cons)remainder;
            result.add(_remainder.getFirst());
            remainder = _remainder.getRest();
        }
        return result;
    }

    public Object[] toArray() {
        return this.toArray(this.size());
    }

    public Object[] toArray(int n) {
        Object[] result = new Object[n];
        PureList remainder = this;
        for (int i = 0; i < n; ++i) {
            Cons _remainder = (Cons)remainder;
            result[i] = _remainder.getFirst();
            remainder = _remainder.getRest();
        }
        return result;
    }

    public abstract boolean isEmpty();

    public abstract int size();

    public abstract <U> PureList<U> map(Fn<T, U> var1);

    public abstract boolean contains(T var1);

    public final PureList<T> cons(T e1, T e2, T e3, T ... elts) {
        Cons<T> result = this;
        for (int i = elts.length - 1; i >= 0; --i) {
            result = new Cons<T>(elts[i], result);
        }
        result = new Cons<T>(e3, result);
        result = new Cons<T>(e2, result);
        result = new Cons<T>(e1, result);
        return result;
    }

    public final PureList<T> cons(T e1, T e2) {
        Cons<T> result = this;
        result = new Cons<T>(e2, result);
        result = new Cons<T>(e1, result);
        return result;
    }

    public PureList<T> cons(T e1) {
        Cons<T> result = this;
        result = new Cons<T>(e1, result);
        return result;
    }

    public final PureList<T> cons() {
        PureList result = this;
        return result;
    }

    public abstract PureList<T> append(PureList<T> var1);

    public PureList<T> reverse() {
        return this.reverse(new Empty());
    }

    public abstract PureList<T> reverse(PureList<T> var1);

    @Override
    public abstract Iterator<T> iterator();
}

