/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import edu.rice.cs.plt.tuple.Option;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import kr.ac.kaist.jsaf.nodes.IRArgs;
import kr.ac.kaist.jsaf.nodes.IRArray;
import kr.ac.kaist.jsaf.nodes.IRArrayNumber;
import kr.ac.kaist.jsaf.nodes.IRBin;
import kr.ac.kaist.jsaf.nodes.IRBool;
import kr.ac.kaist.jsaf.nodes.IRBreak;
import kr.ac.kaist.jsaf.nodes.IRCall;
import kr.ac.kaist.jsaf.nodes.IRDelete;
import kr.ac.kaist.jsaf.nodes.IRDeleteProp;
import kr.ac.kaist.jsaf.nodes.IREval;
import kr.ac.kaist.jsaf.nodes.IRExpr;
import kr.ac.kaist.jsaf.nodes.IRExprStmt;
import kr.ac.kaist.jsaf.nodes.IRField;
import kr.ac.kaist.jsaf.nodes.IRFunDecl;
import kr.ac.kaist.jsaf.nodes.IRFunExpr;
import kr.ac.kaist.jsaf.nodes.IRFunctional;
import kr.ac.kaist.jsaf.nodes.IRGetProp;
import kr.ac.kaist.jsaf.nodes.IRId;
import kr.ac.kaist.jsaf.nodes.IRIf;
import kr.ac.kaist.jsaf.nodes.IRInternalCall;
import kr.ac.kaist.jsaf.nodes.IRLabelStmt;
import kr.ac.kaist.jsaf.nodes.IRLoad;
import kr.ac.kaist.jsaf.nodes.IRMember;
import kr.ac.kaist.jsaf.nodes.IRNew;
import kr.ac.kaist.jsaf.nodes.IRNoOp;
import kr.ac.kaist.jsaf.nodes.IRNode;
import kr.ac.kaist.jsaf.nodes.IRNull;
import kr.ac.kaist.jsaf.nodes.IRNumber;
import kr.ac.kaist.jsaf.nodes.IRObject;
import kr.ac.kaist.jsaf.nodes.IROp;
import kr.ac.kaist.jsaf.nodes.IRReturn;
import kr.ac.kaist.jsaf.nodes.IRRoot;
import kr.ac.kaist.jsaf.nodes.IRSeq;
import kr.ac.kaist.jsaf.nodes.IRSetProp;
import kr.ac.kaist.jsaf.nodes.IRSpanInfo;
import kr.ac.kaist.jsaf.nodes.IRStmt;
import kr.ac.kaist.jsaf.nodes.IRStmtUnit;
import kr.ac.kaist.jsaf.nodes.IRStore;
import kr.ac.kaist.jsaf.nodes.IRString;
import kr.ac.kaist.jsaf.nodes.IRThis;
import kr.ac.kaist.jsaf.nodes.IRThrow;
import kr.ac.kaist.jsaf.nodes.IRTmpId;
import kr.ac.kaist.jsaf.nodes.IRTry;
import kr.ac.kaist.jsaf.nodes.IRUn;
import kr.ac.kaist.jsaf.nodes.IRUndef;
import kr.ac.kaist.jsaf.nodes.IRUserId;
import kr.ac.kaist.jsaf.nodes.IRVarStmt;
import kr.ac.kaist.jsaf.nodes.IRWhile;
import kr.ac.kaist.jsaf.nodes.IRWith;
import kr.ac.kaist.jsaf.nodes_util.Span;

public class IRNodeReader {
    protected BufferedReader in;
    protected char currentChar = (char)32;

    public static IRNode read(String s) throws IOException {
        return IRNodeReader.read(new StringReader(s));
    }

    public static IRNode read(Reader r) throws IOException {
        return new IRNodeReader(new BufferedReader(r)).readIRNode();
    }

    protected IRNodeReader(BufferedReader r) {
        this.in = r;
    }

    public IRNode readIRNode() throws IOException {
        String name = this.readWord();
        if (name.equals("_")) {
            return null;
        }
        if (name.equals("IRRoot:")) {
            return this.readIRRootBody();
        }
        if (name.equals("IRExprStmt:")) {
            return this.readIRExprStmtBody();
        }
        if (name.equals("IRDelete:")) {
            return this.readIRDeleteBody();
        }
        if (name.equals("IRDeleteProp:")) {
            return this.readIRDeletePropBody();
        }
        if (name.equals("IRObject:")) {
            return this.readIRObjectBody();
        }
        if (name.equals("IRArray:")) {
            return this.readIRArrayBody();
        }
        if (name.equals("IRArrayNumber:")) {
            return this.readIRArrayNumberBody();
        }
        if (name.equals("IRArgs:")) {
            return this.readIRArgsBody();
        }
        if (name.equals("IRCall:")) {
            return this.readIRCallBody();
        }
        if (name.equals("IRInternalCall:")) {
            return this.readIRInternalCallBody();
        }
        if (name.equals("IRNew:")) {
            return this.readIRNewBody();
        }
        if (name.equals("IRFunExpr:")) {
            return this.readIRFunExprBody();
        }
        if (name.equals("IREval:")) {
            return this.readIREvalBody();
        }
        if (name.equals("IRStmtUnit:")) {
            return this.readIRStmtUnitBody();
        }
        if (name.equals("IRStore:")) {
            return this.readIRStoreBody();
        }
        if (name.equals("IRFunDecl:")) {
            return this.readIRFunDeclBody();
        }
        if (name.equals("IRBreak:")) {
            return this.readIRBreakBody();
        }
        if (name.equals("IRReturn:")) {
            return this.readIRReturnBody();
        }
        if (name.equals("IRWith:")) {
            return this.readIRWithBody();
        }
        if (name.equals("IRLabelStmt:")) {
            return this.readIRLabelStmtBody();
        }
        if (name.equals("IRVarStmt:")) {
            return this.readIRVarStmtBody();
        }
        if (name.equals("IRThrow:")) {
            return this.readIRThrowBody();
        }
        if (name.equals("IRSeq:")) {
            return this.readIRSeqBody();
        }
        if (name.equals("IRIf:")) {
            return this.readIRIfBody();
        }
        if (name.equals("IRWhile:")) {
            return this.readIRWhileBody();
        }
        if (name.equals("IRTry:")) {
            return this.readIRTryBody();
        }
        if (name.equals("IRNoOp:")) {
            return this.readIRNoOpBody();
        }
        if (name.equals("IRField:")) {
            return this.readIRFieldBody();
        }
        if (name.equals("IRGetProp:")) {
            return this.readIRGetPropBody();
        }
        if (name.equals("IRSetProp:")) {
            return this.readIRSetPropBody();
        }
        if (name.equals("IRBin:")) {
            return this.readIRBinBody();
        }
        if (name.equals("IRUn:")) {
            return this.readIRUnBody();
        }
        if (name.equals("IRLoad:")) {
            return this.readIRLoadBody();
        }
        if (name.equals("IRUserId:")) {
            return this.readIRUserIdBody();
        }
        if (name.equals("IRTmpId:")) {
            return this.readIRTmpIdBody();
        }
        if (name.equals("IRThis:")) {
            return this.readIRThisBody();
        }
        if (name.equals("IRNumber:")) {
            return this.readIRNumberBody();
        }
        if (name.equals("IRString:")) {
            return this.readIRStringBody();
        }
        if (name.equals("IRBool:")) {
            return this.readIRBoolBody();
        }
        if (name.equals("IRUndef:")) {
            return this.readIRUndefBody();
        }
        if (name.equals("IRNull:")) {
            return this.readIRNullBody();
        }
        if (name.equals("IROp:")) {
            return this.readIROpBody();
        }
        if (name.equals("IRFunctional:")) {
            return this.readIRFunctionalBody();
        }
        if (name.equals("IRSpanInfo:")) {
            return this.readIRSpanInfoBody();
        }
        throw this.error();
    }

    private IRRoot readIRRootBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("fds = ");
        List<IRFunDecl> read_fds = this.readListOfIRFunDecl();
        this.readFieldDelim("vds = ");
        List<IRVarStmt> read_vds = this.readListOfIRVarStmt();
        this.readFieldDelim("irs = ");
        List<IRStmt> read_irs = this.readListOfIRStmt();
        return new IRRoot(read_info, read_fds, read_vds, read_irs);
    }

    private IRExprStmt readIRExprStmtBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("lhs = ");
        IRId read_lhs = (IRId)this.readIRNode();
        this.readFieldDelim("right = ");
        IRExpr read_right = (IRExpr)this.readIRNode();
        this.readFieldDelim("ref = ");
        boolean read_ref = this.readBoolean();
        return new IRExprStmt(read_info, read_lhs, read_right, read_ref);
    }

    private IRDelete readIRDeleteBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("lhs = ");
        IRId read_lhs = (IRId)this.readIRNode();
        this.readFieldDelim("id = ");
        IRId read_id = (IRId)this.readIRNode();
        return new IRDelete(read_info, read_lhs, read_id);
    }

    private IRDeleteProp readIRDeletePropBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("lhs = ");
        IRId read_lhs = (IRId)this.readIRNode();
        this.readFieldDelim("obj = ");
        IRId read_obj = (IRId)this.readIRNode();
        this.readFieldDelim("index = ");
        IRExpr read_index = (IRExpr)this.readIRNode();
        return new IRDeleteProp(read_info, read_lhs, read_obj, read_index);
    }

    private IRObject readIRObjectBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("lhs = ");
        IRId read_lhs = (IRId)this.readIRNode();
        this.readFieldDelim("members = ");
        List<IRMember> read_members = this.readListOfIRMember();
        this.readFieldDelim("proto = ");
        Option<IRId> read_proto = this.readOptionOfIRId();
        return new IRObject(read_info, read_lhs, read_members, read_proto);
    }

    private IRArray readIRArrayBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("lhs = ");
        IRId read_lhs = (IRId)this.readIRNode();
        this.readFieldDelim("elements = ");
        List<Option<IRExpr>> read_elements = this.readListOfOptionOfIRExpr();
        return new IRArray(read_info, read_lhs, read_elements);
    }

    private IRArrayNumber readIRArrayNumberBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("lhs = ");
        IRId read_lhs = (IRId)this.readIRNode();
        this.readFieldDelim("elements = ");
        List<Double> read_elements = this.readListOfDouble();
        return new IRArrayNumber(read_info, read_lhs, read_elements);
    }

    private IRArgs readIRArgsBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("lhs = ");
        IRId read_lhs = (IRId)this.readIRNode();
        this.readFieldDelim("elements = ");
        List<Option<IRExpr>> read_elements = this.readListOfOptionOfIRExpr();
        return new IRArgs(read_info, read_lhs, read_elements);
    }

    private IRCall readIRCallBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("lhs = ");
        IRId read_lhs = (IRId)this.readIRNode();
        this.readFieldDelim("fun = ");
        IRId read_fun = (IRId)this.readIRNode();
        this.readFieldDelim("thisB = ");
        IRId read_thisB = (IRId)this.readIRNode();
        this.readFieldDelim("args = ");
        IRId read_args = (IRId)this.readIRNode();
        return new IRCall(read_info, read_lhs, read_fun, read_thisB, read_args);
    }

    private IRInternalCall readIRInternalCallBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("lhs = ");
        IRId read_lhs = (IRId)this.readIRNode();
        this.readFieldDelim("fun = ");
        IRId read_fun = (IRId)this.readIRNode();
        this.readFieldDelim("first = ");
        IRExpr read_first = (IRExpr)this.readIRNode();
        this.readFieldDelim("second = ");
        Option<IRId> read_second = this.readOptionOfIRId();
        return new IRInternalCall(read_info, read_lhs, read_fun, read_first, read_second);
    }

    private IRNew readIRNewBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("lhs = ");
        IRId read_lhs = (IRId)this.readIRNode();
        this.readFieldDelim("fun = ");
        IRId read_fun = (IRId)this.readIRNode();
        this.readFieldDelim("args = ");
        List<IRId> read_args = this.readListOfIRId();
        return new IRNew(read_info, read_lhs, read_fun, read_args);
    }

    private IRFunExpr readIRFunExprBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("lhs = ");
        IRId read_lhs = (IRId)this.readIRNode();
        this.readFieldDelim("ftn = ");
        IRFunctional read_ftn = (IRFunctional)this.readIRNode();
        return new IRFunExpr(read_info, read_lhs, read_ftn);
    }

    private IREval readIREvalBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("lhs = ");
        IRId read_lhs = (IRId)this.readIRNode();
        this.readFieldDelim("arg = ");
        IRExpr read_arg = (IRExpr)this.readIRNode();
        return new IREval(read_info, read_lhs, read_arg);
    }

    private IRStmtUnit readIRStmtUnitBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("stmts = ");
        List<IRStmt> read_stmts = this.readListOfIRStmt();
        return new IRStmtUnit(read_info, read_stmts);
    }

    private IRStore readIRStoreBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("obj = ");
        IRId read_obj = (IRId)this.readIRNode();
        this.readFieldDelim("index = ");
        IRExpr read_index = (IRExpr)this.readIRNode();
        this.readFieldDelim("rhs = ");
        IRExpr read_rhs = (IRExpr)this.readIRNode();
        return new IRStore(read_info, read_obj, read_index, read_rhs);
    }

    private IRFunDecl readIRFunDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("ftn = ");
        IRFunctional read_ftn = (IRFunctional)this.readIRNode();
        return new IRFunDecl(read_info, read_ftn);
    }

    private IRBreak readIRBreakBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("label = ");
        IRId read_label = (IRId)this.readIRNode();
        return new IRBreak(read_info, read_label);
    }

    private IRReturn readIRReturnBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("expr = ");
        Option<IRExpr> read_expr = this.readOptionOfIRExpr();
        return new IRReturn(read_info, read_expr);
    }

    private IRWith readIRWithBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("id = ");
        IRId read_id = (IRId)this.readIRNode();
        this.readFieldDelim("stmt = ");
        IRStmt read_stmt = (IRStmt)this.readIRNode();
        return new IRWith(read_info, read_id, read_stmt);
    }

    private IRLabelStmt readIRLabelStmtBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("label = ");
        IRId read_label = (IRId)this.readIRNode();
        this.readFieldDelim("stmt = ");
        IRStmt read_stmt = (IRStmt)this.readIRNode();
        return new IRLabelStmt(read_info, read_label, read_stmt);
    }

    private IRVarStmt readIRVarStmtBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("lhs = ");
        IRId read_lhs = (IRId)this.readIRNode();
        this.readFieldDelim("fromParam = ");
        boolean read_fromParam = this.readBoolean();
        return new IRVarStmt(read_info, read_lhs, read_fromParam);
    }

    private IRThrow readIRThrowBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("expr = ");
        IRExpr read_expr = (IRExpr)this.readIRNode();
        return new IRThrow(read_info, read_expr);
    }

    private IRSeq readIRSeqBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("stmts = ");
        List<IRStmt> read_stmts = this.readListOfIRStmt();
        return new IRSeq(read_info, read_stmts);
    }

    private IRIf readIRIfBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("expr = ");
        IRExpr read_expr = (IRExpr)this.readIRNode();
        this.readFieldDelim("trueB = ");
        IRStmt read_trueB = (IRStmt)this.readIRNode();
        this.readFieldDelim("falseB = ");
        Option<IRStmt> read_falseB = this.readOptionOfIRStmt();
        return new IRIf(read_info, read_expr, read_trueB, read_falseB);
    }

    private IRWhile readIRWhileBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("cond = ");
        IRExpr read_cond = (IRExpr)this.readIRNode();
        this.readFieldDelim("body = ");
        IRStmt read_body = (IRStmt)this.readIRNode();
        return new IRWhile(read_info, read_cond, read_body);
    }

    private IRTry readIRTryBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("body = ");
        IRStmt read_body = (IRStmt)this.readIRNode();
        this.readFieldDelim("name = ");
        Option<IRId> read_name = this.readOptionOfIRId();
        this.readFieldDelim("catchB = ");
        Option<IRStmt> read_catchB = this.readOptionOfIRStmt();
        this.readFieldDelim("finallyB = ");
        Option<IRStmt> read_finallyB = this.readOptionOfIRStmt();
        return new IRTry(read_info, read_body, read_name, read_catchB, read_finallyB);
    }

    private IRNoOp readIRNoOpBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("desc = ");
        String read_desc = this.readString();
        return new IRNoOp(read_info, read_desc);
    }

    private IRField readIRFieldBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("prop = ");
        IRId read_prop = (IRId)this.readIRNode();
        this.readFieldDelim("expr = ");
        IRExpr read_expr = (IRExpr)this.readIRNode();
        return new IRField(read_info, read_prop, read_expr);
    }

    private IRGetProp readIRGetPropBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("ftn = ");
        IRFunctional read_ftn = (IRFunctional)this.readIRNode();
        return new IRGetProp(read_info, read_ftn);
    }

    private IRSetProp readIRSetPropBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("ftn = ");
        IRFunctional read_ftn = (IRFunctional)this.readIRNode();
        return new IRSetProp(read_info, read_ftn);
    }

    private IRBin readIRBinBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("first = ");
        IRExpr read_first = (IRExpr)this.readIRNode();
        this.readFieldDelim("op = ");
        IROp read_op = (IROp)this.readIRNode();
        this.readFieldDelim("second = ");
        IRExpr read_second = (IRExpr)this.readIRNode();
        return new IRBin(read_info, read_first, read_op, read_second);
    }

    private IRUn readIRUnBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("op = ");
        IROp read_op = (IROp)this.readIRNode();
        this.readFieldDelim("expr = ");
        IRExpr read_expr = (IRExpr)this.readIRNode();
        return new IRUn(read_info, read_op, read_expr);
    }

    private IRLoad readIRLoadBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("obj = ");
        IRId read_obj = (IRId)this.readIRNode();
        this.readFieldDelim("index = ");
        IRExpr read_index = (IRExpr)this.readIRNode();
        return new IRLoad(read_info, read_obj, read_index);
    }

    private IRUserId readIRUserIdBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("originalName = ");
        String read_originalName = this.readString();
        this.readFieldDelim("uniqueName = ");
        String read_uniqueName = this.readString();
        this.readFieldDelim("global = ");
        boolean read_global = this.readBoolean();
        this.readFieldDelim("with = ");
        boolean read_with = this.readBoolean();
        return new IRUserId(read_info, read_originalName, read_uniqueName, read_global, read_with);
    }

    private IRTmpId readIRTmpIdBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("originalName = ");
        String read_originalName = this.readString();
        this.readFieldDelim("uniqueName = ");
        String read_uniqueName = this.readString();
        this.readFieldDelim("global = ");
        boolean read_global = this.readBoolean();
        return new IRTmpId(read_info, read_originalName, read_uniqueName, read_global);
    }

    private IRThis readIRThisBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        return new IRThis(read_info);
    }

    private IRNumber readIRNumberBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("text = ");
        String read_text = this.readString();
        this.readFieldDelim("num = ");
        Double read_num = (Double)this.readUnknownObject();
        return new IRNumber(read_info, read_text, read_num);
    }

    private IRString readIRStringBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("str = ");
        String read_str = this.readString();
        return new IRString(read_info, read_str);
    }

    private IRBool readIRBoolBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        this.readFieldDelim("bool = ");
        boolean read_bool = this.readBoolean();
        return new IRBool(read_info, read_bool);
    }

    private IRUndef readIRUndefBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        return new IRUndef(read_info);
    }

    private IRNull readIRNullBody() throws IOException {
        this.readFieldDelim("info = ");
        IRSpanInfo read_info = (IRSpanInfo)this.readIRNode();
        return new IRNull(read_info);
    }

    private IROp readIROpBody() throws IOException {
        this.readFieldDelim("text = ");
        String read_text = this.readString();
        this.readFieldDelim("kind = ");
        int read_kind = this.readInt();
        return new IROp(read_text, read_kind);
    }

    private IRFunctional readIRFunctionalBody() throws IOException {
        this.readFieldDelim("fromSource = ");
        boolean read_fromSource = this.readBoolean();
        this.readFieldDelim("name = ");
        IRId read_name = (IRId)this.readIRNode();
        this.readFieldDelim("params = ");
        List<IRId> read_params = this.readListOfIRId();
        this.readFieldDelim("args = ");
        List<IRStmt> read_args = this.readListOfIRStmt();
        this.readFieldDelim("fds = ");
        List<IRFunDecl> read_fds = this.readListOfIRFunDecl();
        this.readFieldDelim("vds = ");
        List<IRVarStmt> read_vds = this.readListOfIRVarStmt();
        this.readFieldDelim("body = ");
        List<IRStmt> read_body = this.readListOfIRStmt();
        return new IRFunctional(read_fromSource, read_name, read_params, read_args, read_fds, read_vds, read_body);
    }

    private IRSpanInfo readIRSpanInfoBody() throws IOException {
        this.readFieldDelim("fromSource = ");
        boolean read_fromSource = this.readBoolean();
        this.readFieldDelim("span = ");
        Span read_span = (Span)this.readUnknownObject();
        return new IRSpanInfo(read_fromSource, read_span);
    }

    private List<IRFunDecl> readListOfIRFunDecl() throws IOException {
        this.readExpected("{");
        ArrayList<IRFunDecl> accum = new ArrayList<IRFunDecl>();
        while (this.readMoreListElements()) {
            accum.add((IRFunDecl)this.readIRNode());
        }
        return accum;
    }

    private List<IRVarStmt> readListOfIRVarStmt() throws IOException {
        this.readExpected("{");
        ArrayList<IRVarStmt> accum = new ArrayList<IRVarStmt>();
        while (this.readMoreListElements()) {
            accum.add((IRVarStmt)this.readIRNode());
        }
        return accum;
    }

    private List<IRStmt> readListOfIRStmt() throws IOException {
        this.readExpected("{");
        ArrayList<IRStmt> accum = new ArrayList<IRStmt>();
        while (this.readMoreListElements()) {
            accum.add((IRStmt)this.readIRNode());
        }
        return accum;
    }

    private List<IRMember> readListOfIRMember() throws IOException {
        this.readExpected("{");
        ArrayList<IRMember> accum = new ArrayList<IRMember>();
        while (this.readMoreListElements()) {
            accum.add((IRMember)this.readIRNode());
        }
        return accum;
    }

    private Option<IRId> readOptionOfIRId() throws IOException {
        if (this.readOptionHeader()) {
            IRId elt_result = (IRId)this.readIRNode();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    private Option<IRExpr> readOptionOfIRExpr() throws IOException {
        if (this.readOptionHeader()) {
            IRExpr elt_result = (IRExpr)this.readIRNode();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    private List<Option<IRExpr>> readListOfOptionOfIRExpr() throws IOException {
        this.readExpected("{");
        ArrayList<Option<IRExpr>> accum = new ArrayList<Option<IRExpr>>();
        while (this.readMoreListElements()) {
            accum.add(this.readOptionOfIRExpr());
        }
        return accum;
    }

    private List<Double> readListOfDouble() throws IOException {
        this.readExpected("{");
        ArrayList<Double> accum = new ArrayList<Double>();
        while (this.readMoreListElements()) {
            accum.add((Double)this.readUnknownObject());
        }
        return accum;
    }

    private List<IRId> readListOfIRId() throws IOException {
        this.readExpected("{");
        ArrayList<IRId> accum = new ArrayList<IRId>();
        while (this.readMoreListElements()) {
            accum.add((IRId)this.readIRNode());
        }
        return accum;
    }

    private Option<IRStmt> readOptionOfIRStmt() throws IOException {
        if (this.readOptionHeader()) {
            IRStmt elt_result = (IRStmt)this.readIRNode();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    protected boolean readBoolean() throws IOException {
        char c;
        char t = c = this.readCharWord();
        while (!Character.isWhitespace(t)) {
            t = this.next();
        }
        if (c == 't') {
            return true;
        }
        if (c == 'f') {
            return false;
        }
        throw this.error();
    }

    protected char readChar() throws IOException {
        this.readExpected("\"");
        String word = this.readTo('\"', true);
        String result = this.unescape(word);
        if (result.length() != 1) {
            throw this.error();
        }
        return result.charAt(0);
    }

    protected byte readByte() throws IOException {
        String word = this.readNum();
        try {
            return Byte.parseByte(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected short readShort() throws IOException {
        String word = this.readNum();
        try {
            return Short.parseShort(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected int readInt() throws IOException {
        String word = this.readNum();
        try {
            return Integer.parseInt(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected long readLong() throws IOException {
        String word = this.readNum();
        try {
            return Long.parseLong(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected float readFloat() throws IOException {
        String word = this.readWord();
        try {
            return Float.parseFloat(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected double readDouble() throws IOException {
        String word = this.readWord();
        try {
            return Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected String readString() throws IOException {
        char delim = this.readCharWord();
        if (delim == '_') {
            return null;
        }
        if (delim != '\"') {
            throw this.error();
        }
        this.next();
        String word = this.readTo('\"', true);
        return this.unescape(word);
    }

    protected Object wordToUnknownObject(String word) throws IOException {
        if (word.equals("_")) {
            return null;
        }
        ObjectInputStream objIn = this.toObjectStream(word);
        try {
            Object object = objIn.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("ClassNotFoundException: " + e.getMessage());
        }
        finally {
            try {
                objIn.close();
            }
            catch (IOException e) {}
        }
    }

    protected Object readUnknownObject() throws IOException {
        String word = this.readWord();
        this.readToNewline();
        return this.wordToUnknownObject(word);
    }

    protected String readWord() throws IOException {
        char c = this.readCharWord();
        StringBuilder result = new StringBuilder();
        do {
            result.append(c);
        } while (!Character.isWhitespace(c = this.next()));
        return result.toString();
    }

    protected String readNum() throws IOException {
        char c = this.readCharWord();
        StringBuilder result = new StringBuilder();
        if (c != '-' && !Character.isDigit(c)) {
            throw this.error();
        }
        do {
            result.append(c);
        } while (Character.isDigit(c = this.next()));
        return result.toString();
    }

    protected char readCharWord() throws IOException {
        char c = this.currentChar;
        while (Character.isWhitespace(c)) {
            c = this.next();
        }
        return c;
    }

    protected void readExpected(String s) throws IOException {
        char c = this.readCharWord();
        for (int i = 0; i < s.length(); ++i) {
            if (c != s.charAt(i)) {
                System.out.println("Was expecting '" + s + "', saw '" + c + "' instead of '" + s.charAt(i) + "'");
                throw this.error();
            }
            c = this.next();
        }
    }

    protected void readFieldDelim(String s) throws IOException {
        this.readExpected(s);
    }

    protected boolean readMoreListElements() throws IOException {
        char c = this.readCharWord();
        if (c == '}') {
            this.next();
            return false;
        }
        if (c == '*') {
            this.next();
            return true;
        }
        throw this.error();
    }

    protected boolean readOptionHeader() throws IOException {
        char c = this.readCharWord();
        if (c == '~') {
            this.next();
            return false;
        }
        if (c == '(') {
            this.next();
            return true;
        }
        throw this.error();
    }

    protected String readTo(char delim, boolean skipEscape) throws IOException {
        StringBuilder result = new StringBuilder();
        boolean escape2 = false;
        char c = this.curr();
        while (escape2 || c != delim) {
            if (c == '\n' || c == '\r') {
                throw this.error();
            }
            result.append(c);
            if (escape2) {
                escape2 = false;
            } else if (skipEscape && c == '\\') {
                escape2 = true;
            }
            c = this.next();
        }
        this.next();
        return result.toString();
    }

    protected char skipTo(char ... delims) throws IOException {
        char c = this.currentChar;
        while (true) {
            if (c == '\n' || c == '\r') {
                throw this.error();
            }
            for (char delim : delims) {
                if (c != delim) continue;
                return delim;
            }
            c = this.next();
        }
    }

    protected String readToNewline() throws IOException {
        String result = this.in.readLine();
        if (result == null) {
            throw this.error();
        }
        this.readCharWord();
        return result;
    }

    protected char next() throws IOException {
        int c = this.in.read();
        if (c == -1) {
            throw this.error();
        }
        this.currentChar = (char)c;
        return this.currentChar;
    }

    protected char curr() {
        return this.currentChar;
    }

    protected String unescape(String s) throws IOException {
        boolean escape2 = false;
        StringBuilder digits = new StringBuilder();
        boolean changed = false;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (escape2) {
                switch (c) {
                    case 'b': {
                        result.append('\b');
                        break;
                    }
                    case 't': {
                        result.append('\t');
                        break;
                    }
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case 'f': {
                        result.append('\f');
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        result.append(c);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        digits.append(c);
                        if (digits.length() != 3) break;
                        result.append((char)Integer.parseInt(digits.toString(), 8));
                        digits.setLength(0);
                        break;
                    }
                    default: {
                        throw this.error();
                    }
                }
                if (digits.length() != 0) continue;
                escape2 = false;
                continue;
            }
            if (c == '\\') {
                escape2 = true;
                changed = true;
                continue;
            }
            result.append(c);
        }
        if (escape2) {
            throw this.error();
        }
        return changed ? result.toString() : s;
    }

    protected ObjectInputStream toObjectStream(String byteString) throws IOException {
        if (byteString.length() % 2 != 0) {
            throw this.error();
        }
        int length2 = byteString.length() / 2;
        byte[] bytes = new byte[length2];
        for (int i = 0; i < length2; ++i) {
            String b = byteString.substring(i * 2, i * 2 + 2);
            try {
                int unsigned = Integer.parseInt(b, 16);
                if (unsigned < 128) {
                    bytes[i] = (byte)unsigned;
                    continue;
                }
                bytes[i] = (byte)(unsigned - 256);
                continue;
            }
            catch (NumberFormatException e) {
                throw this.error();
            }
        }
        return new ObjectInputStream(new ByteArrayInputStream(bytes));
    }

    protected IOException error() {
        return new IOException("Serialized data is not properly encoded");
    }
}

