/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SmallMap<K, V>
implements Map<K, V> {
    private static final boolean DEBUG_USAGE = false;
    private static final int DEBUG_MAX_SIZE = 20;
    private Object[] keysAndValues;

    @Override
    public int size() {
        if (this.keysAndValues == null) {
            return 0;
        }
        return this.keysAndValues.length / 2;
    }

    public K getKey(int i) throws IllegalStateException {
        if (this.keysAndValues == null) {
            throw new IllegalStateException("getKey on empty map");
        }
        try {
            return (K)this.keysAndValues[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid i: " + i);
        }
    }

    public Object getValue(int i) throws IllegalStateException {
        if (this.keysAndValues == null) {
            throw new IllegalStateException("getValue on empty map");
        }
        try {
            return this.keysAndValues[this.size() + i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("illegal i: " + i);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.keysAndValues == null;
    }

    @Override
    public boolean containsKey(Object key) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.keysAndValues[i].equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.keysAndValues == null) {
            return false;
        }
        for (int i = this.size(); i < this.keysAndValues.length; ++i) {
            Object v = this.keysAndValues[i];
            if (!(v == null ? value == null : v.equals(value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key != null) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.keysAndValues[i] == null || !this.keysAndValues[i].equals(key)) continue;
                return (V)this.keysAndValues[this.size() + i];
            }
        }
        return null;
    }

    private void growByOne() {
        int i;
        Object[] old = this.keysAndValues;
        int length = old == null ? 0 : old.length;
        this.keysAndValues = new Object[length + 2];
        for (i = 0; i < length / 2; ++i) {
            this.keysAndValues[i] = old[i];
        }
        for (i = 0; i < length / 2; ++i) {
            this.keysAndValues[i + 1 + length / 2] = old[length / 2 + i];
        }
    }

    @Override
    public V put(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.keysAndValues[i] == null || !this.keysAndValues[i].equals(key)) continue;
            Object result = this.keysAndValues[this.size() + i];
            this.keysAndValues[this.size() + i] = value;
            return (V)result;
        }
        this.growByOne();
        this.keysAndValues[this.size() - 1] = key;
        this.keysAndValues[this.keysAndValues.length - 1] = value;
        return null;
    }

    @Override
    public V remove(Object key) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.keysAndValues = null;
    }

    @Override
    public Set<K> keySet() {
        HashSet result = HashSetFactory.make(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.add(this.keysAndValues[i]);
        }
        return result;
    }

    @Override
    public Collection<V> values() {
        int s = this.size();
        if (s == 0) {
            return Collections.emptySet();
        }
        HashSet result = HashSetFactory.make(s);
        for (int i = s; i < this.keysAndValues.length; ++i) {
            result.add(this.keysAndValues[i]);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() throws UnimplementedError {
        Assertions.UNREACHABLE("must implement entrySet");
        return null;
    }
}

