/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.traceparser;

public class SourceLocation {
    private final String specialDesc;
    public static final SourceLocation END_OF_PROGRAM = new SourceLocation("end of program");
    public static final SourceLocation INITIAL_DOM = new SourceLocation("initial DOM");
    public static final SourceLocation UNKNOWN = new SourceLocation("unknown");
    public final String file;
    public final long startLine;
    public final long startColumn;
    public final long endLine;
    public final long endColumn;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceLocation that = (SourceLocation)o;
        if (this.specialDesc != null) {
            return this.specialDesc.equals(that.specialDesc);
        }
        if (this.startColumn != that.startColumn) {
            return false;
        }
        if (this.startLine != that.startLine) {
            return false;
        }
        if (this.endColumn != that.endColumn) {
            return false;
        }
        if (this.endLine != that.endLine) {
            return false;
        }
        return this.file.equals(that.file);
    }

    public int hashCode() {
        if (this.specialDesc != null) {
            return this.specialDesc.hashCode();
        }
        int result = this.file.hashCode();
        result = 31 * result + (int)(this.startLine ^ this.startLine >>> 32);
        result = 31 * result + (int)(this.startColumn ^ this.startColumn >>> 32);
        result = 31 * result + (int)(this.endLine ^ this.endLine >>> 32);
        result = 31 * result + (int)(this.endColumn ^ this.endColumn >>> 32);
        return result;
    }

    public SourceLocation(String file, long startLine, long startColumn, long endLine, long endColumn) {
        assert (file != null);
        this.file = file;
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
        this.specialDesc = null;
    }

    private SourceLocation(String specialDesc) {
        this.specialDesc = specialDesc;
        this.file = null;
        this.startLine = -1L;
        this.startColumn = -1L;
        this.endLine = -1L;
        this.endColumn = -1L;
    }

    public boolean isSpecial() {
        return this.specialDesc != null;
    }

    public String toString() {
        if (this.specialDesc != null) {
            return this.specialDesc;
        }
        StringBuilder result = new StringBuilder();
        result.append(this.file);
        result.append(":");
        result.append(this.startLine);
        result.append(":");
        result.append(this.startColumn);
        result.append(":");
        result.append(this.endLine);
        result.append(":");
        result.append(this.endColumn);
        return result.toString();
    }
}

