/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.referencecounter.heap;

import com.ibm.wala.util.collections.HashSetFactory;
import com.samsung.memoryanalysis.referencecounter.heap.ContextOrObjectId;
import com.samsung.memoryanalysis.referencecounter.heap.HeapEdge;
import com.samsung.memoryanalysis.referencecounter.heap.NamedEdge;
import com.samsung.memoryanalysis.referencecounter.heap.NamedMultiEdge;
import com.samsung.memoryanalysis.referencecounter.heap.ReferenceCountedHeapGraph;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DirectedPseudograph;
import org.jgrapht.traverse.BreadthFirstIterator;

public class JGraphHeap
extends ReferenceCountedHeapGraph {
    private final DirectedGraph<ContextOrObjectId, HeapEdge> heap = new DirectedPseudograph(HeapEdge.class);

    @Override
    public void newNode(ContextOrObjectId o) {
        this.heap.addVertex((Object)o);
    }

    @Override
    public void addEdge(NamedEdge e, ContextOrObjectId to) {
        this.heap.addEdge((Object)e.getFrom(), (Object)to, (Object)e);
    }

    @Override
    protected void removeEdge(HeapEdge e) {
        this.heap.removeEdge((Object)e);
    }

    @Override
    protected void removeNode(ContextOrObjectId node) {
        this.heap.removeVertex((Object)node);
    }

    @Override
    protected Iterator<ContextOrObjectId> bfsIterator(ContextOrObjectId start) {
        assert (this.heap.containsVertex((Object)start));
        return new BreadthFirstIterator(this.heap, (Object)start);
    }

    @Override
    protected Iterator<ContextOrObjectId> bfsIterator() {
        return new BreadthFirstIterator(this.heap);
    }

    @Override
    public int referenceCount(ContextOrObjectId node) {
        if (!this.heap.containsVertex((Object)node)) {
            return 0;
        }
        return this.heap.inDegreeOf((Object)node);
    }

    @Override
    public boolean containsNode(ContextOrObjectId v) {
        return this.heap.containsVertex((Object)v);
    }

    @Override
    public Set<HeapEdge> incoming(ContextOrObjectId c) {
        return this.heap.incomingEdgesOf((Object)c);
    }

    @Override
    public void toDot(Writer w) {
    }

    @Override
    public Set<ContextOrObjectId> getAllNodes() {
        return this.heap.vertexSet();
    }

    @Override
    protected int getOutDegree(ContextOrObjectId obj) {
        return this.heap.containsVertex((Object)obj) ? this.heap.outDegreeOf((Object)obj) : 0;
    }

    @Override
    public Set<HeapEdge> getOutEdges(ContextOrObjectId node) {
        if (!this.heap.containsVertex((Object)node)) {
            return Collections.emptySet();
        }
        return this.heap.outgoingEdgesOf((Object)node);
    }

    @Override
    public Set<NamedEdge> getNamedOutEdges(ContextOrObjectId node) {
        HashSet result = HashSetFactory.make();
        for (HeapEdge e : this.getOutEdges(node)) {
            if (!(e instanceof NamedEdge)) continue;
            result.add((NamedEdge)e);
        }
        return result;
    }

    @Override
    public ContextOrObjectId getTarget(HeapEdge e) {
        return this.heap.containsEdge((Object)e) ? (ContextOrObjectId)this.heap.getEdgeTarget((Object)e) : null;
    }

    @Override
    protected void addNamedMultiEdge(NamedMultiEdge edge) {
        this.heap.addEdge((Object)edge.getFrom(), (Object)edge.getChild(), (Object)edge);
    }
}

