/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.tables;

import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.tables.StringTable;
import com.ibm.wala.util.tables.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class Query {
    public static <T> Collection<Map<String, T>> selectStarWhereEquals(Table<T> t, String column, T value) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        ArrayList<Map<String, T>> result = new ArrayList<Map<String, T>>();
        for (int i = 0; i < t.getNumberOfRows(); ++i) {
            Map<String, T> p = t.row2Map(i);
            if (!p.get(column).equals(value)) continue;
            result.add(p);
        }
        return result;
    }

    public static <T> Collection<T> selectWhereEquals(Table<T> t, String attribute, String column, T value) {
        Collection<Map<String, T>> rows = Query.selectStarWhereEquals(t, column, value);
        HashSet result = HashSetFactory.make();
        for (Map<String, T> p : rows) {
            result.add(p.get(attribute));
        }
        return result;
    }

    public static <T> Collection<Map<String, T>> selectStarWhere(Table<T> t, String column, Predicate<T> P) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        ArrayList<Map<String, T>> c = new ArrayList<Map<String, T>>();
        for (int i = 0; i < t.getNumberOfRows(); ++i) {
            Map<String, T> p = t.row2Map(i);
            T s = p.get(column);
            if (!P.test(s)) continue;
            c.add(p);
        }
        return c;
    }

    public static <T> Table<T> viewWhereEquals(Table<T> t, String column, T value) {
        Collection<Map<String, T>> c = Query.selectStarWhereEquals(t, column, value);
        Table<T> result = new Table<T>(t);
        for (Map<String, T> p : c) {
            result.addRow(p);
        }
        return result;
    }

    public static StringTable viewWhereEquals(StringTable t, String column, String value) {
        Collection<Map<String, String>> c = Query.selectStarWhereEquals(t, column, value);
        StringTable result = new StringTable(t);
        for (Map<String, String> p : c) {
            result.addRow(p);
        }
        return result;
    }
}

