/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import edu.rice.cs.plt.tuple.Option;
import java.util.List;
import kr.ac.kaist.jsaf.nodes.IRAbstractNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRAbstractNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.IRAssign;
import kr.ac.kaist.jsaf.nodes.IRId;
import kr.ac.kaist.jsaf.nodes.IRMember;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.IRSpanInfo;
import kr.ac.kaist.jsaf.nodes.TreeWalker;

public class IRObject
extends IRAssign {
    private final List<IRMember> _members;
    private final Option<IRId> _proto;

    public IRObject(IRSpanInfo in_info, IRId in_lhs, List<IRMember> in_members, Option<IRId> in_proto) {
        super(in_info, in_lhs);
        if (in_members == null) {
            throw new IllegalArgumentException("Parameter 'members' to the IRObject constructor was null");
        }
        this._members = in_members;
        if (in_proto == null) {
            throw new IllegalArgumentException("Parameter 'proto' to the IRObject constructor was null");
        }
        this._proto = in_proto;
    }

    public final List<IRMember> getMembers() {
        return this._members;
    }

    public final Option<IRId> getProto() {
        return this._proto;
    }

    @Override
    public <RetType> RetType accept(IRAbstractNodeVisitor<RetType> visitor) {
        return visitor.forIRObject(this);
    }

    @Override
    public <RetType> RetType accept(IRNodeVisitor<RetType> visitor) {
        return visitor.forIRObject(this);
    }

    @Override
    public void accept(IRAbstractNodeVisitor_void visitor) {
        visitor.forIRObject(this);
    }

    @Override
    public void accept(IRNodeVisitor_void visitor) {
        visitor.forIRObject(this);
    }

    public boolean equals(Object obj) {
        Option<IRId> casted_proto;
        List<IRMember> casted_members;
        IRId casted_lhs;
        IRSpanInfo casted_info;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        IRObject casted = (IRObject)obj;
        IRSpanInfo temp_info = this.getInfo();
        if (temp_info != (casted_info = casted.getInfo()) && !temp_info.equals(casted_info)) {
            return false;
        }
        IRId temp_lhs = this.getLhs();
        if (temp_lhs != (casted_lhs = casted.getLhs()) && !temp_lhs.equals(casted_lhs)) {
            return false;
        }
        List<IRMember> temp_members = this.getMembers();
        if (temp_members != (casted_members = casted.getMembers()) && !temp_members.equals(casted_members)) {
            return false;
        }
        Option<IRId> temp_proto = this.getProto();
        return temp_proto == (casted_proto = casted.getProto()) || temp_proto.equals(casted_proto);
    }

    @Override
    public int generateHashCode() {
        int code = this.getClass().hashCode();
        IRSpanInfo temp_info = this.getInfo();
        code ^= temp_info.hashCode();
        IRId temp_lhs = this.getLhs();
        code ^= temp_lhs.hashCode();
        List<IRMember> temp_members = this.getMembers();
        code ^= temp_members.hashCode();
        Option<IRId> temp_proto = this.getProto();
        return code ^= temp_proto.hashCode();
    }

    protected IRObject() {
        this._members = null;
        this._proto = null;
    }

    @Override
    public void walk(TreeWalker w) {
        if (w.visitNode(this, "IRObject", 4)) {
            Option<IRId> temp_proto;
            List<IRMember> temp_members;
            IRId temp_lhs;
            IRSpanInfo temp_info = this.getInfo();
            if (w.visitNodeField("info", temp_info)) {
                temp_info.walk(w);
                w.endNodeField("info", temp_info);
            }
            if (w.visitNodeField("lhs", temp_lhs = this.getLhs())) {
                temp_lhs.walk(w);
                w.endNodeField("lhs", temp_lhs);
            }
            if (w.visitNodeField("members", temp_members = this.getMembers())) {
                if (w.visitIterated(temp_members)) {
                    int i_temp_members = 0;
                    for (IRMember elt_temp_members : temp_members) {
                        if (w.visitIteratedElement(i_temp_members, elt_temp_members)) {
                            if (elt_temp_members == null) {
                                w.visitNull();
                            } else {
                                elt_temp_members.walk(w);
                            }
                        }
                        ++i_temp_members;
                    }
                    w.endIterated(temp_members, i_temp_members);
                }
                w.endNodeField("members", temp_members);
            }
            if (w.visitNodeField("proto", temp_proto = this.getProto())) {
                if (temp_proto.isNone()) {
                    w.visitEmptyOption(temp_proto);
                } else if (w.visitNonEmptyOption(temp_proto)) {
                    IRId elt_temp_proto = (IRId)temp_proto.unwrap();
                    if (elt_temp_proto == null) {
                        w.visitNull();
                    } else {
                        elt_temp_proto.walk(w);
                    }
                    w.endNonEmptyOption(temp_proto);
                }
                w.endNodeField("proto", temp_proto);
            }
            w.endNode(this, "IRObject", 4);
        }
    }
}

