/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractFunctionalRelation;
import edu.rice.cs.plt.collect.AbstractPredicateSet;
import edu.rice.cs.plt.collect.LambdaMap;
import edu.rice.cs.plt.collect.OneToOneRelation;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.iter.EmptyIterator;
import edu.rice.cs.plt.iter.MutableSingletonIterator;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.tuple.Pair;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOneToOneRelation<T1, T2>
extends AbstractFunctionalRelation<T1, T2>
implements OneToOneRelation<T1, T2> {
    @Override
    public abstract boolean isStatic();

    @Override
    public abstract LambdaMap<T1, T2> functionMap();

    @Override
    public abstract LambdaMap<T2, T1> injectionMap();

    @Override
    public PredicateSet<T2> secondSet() {
        return this.injectionMap().keySet();
    }

    @Override
    public boolean containsSecond(T2 second) {
        return this.injectionMap().containsKey(second);
    }

    @Override
    public PredicateSet<T1> matchSecond(T2 second) {
        return new MatchSecondSet(second);
    }

    @Override
    public T1 antecedent(T2 second) {
        return (T1)this.injectionMap().get(second);
    }

    @Override
    public OneToOneRelation<T2, T1> inverse() {
        return new InverseOneToOneRelation();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InverseOneToOneRelation
    extends AbstractFunctionalRelation.InverseFunctionalRelation
    implements OneToOneRelation<T2, T1> {
        protected InverseOneToOneRelation() {
        }

        @Override
        public T1 value(T2 first) {
            return AbstractOneToOneRelation.this.antecedent(first);
        }

        @Override
        public LambdaMap<T2, T1> functionMap() {
            return AbstractOneToOneRelation.this.injectionMap();
        }

        @Override
        public OneToOneRelation<T1, T2> inverse() {
            return AbstractOneToOneRelation.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MatchSecondSet
    extends AbstractPredicateSet<T1>
    implements Serializable {
        private final T2 _key;

        public MatchSecondSet(T2 second) {
            this._key = second;
        }

        @Override
        public boolean isEmpty() {
            return !AbstractOneToOneRelation.this.injectionMap().containsKey(this._key);
        }

        @Override
        public int size() {
            return AbstractOneToOneRelation.this.injectionMap().containsKey(this._key) ? 1 : 0;
        }

        @Override
        public int size(int bound) {
            return bound == 0 ? 0 : this.size();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean hasFixedSize() {
            return AbstractOneToOneRelation.this.isStatic();
        }

        @Override
        public boolean isStatic() {
            return AbstractOneToOneRelation.this.isStatic();
        }

        @Override
        public boolean contains(Object val) {
            return AbstractOneToOneRelation.this.contains(Pair.make(val, this._key));
        }

        @Override
        public Iterator<T1> iterator() {
            final LambdaMap map = AbstractOneToOneRelation.this.injectionMap();
            if (map.containsKey(this._key)) {
                return new MutableSingletonIterator(map.get(this._key), new Runnable1<T1>(){

                    @Override
                    public void run(T1 val) {
                        map.remove(MatchSecondSet.this._key);
                    }
                });
            }
            return EmptyIterator.make();
        }

        @Override
        public boolean add(T1 val) {
            boolean result;
            boolean bl = result = !AbstractOneToOneRelation.this.contains(val, this._key);
            if (result) {
                AbstractOneToOneRelation.this.injectionMap().put(this._key, val);
            }
            return result;
        }

        @Override
        public boolean remove(Object val) {
            boolean result = AbstractOneToOneRelation.this.contains(Pair.make(val, this._key));
            if (result) {
                AbstractOneToOneRelation.this.injectionMap().remove(this._key);
            }
            return result;
        }

        @Override
        public void clear() {
            AbstractOneToOneRelation.this.injectionMap().remove(this._key);
        }
    }
}

