/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<T>
implements Iterator<T> {
    protected int _cnt;
    protected final int last;
    protected final T[] _elts;

    public ArrayIterator(T[] elts) {
        this(elts, 0);
    }

    public ArrayIterator(T[] elts, int start) {
        if (elts == null) {
            throw new IllegalArgumentException("null elts");
        }
        if (start < 0 || start > elts.length) {
            throw new IllegalArgumentException("invalid start: " + start + ", arrray length " + elts.length);
        }
        this._elts = elts;
        this._cnt = start;
        this.last = this._elts.length - 1;
    }

    public ArrayIterator(T[] elts, int start, int last) {
        if (elts == null) {
            throw new IllegalArgumentException("null elts");
        }
        if (start < 0) {
            throw new IllegalArgumentException("illegal start: " + start);
        }
        if (last < 0) {
            throw new IllegalArgumentException("illegal last: " + last);
        }
        this._elts = elts;
        this._cnt = start;
        this.last = last;
    }

    @Override
    public boolean hasNext() {
        return this._cnt <= this.last;
    }

    @Override
    public T next() throws NoSuchElementException {
        if (this._cnt >= this._elts.length) {
            throw new NoSuchElementException();
        }
        return this._elts[this._cnt++];
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

