/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.referencecounter.heap;

import com.ibm.wala.util.collections.HashMapFactory;
import com.samsung.memoryanalysis.context.Context;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public class ContextOrObjectId {
    private static final Map<Integer, WeakReference<ContextOrObjectId>> intMap = HashMapFactory.make();
    private static final WeakHashMap<Context, WeakReference<ContextOrObjectId>> contextMap = new WeakHashMap();
    public final Type type;
    private final int id;
    private final Context context;

    public static ContextOrObjectId make(Context c) {
        ContextOrObjectId res;
        WeakReference<ContextOrObjectId> ref = contextMap.get(c);
        ContextOrObjectId contextOrObjectId = res = ref == null ? null : (ContextOrObjectId)ref.get();
        if (res == null) {
            res = new ContextOrObjectId(c);
            contextMap.put(c, new WeakReference<ContextOrObjectId>(res));
        }
        return res;
    }

    public static ContextOrObjectId make(int id) {
        ContextOrObjectId res;
        WeakReference<ContextOrObjectId> ref = intMap.get(id);
        ContextOrObjectId contextOrObjectId = res = ref == null ? null : (ContextOrObjectId)ref.get();
        if (res == null) {
            res = new ContextOrObjectId(id);
            intMap.put(id, new WeakReference<ContextOrObjectId>(res));
        }
        return res;
    }

    private ContextOrObjectId(Context c) {
        this.id = -1;
        this.context = c;
        this.type = Type.CONTEXT;
    }

    private ContextOrObjectId(int id) {
        this.id = id;
        this.context = null;
        this.type = Type.ID;
    }

    public String toString() {
        switch (this.type) {
            case CONTEXT: {
                return this.context.toString();
            }
            case ID: {
                return "" + this.id;
            }
        }
        return null;
    }

    public Context getContext() {
        return this.context;
    }

    public int getId() {
        return this.id;
    }

    public static enum Type {
        CONTEXT,
        ID;

    }
}

