/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.Iterator;

public final class BitSet<T> {
    private final BitVector vector;
    private OrdinalSetMapping<T> map;

    public BitSet(OrdinalSetMapping<T> map) {
        if (map == null) {
            throw new IllegalArgumentException("map is null");
        }
        int length = map.getMaximumIndex();
        this.vector = new BitVector(length);
        this.map = map;
    }

    public static <T> BitSet<T> createBitSet(BitSet<T> B) {
        if (B == null) {
            throw new IllegalArgumentException("null B");
        }
        return new BitSet<T>(B);
    }

    private BitSet(BitSet<T> B) {
        this(B.map);
        this.addAll(B);
    }

    public void addAll(BitSet<?> B) {
        if (B == null) {
            throw new IllegalArgumentException("B is null");
        }
        this.vector.or(B.vector);
    }

    public void addAll(BitVector B) {
        this.vector.or(B);
    }

    public void add(T o) {
        int n = this.map.getMappedIndex(o);
        this.vector.set(n);
    }

    public void clear(T o) {
        int n = this.map.getMappedIndex(o);
        if (n == -1) {
            return;
        }
        this.vector.clear(n);
    }

    public boolean contains(T o) {
        int n = this.map.getMappedIndex(o);
        if (n == -1) {
            return false;
        }
        return this.vector.get(n);
    }

    public String toString() {
        return this.vector.toString();
    }

    public void copyBits(BitSet<T> other) {
        if (other == null) {
            throw new IllegalArgumentException("other is null");
        }
        this.vector.copyBits(other.vector);
        this.map = other.map;
    }

    public boolean sameBits(BitSet<?> other) {
        if (other == null) {
            throw new IllegalArgumentException("other is null");
        }
        return this.vector.equals(other.vector);
    }

    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int next = -1;
            {
                for (int i = 0; i < BitSet.this.vector.length(); ++i) {
                    if (!BitSet.this.vector.get(i)) continue;
                    this.next = i;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != -1;
            }

            @Override
            public T next() {
                Object result = BitSet.this.map.getMappedObject(this.next);
                int start = this.next + 1;
                this.next = -1;
                for (int i = start; i < BitSet.this.vector.length(); ++i) {
                    if (!BitSet.this.vector.get(i)) continue;
                    this.next = i;
                    break;
                }
                return result;
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    public int size() {
        return this.vector.populationCount();
    }

    public int length() {
        return this.vector.length();
    }

    public void clearAll() {
        this.vector.clearAll();
    }

    public void setAll() {
        this.vector.setAll();
    }

    public void intersect(BitSet<?> other) {
        if (other == null) {
            throw new IllegalArgumentException("other is null");
        }
        this.vector.and(other.vector);
    }

    public void difference(BitSet<T> other) {
        if (other == null) {
            throw new IllegalArgumentException("other is null");
        }
        this.vector.and(BitVector.not(other.vector));
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

