/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.staleness;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.samsung.memoryanalysis.context.Context;
import com.samsung.memoryanalysis.referencecounter.UnreachabilityAwareAnalysis;
import com.samsung.memoryanalysis.staleness.ObjectStaleness;
import com.samsung.memoryanalysis.staleness.Staleness;
import com.samsung.memoryanalysis.traceparser.IIDMap;
import com.samsung.memoryanalysis.traceparser.Timer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StalenessAnalysis
implements UnreachabilityAwareAnalysis<Staleness> {
    private final Map<Integer, ObjectStaleness> staleness = HashMapFactory.make((int)256);
    private IIDMap iidMap;
    private List<long[]> functionTrace = new ArrayList<long[]>(1024);
    private final List<Integer> lackingModels = new ArrayList<Integer>();
    private final Deque<Integer> currentCallStack = new ArrayDeque<Integer>();
    private final Map<Integer, Set<Integer>> domParent2Children = HashMapFactory.make();
    private final Map<Integer, Integer> domChild2ParentCount = HashMapFactory.make();

    @Override
    public void functionEnter(int iid, int funId, int callSiteIID, Context newContext, long time) {
        this.functionTrace.add(new long[]{EntryOrExit.ENTRY.ordinal(), time, iid});
        this.currentCallStack.push(callSiteIID);
    }

    @Override
    public void functionExit(int iid, Context functionContext, Set<String> unReferenced, long time) {
        this.functionTrace.add(new long[]{EntryOrExit.EXIT.ordinal(), time, iid});
        this.currentCallStack.pop();
    }

    @Override
    public void init(Timer t, IIDMap iidMap) {
        this.iidMap = iidMap;
    }

    @Override
    public void create(int iid, int objectId, long time, boolean isDom) {
        if (objectId != 1) {
            this.insert(iid, objectId, time, this.callStackAsList(), isDom ? ObjectStaleness.ObjectType.DOM : ObjectStaleness.ObjectType.OBJECT);
        }
    }

    private void insert(int iid, int objectId, long time, List<Integer> callStack, ObjectStaleness.ObjectType type) {
        assert (!this.staleness.containsKey(objectId));
        this.staleness.put(objectId, new ObjectStaleness(iid, objectId, time, callStack, type));
    }

    private List<Integer> callStackAsList() {
        return new ArrayList<Integer>(this.currentCallStack);
    }

    @Override
    public void createFun(int iid, int objectId, int prototypeId, int functionEnterIID, Set<String> namesReferencedByClosures, Context context, long time) {
        this.insert(iid, objectId, time, this.callStackAsList(), ObjectStaleness.ObjectType.FUNCTION);
        this.insert(iid, prototypeId, time, this.callStackAsList(), ObjectStaleness.ObjectType.PROTOTYPE);
    }

    @Override
    public void unreachableObject(int iid, int objectId, long time, int shallowSize) {
        long staleness;
        ObjectStaleness i = this.staleness.get(objectId);
        assert (i != null);
        i.unreachableTime = time;
        i.unreachableSite = iid;
        if (this.domParent2Children.containsKey(objectId)) {
            i.lastUseTime = time;
            i.lastUseSite = iid;
            this.domParent2Children.remove(objectId);
            this.domChild2ParentCount.remove(objectId);
        }
        if ((staleness = time - (i.lastUseTime == -20L ? i.creationTime : i.lastUseTime)) < 0L) {
            staleness = 0L;
            i.unreachableSite = -1;
            i.unreachableTime = i.lastUseTime;
            if (System.getProperty("testing", "").equals("yes")) {
                this.lackingModels.add(objectId);
            }
        }
        assert (staleness >= 0L);
        i.staleness = staleness;
        i.shallowSize = shallowSize + 1;
    }

    @Override
    public void unreachableContext(int iid, Context ctx, long time) {
    }

    @Override
    public void lastUse(int objectId, int iid, long time) {
        if (objectId == 1) {
            return;
        }
        ObjectStaleness i = this.staleness.get(objectId);
        assert (i != null) : String.format("No create: iid : %s objectId : %d time : %d", this.iidMap.get(iid).toString(), objectId, time);
        if (i.type != ObjectStaleness.ObjectType.DOM || time > i.lastUseTime) {
            i.lastUseTime = time;
            i.lastUseSite = iid;
            if (i.unreachableTime != -20L) {
                if (i.unreachableTime > i.lastUseTime) {
                    i.staleness = i.unreachableTime - i.lastUseTime;
                } else {
                    i.unreachableTime = i.lastUseTime;
                    i.unreachableSite = -20;
                    i.staleness = 0L;
                }
                assert (i.staleness >= 0L) : i.toMap(this.iidMap, true, true).toString() + " IID " + i.iid;
            }
        }
    }

    @Override
    public Staleness endExecution(long time) {
        if (System.getProperty("testing", "").equals("yes") && !this.lackingModels.isEmpty()) {
            System.out.println("The following objects had lastUse occur AFTER unreachability");
            Collections.sort(this.lackingModels);
            for (Integer i : this.lackingModels) {
                System.out.println(i);
            }
        }
        Collection<ObjectStaleness> values = this.staleness.values();
        HashMap info = HashMapFactory.make();
        for (ObjectStaleness o : values) {
            List l = MapUtil.findOrCreateList((Map)info, (Object)o.iid);
            l.add(o);
        }
        return new Staleness(info, this.functionTrace, this.iidMap, System.getProperty("verbosecallstack", "").equals("yes"));
    }

    @Override
    public void domRoot(int nodeId) {
        this.domParent2Children.put(nodeId, HashSetFactory.make());
    }

    @Override
    public void addDOMChild(int parentId, int childId, long time) {
        Set<Integer> children = this.domParent2Children.get(parentId);
        if (children != null) {
            children.add(childId);
            if (!this.domParent2Children.containsKey(childId)) {
                this.domParent2Children.put(childId, HashSetFactory.make());
            }
            this.incDomParentCount(childId);
        }
    }

    private void incDomParentCount(int childId) {
        int curCount = this.domChild2ParentCount.containsKey(childId) ? this.domChild2ParentCount.get(childId) : 0;
        this.domChild2ParentCount.put(childId, ++curCount);
    }

    @Override
    public void removeDOMChild(int parentId, int childId, long time) {
        Set<Integer> children = this.domParent2Children.get(parentId);
        if (children != null && children.contains(childId)) {
            children.remove(childId);
            LinkedList<Integer> worklist = new LinkedList<Integer>();
            worklist.push(childId);
            while (!worklist.isEmpty()) {
                Integer curNode = (Integer)worklist.removeFirst();
                int parentCount = this.decDOMParentCount(curNode);
                if (parentCount != 0) continue;
                ObjectStaleness objectStaleness = this.staleness.get(curNode);
                objectStaleness.lastUseTime = time;
                objectStaleness.lastUseSite = -50L;
                Set<Integer> curChildren = this.domParent2Children.get(curNode);
                assert (curChildren != null);
                worklist.addAll(curChildren);
                this.domParent2Children.remove(curNode);
            }
        }
    }

    private int decDOMParentCount(int nodeId) {
        Integer curCount = this.domChild2ParentCount.get(nodeId);
        assert (curCount != null) : "no parent count for node " + nodeId;
        int decCount = curCount - 1;
        if (decCount == 0) {
            this.domChild2ParentCount.remove(nodeId);
        }
        return decCount;
    }

    @Override
    public void putField(int iid, int baseId, String offset, int objectId) {
    }

    @Override
    public void write(int iid, String name, int objectId) {
    }

    @Override
    public void declare(int iid, String name, int objectId) {
    }

    @Override
    public void updateIID(int objId, int newIID) {
        ObjectStaleness extantStaleness = this.staleness.get(objId);
        assert (extantStaleness != null);
        this.staleness.put(objId, extantStaleness.updateIID(newIID, this.callStackAsList()));
    }

    @Override
    public void returnStmt(int objId) {
    }

    @Override
    public void debug(int iid, int oid) {
    }

    @Override
    public void scriptEnter(int iid, String filename) {
    }

    @Override
    public void scriptExit(int iid) {
    }

    @Override
    public void topLevelFlush(int iid) {
    }

    @Override
    public void addToChildSet(int iid, int parentId, String name, int childId) {
    }

    @Override
    public void removeFromChildSet(int iid, int parentId, String name, int childId) {
    }

    private static enum EntryOrExit {
        ENTRY,
        EXIT;

    }
}

