/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.useful;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kr.ac.kaist.jsaf.useful.Empty;
import kr.ac.kaist.jsaf.useful.Fn;
import kr.ac.kaist.jsaf.useful.PureList;

public class Cons<T>
extends PureList<T> {
    private final T _first;
    private final PureList<T> _rest;
    private int _hashCode;
    private boolean _hasHashCode = false;

    public Cons(T in_first, PureList<T> in_rest) {
        if (in_first == null) {
            throw new IllegalArgumentException("Parameter 'first' to the Cons constructor was null. This class may not have null field values.");
        }
        this._first = in_first;
        if (in_rest == null) {
            throw new IllegalArgumentException("Parameter 'rest' to the Cons constructor was null. This class may not have null field values.");
        }
        this._rest = in_rest;
    }

    public final T getFirst() {
        return this._first;
    }

    public final PureList<T> getRest() {
        return this._rest;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return 1 + this.getRest().size();
    }

    @Override
    public <U> PureList<U> map(Fn<T, U> fn) {
        return this.getRest().map(fn).cons(fn.apply(this.getFirst()));
    }

    @Override
    public boolean contains(T candidate) {
        return this.getFirst().equals(candidate) || this.getRest().contains(candidate);
    }

    @Override
    public PureList<T> append(PureList<T> that) {
        return this.getRest().append(that).cons(this.getFirst());
    }

    @Override
    public PureList<T> reverse() {
        return this.reverse(new Empty());
    }

    @Override
    public PureList<T> reverse(PureList<T> result) {
        return this.getRest().reverse(result.cons(this.getFirst()));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        Cons casted = (Cons)obj;
        if (!this.getFirst().equals(casted.getFirst())) {
            return false;
        }
        return this.getRest().equals(casted.getRest());
    }

    protected int generateHashCode() {
        int code = this.getClass().hashCode();
        code ^= this.getFirst().hashCode();
        return code ^= this.getRest().hashCode();
    }

    public final int hashCode() {
        if (!this._hasHashCode) {
            this._hashCode = this.generateHashCode();
            this._hasHashCode = true;
        }
        return this._hashCode;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private PureList<T> current;
            {
                this.current = Cons.this;
            }

            @Override
            public boolean hasNext() {
                return !this.current.isEmpty();
            }

            @Override
            public T next() {
                if (this.current.isEmpty()) {
                    throw new NoSuchElementException("Attempt to take next at end of iterator");
                }
                Cons _current = (Cons)this.current;
                this.current = _current.getRest();
                return _current.getFirst();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Attempt to remove from iterator on a PureList");
            }
        };
    }
}

