// Generated by CoffeeScript 1.8.0

/*
convert data to CSV format for easy import into spreadsheets
 */

(function() {
  var i18n, sloc;

  sloc = require('../sloc');

  i18n = require('../i18n');

  module.exports = function(data, options) {
    var f, k, lineize, lines, s, _i, _len, _ref;
    if (options == null) {
      options = {};
    }
    if (data == null) {
      return console.error("Error: missing data");
    }
    lines = "" + i18n.en.Path + "," + (((function() {
      var _i, _len, _ref, _results;
      _ref = sloc.keys;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        k = _ref[_i];
        _results.push(i18n.en[k]);
      }
      return _results;
    })()).join(',')) + "\n";
    lineize = function(t) {
      return ((function() {
        var _i, _len, _ref, _results;
        _ref = sloc.keys;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          k = _ref[_i];
          _results.push(t[k]);
        }
        return _results;
      })()).join(',');
    };
    if (options.details) {
      _ref = data.files;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        f = _ref[_i];
        if (f.stats != null) {
          lines += "" + f.path + "," + (lineize(f.stats)) + "\n";
        }
      }
    } else if ((s = data.summary) != null) {
      lines += i18n.en.Total + ',' + lineize(s);
    }
    if (lines[lines.length - 1] === '\n') {
      lines = lines.slice(0, -1);
    }
    return lines;
  };

}).call(this);
