/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.utils.uri;

public class URIHandling {
    public static String encodeURIString = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'();/?:@&=+$,#";
    public static String encodeURIComponentString = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()";
    public static String decodeURIString = ";/?:@&=+$,#";
    public static String decodeURIComponentString = "";

    private static int oneUcs4ToUtf8Char(byte[] utf8Buffer, int ucs4Char) {
        int utf8Length = 1;
        if ((ucs4Char & 0xFFFFFF80) == 0) {
            utf8Buffer[0] = (byte)ucs4Char;
        } else {
            int a = ucs4Char >>> 11;
            utf8Length = 2;
            while (a != 0) {
                a >>>= 5;
                ++utf8Length;
            }
            int i = utf8Length;
            while (--i > 0) {
                utf8Buffer[i] = (byte)(ucs4Char & 0x3F | 0x80);
                ucs4Char >>>= 6;
            }
            utf8Buffer[0] = (byte)(256 - (1 << 8 - utf8Length) + ucs4Char);
        }
        return utf8Length;
    }

    private static char toHexChar(int i) {
        return (char)(i < 10 ? i + 48 : i - 10 + 65);
    }

    public static String encode(String string, String unescapedSet) {
        byte[] Octets = null;
        int strLen = string.length();
        StringBuffer R = null;
        for (int k = 0; k < strLen; ++k) {
            int V;
            int C = string.charAt(k);
            if (unescapedSet.indexOf(C) >= 0) {
                if (R == null) continue;
                R.append((char)C);
                continue;
            }
            if (R == null) {
                R = new StringBuffer(strLen + 3);
                R.append(string);
                R.setLength(k);
                Octets = new byte[6];
            }
            if (56320 <= C && C <= 57343) {
                return null;
            }
            if (C < 55296 || 56319 < C) {
                V = C;
            } else {
                if (++k == strLen) {
                    return null;
                }
                char kChar = string.charAt(k);
                if ('\udc00' > kChar || kChar > '\udfff') {
                    return null;
                }
                V = (C - 55296 << 10) + (kChar - 56320) + 65536;
            }
            int L = URIHandling.oneUcs4ToUtf8Char(Octets, V);
            for (int j = 0; j < L; ++j) {
                int jOctet = 0xFF & Octets[j];
                R.append('%');
                R.append(URIHandling.toHexChar(jOctet >>> 4));
                R.append(URIHandling.toHexChar(jOctet & 0xF));
            }
        }
        return R == null ? string : R.toString();
    }

    private static int unHex(char c) {
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        return -1;
    }

    private static int unHex(char c1, char c2) {
        int i1 = URIHandling.unHex(c1);
        int i2 = URIHandling.unHex(c2);
        if (i1 >= 0 && i2 >= 0) {
            return i1 << 4 | i2;
        }
        return -1;
    }

    public static String decode(String str, String reservedSet) {
        int bufTop = 0;
        int strLen = str.length();
        char[] R = null;
        int k = 0;
        while (k < strLen) {
            char C = str.charAt(k);
            if (C != '%') {
                if (R != null) {
                    R[bufTop++] = C;
                }
                ++k;
                continue;
            }
            if (R == null) {
                R = new char[strLen];
                str.getChars(0, k, R, 0);
                bufTop = k;
            }
            int start = k;
            if (k + 3 > strLen) {
                return null;
            }
            int B = URIHandling.unHex(str.charAt(k + 1), str.charAt(k + 2));
            if (B < 0) {
                return null;
            }
            k += 3;
            if ((B & 0x80) == 0) {
                C = (char)B;
            } else {
                int minUcs4Char;
                int Octets;
                int n;
                if ((B & 0xC0) == 128) {
                    return null;
                }
                if ((B & 0x20) == 0) {
                    n = 1;
                    Octets = B & 0x1F;
                    minUcs4Char = 128;
                } else if ((B & 0x10) == 0) {
                    n = 2;
                    Octets = B & 0xF;
                    minUcs4Char = 2048;
                } else if ((B & 8) == 0) {
                    n = 3;
                    Octets = B & 7;
                    minUcs4Char = 65536;
                } else if ((B & 4) == 0) {
                    n = 4;
                    Octets = B & 3;
                    minUcs4Char = 0x200000;
                } else if ((B & 2) == 0) {
                    n = 5;
                    Octets = B & 1;
                    minUcs4Char = 0x4000000;
                } else {
                    return null;
                }
                if (k + 3 * n > strLen) {
                    return null;
                }
                for (int j = 0; j != n; ++j) {
                    if (str.charAt(k) != '%') {
                        return null;
                    }
                    B = URIHandling.unHex(str.charAt(k + 1), str.charAt(k + 2));
                    if (B < 0 || (B & 0xC0) != 128) {
                        return null;
                    }
                    Octets = Octets << 6 | B & 0x3F;
                    k += 3;
                }
                if (Octets < minUcs4Char || Octets == 65534 || Octets == 65535) {
                    Octets = 65533;
                }
                if (Octets >= 65536) {
                    if ((Octets -= 65536) > 1048575) {
                        return null;
                    }
                    char H = (char)((Octets >>> 10) + 55296);
                    C = (char)((Octets & 0x3FF) + 56320);
                    R[bufTop++] = H;
                } else {
                    C = (char)Octets;
                }
            }
            if (reservedSet.indexOf(C) >= 0) {
                for (int x = start; x != k; ++x) {
                    R[bufTop++] = str.charAt(x);
                }
                continue;
            }
            R[bufTop++] = C;
        }
        return R == null ? str : new String(R, 0, bufTop);
    }
}

