/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.referencecounter.heap;

import com.samsung.memoryanalysis.referencecounter.heap.ContextOrObjectId;
import com.samsung.memoryanalysis.referencecounter.heap.HeapEdge;

public class NamedMultiEdge
implements HeapEdge {
    private final ContextOrObjectId parent;
    private final String name;
    private final ContextOrObjectId child;

    public NamedMultiEdge(ContextOrObjectId parent, String name, ContextOrObjectId child) {
        this.parent = parent;
        this.name = name;
        this.child = child;
    }

    @Override
    public ContextOrObjectId getFrom() {
        return this.parent;
    }

    public ContextOrObjectId getChild() {
        return this.child;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.child == null ? 0 : this.child.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedMultiEdge other = (NamedMultiEdge)obj;
        if (this.child == null ? other.child != null : !this.child.equals(other.child)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    public String toString() {
        return this.name;
    }
}

