/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jsa.safe.bugdetecter.preferences;

import java.util.HashMap;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.tizen.web.jsa.safe.bugdetecter.preferences.Description;
import org.tizen.web.jsa.safe.bugdetecter.preferences.OSChecker;
import org.tizen.web.jsa.safe.bugdetecter.preferences.Settings;

public class RulePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text descriptionText;
    private Table webAPIusageTable;
    private Table codingRuleTable;
    private Shell parentShell = null;
    private Shell tooltipShell = null;
    private Label checkBoxTooltip = null;
    private HashMap<String, String> ruleTable = new HashMap();

    public RulePreferencePage() {
        this.ruleTable.put("Accessing undefined API", "30");
        this.ruleTable.put("Wrong arguments number", "31");
        this.ruleTable.put("Missing error handling", "32");
        this.ruleTable.put("Missing exception handling", "33");
        this.ruleTable.put("Wrong argument type", "34");
        this.ruleTable.put("Wrong dictionary type", "36");
        this.ruleTable.put("API version compatibility", "38");
        this.ruleTable.put("API privilege missing", "39");
        this.ruleTable.put("Use var to declare variables", "51");
        this.ruleTable.put("Don't capture variables in functions", "52");
        this.ruleTable.put("Don't declare arguments Array in functions", "50");
        this.ruleTable.put("Don't use extra semicolon", "53");
        this.ruleTable.put("Don't use the delete keyword", "54");
        this.ruleTable.put("Don't use multi-line string literals", "55");
        this.ruleTable.put("Don't use Array or Object constructors", "56");
        this.ruleTable.put("Don't modify prototypes of built-in objects", "57");
        this.ruleTable.put("Don't convert wrapper objects to primitives", "58");
        this.ruleTable.put("Don't use for-in with arrays", "59");
        this.ruleTable.put("Don't use double-quoted strings", "60");
        this.ruleTable.put("Don't omit semicolons", "61");
        this.ruleTable.put("Don't begin with operators", "62");
        this.ruleTable.put("Don't end with commas in literals", "63");
        this.ruleTable.put("Don't use wrong opening brace", "64");
        this.ruleTable.put("Don't use unclosed Strings", "67");
        this.ruleTable.put("Don't use unclosed Comments", "68");
        this.ruleTable.put("Don't use unclosed Braces", "69");
    }

    public Control createContents(Composite parent) {
        this.parentShell = parent.getShell();
        Composite container = new Composite(parent, 0);
        GridLayout gl_container = new GridLayout(1, false);
        gl_container.marginHeight = 0;
        gl_container.marginWidth = 0;
        gl_container.horizontalSpacing = 0;
        container.setLayout((Layout)gl_container);
        Label titleDescription = new Label(container, 0);
        GridData gd_titleDescription = new GridData(4, 4, false, false, 1, 1);
        gd_titleDescription.widthHint = OSChecker.isWindows() ? 650 : 790;
        titleDescription.setLayoutData((Object)gd_titleDescription);
        titleDescription.setText("The JavaScript Analyzer(JSA) is an analysis tool which helps to find dangerous code problems for JavaScript.\r\n\r\nThe selected rules will check when analyzing is performed : ");
        Composite ruleList = new Composite(container, 0);
        ruleList.setLayout((Layout)new FillLayout(256));
        GridData gd_ruleList = new GridData(4, 4, true, true, 1, 1);
        gd_ruleList.heightHint = 300;
        ruleList.setLayoutData((Object)gd_ruleList);
        ruleList.setBounds(0, 0, 64, 64);
        TabFolder tabFolder = new TabFolder(ruleList, 0);
        TabItem tbtmWebApiUsage = new TabItem(tabFolder, 0);
        tbtmWebApiUsage.setText("Web API Usage");
        Composite compositeWebAPIusageTable = new Composite((Composite)tabFolder, 0);
        tbtmWebApiUsage.setControl((Control)compositeWebAPIusageTable);
        GridLayout gl_compositeWebAPIusageTable = new GridLayout(2, false);
        gl_compositeWebAPIusageTable.marginWidth = 0;
        compositeWebAPIusageTable.setLayout((Layout)gl_compositeWebAPIusageTable);
        Label lblNewLabel_1 = new Label(compositeWebAPIusageTable, 0);
        GridData gd_lblNewLabel_1 = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel_1.horizontalIndent = 5;
        lblNewLabel_1.setLayoutData((Object)gd_lblNewLabel_1);
        lblNewLabel_1.setText("The following rules notify you, when the APIs are used improperly.");
        new Label(compositeWebAPIusageTable, 0);
        this.webAPIusageTable = new Table(compositeWebAPIusageTable, 67616);
        this.webAPIusageTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.webAPIusageTable.setHeaderVisible(true);
        this.webAPIusageTable.setLinesVisible(true);
        TableColumn tblclmnRule_1 = new TableColumn(this.webAPIusageTable, 0);
        tblclmnRule_1.setWidth(350);
        tblclmnRule_1.setText("Rule");
        TableColumn tblclmnSeverity_1 = new TableColumn(this.webAPIusageTable, 0);
        tblclmnSeverity_1.setWidth(100);
        tblclmnSeverity_1.setText("Severity");
        Composite compositeWebBtn = new Composite(compositeWebAPIusageTable, 0);
        compositeWebBtn.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        GridLayout gl_compositeWebBtn = new GridLayout(1, false);
        gl_compositeWebBtn.marginHeight = 0;
        compositeWebBtn.setLayout((Layout)gl_compositeWebBtn);
        Button btnWebEnable = new Button(compositeWebBtn, 0);
        GridData gd_btnWebEnable = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnWebEnable.widthHint = 100;
        btnWebEnable.setLayoutData((Object)gd_btnWebEnable);
        btnWebEnable.setText("Enable All");
        Button btnWebDisable = new Button(compositeWebBtn, 0);
        GridData gd_btnWebDisable = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnWebDisable.widthHint = 100;
        btnWebDisable.setLayoutData((Object)gd_btnWebDisable);
        btnWebDisable.setText("Disable All");
        TabItem tbtmCodingRule = new TabItem(tabFolder, 0);
        tbtmCodingRule.setText("Coding Rule");
        Composite compositeCodingRule = new Composite((Composite)tabFolder, 0);
        tbtmCodingRule.setControl((Control)compositeCodingRule);
        GridLayout gl_compositeCodingRule = new GridLayout(2, false);
        gl_compositeCodingRule.marginWidth = 0;
        compositeCodingRule.setLayout((Layout)gl_compositeCodingRule);
        Label lblNewLabel_2 = new Label(compositeCodingRule, 0);
        GridData gd_lblNewLabel_2 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel_2.horizontalIndent = 5;
        lblNewLabel_2.setLayoutData((Object)gd_lblNewLabel_2);
        lblNewLabel_2.setText("The following rules to help in writing better JavaScript code.");
        new Label(compositeCodingRule, 0);
        this.codingRuleTable = new Table(compositeCodingRule, 67616);
        this.codingRuleTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.codingRuleTable.setHeaderVisible(true);
        this.codingRuleTable.setLinesVisible(true);
        TableColumn tblclmnRule = new TableColumn(this.codingRuleTable, 0);
        tblclmnRule.setWidth(330);
        tblclmnRule.setText("Rule");
        TableColumn tblclmnSeverity = new TableColumn(this.codingRuleTable, 0);
        tblclmnSeverity.setWidth(120);
        tblclmnSeverity.setText("Severity");
        Composite compositeCodingBtn = new Composite(compositeCodingRule, 0);
        compositeCodingBtn.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        GridLayout gl_compositeCodingBtn = new GridLayout(1, false);
        gl_compositeCodingBtn.marginHeight = 0;
        compositeCodingBtn.setLayout((Layout)gl_compositeCodingBtn);
        Button btnCodingEnable = new Button(compositeCodingBtn, 0);
        GridData gd_btnCodingEnable = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnCodingEnable.widthHint = 100;
        btnCodingEnable.setLayoutData((Object)gd_btnCodingEnable);
        btnCodingEnable.setText("Enable All");
        Button btnCodingDisable = new Button(compositeCodingBtn, 0);
        GridData gd_btnCodingDisable = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnCodingDisable.widthHint = 100;
        btnCodingDisable.setLayoutData((Object)gd_btnCodingDisable);
        btnCodingDisable.setText("Disable All");
        Composite description = new Composite(container, 0);
        GridLayout gl_description = new GridLayout(1, false);
        gl_description.marginWidth = 0;
        gl_description.marginHeight = 0;
        description.setLayout((Layout)gl_description);
        GridData gd_description = new GridData(4, 4, true, true, 1, 1);
        gd_description.heightHint = 180;
        description.setLayoutData((Object)gd_description);
        description.setBounds(0, 0, 64, 64);
        Label lblNewLabel = new Label(description, 0);
        lblNewLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblNewLabel.setText("Description :");
        this.descriptionText = new Text(description, 2562);
        this.descriptionText.setBackground(Display.getCurrent().getSystemColor(1));
        this.descriptionText.setEditable(false);
        GridData gd_descriptionText = new GridData(4, 4, true, true, 1, 1);
        gd_descriptionText.widthHint = 590;
        this.descriptionText.setLayoutData((Object)gd_descriptionText);
        this.initWebAPIRuleTabel(this.webAPIusageTable);
        this.initCodingRuleTabel(this.codingRuleTable);
        this.setTableCheckEnable(Settings.getStore().getString("SELECTED_RULE_CHECKER"));
        this.addSelectionListenerBtn(btnWebEnable, btnWebDisable, btnCodingEnable, btnCodingDisable);
        this.addListenerTable();
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    public void setPreferenceSetting() {
        TableItem[] cItems;
        TableItem[] wItems;
        StringBuilder sb = new StringBuilder();
        TableItem[] tableItemArray = wItems = this.webAPIusageTable.getItems();
        int n = wItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem row = tableItemArray[n2];
            if (row.getChecked()) {
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append(this.ruleTable.get(row.getText(0)));
            }
            ++n2;
        }
        TableItem[] tableItemArray2 = cItems = this.codingRuleTable.getItems();
        int n3 = cItems.length;
        n = 0;
        while (n < n3) {
            TableItem row = tableItemArray2[n];
            if (row.getChecked()) {
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append(this.ruleTable.get(row.getText(0)));
            }
            ++n;
        }
        Settings.getStore().setValue("SELECTED_RULE_CHECKER", sb.toString());
    }

    public void setTableCheckEnable(String numbers) {
        TableItem[] cItems;
        int n;
        String[] ruleNumber = Settings.getRuleNumbers(numbers);
        if (ruleNumber != null) {
            String[] stringArray = ruleNumber;
            n = ruleNumber.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem[] cItems2;
                TableItem[] wItems;
                String rule = stringArray[n2];
                TableItem[] tableItemArray = wItems = this.webAPIusageTable.getItems();
                int n3 = wItems.length;
                int n4 = 0;
                while (n4 < n3) {
                    TableItem row = tableItemArray[n4];
                    if (rule.equals(this.ruleTable.get(row.getText(0)))) {
                        row.setChecked(true);
                    }
                    ++n4;
                }
                TableItem[] tableItemArray2 = cItems2 = this.codingRuleTable.getItems();
                int n5 = cItems2.length;
                n3 = 0;
                while (n3 < n5) {
                    TableItem row = tableItemArray2[n3];
                    if (rule.equals(this.ruleTable.get(row.getText(0)))) {
                        row.setChecked(true);
                    }
                    ++n3;
                }
                ++n2;
            }
        } else {
            TableItem[] cItems3;
            TableItem[] wItems;
            TableItem[] tableItemArray = wItems = this.webAPIusageTable.getItems();
            int n6 = wItems.length;
            int n7 = 0;
            while (n7 < n6) {
                TableItem row = tableItemArray[n7];
                row.setChecked(false);
                ++n7;
            }
            TableItem[] tableItemArray3 = cItems3 = this.codingRuleTable.getItems();
            int n8 = cItems3.length;
            n6 = 0;
            while (n6 < n8) {
                TableItem row = tableItemArray3[n6];
                row.setChecked(false);
                ++n6;
            }
        }
        TableItem[] tableItemArray = cItems = this.codingRuleTable.getItems();
        int n9 = cItems.length;
        n = 0;
        while (n < n9) {
            TableItem row = tableItemArray[n];
            if ("67".equals(this.ruleTable.get(row.getText(0)))) {
                row.setChecked(true);
            }
            if ("68".equals(this.ruleTable.get(row.getText(0)))) {
                row.setChecked(true);
            }
            if ("69".equals(this.ruleTable.get(row.getText(0)))) {
                row.setChecked(true);
            }
            ++n;
        }
    }

    public void addListenerTable() {
        this.webAPIusageTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = RulePreferencePage.this.webAPIusageTable.getSelection();
                if (selection.length != 0) {
                    RulePreferencePage.this.descriptionText.setText(Description.getRuleDescription((String)RulePreferencePage.this.ruleTable.get(selection[0].getText(0))));
                }
            }
        });
        this.codingRuleTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String ruleNum;
                TableItem row = (TableItem)event.item;
                if (event.detail == 0) {
                    RulePreferencePage.this.descriptionText.setText(Description.getRuleDescription((String)RulePreferencePage.this.ruleTable.get(row.getText(0))));
                }
                if ((ruleNum = (String)RulePreferencePage.this.ruleTable.get(row.getText(0))).equals("67") || ruleNum.equals("68") || ruleNum.equals("69")) {
                    row.setChecked(true);
                }
            }
        });
        Listener tooltipListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: {
                        if (RulePreferencePage.this.tooltipShell == null) break;
                        RulePreferencePage.this.tooltipShell.setVisible(false);
                        RulePreferencePage.this.tooltipShell.dispose();
                        RulePreferencePage.this.tooltipShell = null;
                        RulePreferencePage.this.checkBoxTooltip = null;
                        break;
                    }
                    case 32: {
                        String ruleNum;
                        TableItem item = RulePreferencePage.this.codingRuleTable.getItem(new Point(event.x, event.y));
                        if (item == null || !(ruleNum = (String)RulePreferencePage.this.ruleTable.get(item.getText(0))).equals("67") && !ruleNum.equals("68") && !ruleNum.equals("69")) break;
                        if (RulePreferencePage.this.tooltipShell != null && !RulePreferencePage.this.tooltipShell.isDisposed()) {
                            RulePreferencePage.this.tooltipShell.dispose();
                        }
                        RulePreferencePage.this.tooltipShell = new Shell(RulePreferencePage.this.parentShell, 16388);
                        RulePreferencePage.this.tooltipShell.setLayout((Layout)new FillLayout());
                        RulePreferencePage.this.checkBoxTooltip = new Label((Composite)RulePreferencePage.this.tooltipShell, 0);
                        RulePreferencePage.this.checkBoxTooltip.setForeground(Display.getDefault().getSystemColor(28));
                        RulePreferencePage.this.checkBoxTooltip.setBackground(Display.getDefault().getSystemColor(29));
                        RulePreferencePage.this.checkBoxTooltip.setText(" Can't turn off Syntax Error Rule.");
                        Point size = RulePreferencePage.this.tooltipShell.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point pt = RulePreferencePage.this.codingRuleTable.toDisplay(rect.x, rect.y);
                        RulePreferencePage.this.tooltipShell.setBounds(pt.x, pt.y - 10, size.x + 5, size.y);
                        RulePreferencePage.this.tooltipShell.setVisible(true);
                    }
                }
            }
        };
        this.codingRuleTable.addListener(32, tooltipListener);
        this.codingRuleTable.addListener(5, tooltipListener);
    }

    public void addSelectionListenerBtn(Button btnWebEnable, Button btnWebDisable, Button btnCodingEnable, Button btnCodingDisable) {
        btnWebEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                TableItem[] tableItemArray = items = RulePreferencePage.this.webAPIusageTable.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem rule = tableItemArray[n2];
                    rule.setChecked(true);
                    ++n2;
                }
            }
        });
        btnWebDisable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                TableItem[] tableItemArray = items = RulePreferencePage.this.webAPIusageTable.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem rule = tableItemArray[n2];
                    rule.setChecked(false);
                    ++n2;
                }
            }
        });
        btnCodingEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                TableItem[] tableItemArray = items = RulePreferencePage.this.codingRuleTable.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem rule = tableItemArray[n2];
                    rule.setChecked(true);
                    ++n2;
                }
            }
        });
        btnCodingDisable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                TableItem[] tableItemArray = items = RulePreferencePage.this.codingRuleTable.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem rule = tableItemArray[n2];
                    String numId = (String)RulePreferencePage.this.ruleTable.get(rule.getText(0));
                    if (!("67".equals(numId) || "68".equals(numId) || "69".equals(numId))) {
                        rule.setChecked(false);
                    }
                    ++n2;
                }
            }
        });
    }

    public void initCodingRuleTabel(Table codingRuleTable) {
        TableItem rule18 = new TableItem(codingRuleTable, 0);
        rule18.setText(new String[]{"Don't use unclosed Strings", "High (Syntax Error)", "67"});
        TableItem rule19 = new TableItem(codingRuleTable, 0);
        rule19.setText(new String[]{"Don't use unclosed Comments", "High (Syntax Error)", "68"});
        TableItem rule20 = new TableItem(codingRuleTable, 0);
        rule20.setText(new String[]{"Don't use unclosed Braces", "High (Syntax Error)", "69"});
        TableItem rule02 = new TableItem(codingRuleTable, 0);
        rule02.setText(new String[]{"Use var to declare variables", "High", "51"});
        TableItem rule03 = new TableItem(codingRuleTable, 0);
        rule03.setText(new String[]{"Don't capture variables in functions", "Medium", "52"});
        TableItem rule01 = new TableItem(codingRuleTable, 0);
        rule01.setText(new String[]{"Don't declare arguments Array in functions", "Medium", "50"});
        TableItem rule12 = new TableItem(codingRuleTable, 0);
        rule12.setText(new String[]{"Don't omit semicolons", "Medium", "61"});
        TableItem rule14 = new TableItem(codingRuleTable, 0);
        rule14.setText(new String[]{"Don't end with commas in literals", "Medium", "63"});
        TableItem rule04 = new TableItem(codingRuleTable, 0);
        rule04.setText(new String[]{"Don't use extra semicolon", "Medium", "53"});
        TableItem rule05 = new TableItem(codingRuleTable, 0);
        rule05.setText(new String[]{"Don't use the delete keyword", "Low", "54"});
        TableItem rule06 = new TableItem(codingRuleTable, 0);
        rule06.setText(new String[]{"Don't use multi-line string literals", "Low", "55"});
        TableItem rule07 = new TableItem(codingRuleTable, 0);
        rule07.setText(new String[]{"Don't use Array or Object constructors", "Low", "56"});
        TableItem rule08 = new TableItem(codingRuleTable, 0);
        rule08.setText(new String[]{"Don't modify prototypes of built-in objects", "Low", "57"});
        TableItem rule09 = new TableItem(codingRuleTable, 0);
        rule09.setText(new String[]{"Don't convert wrapper objects to primitives", "Low", "58"});
        TableItem rule10 = new TableItem(codingRuleTable, 0);
        rule10.setText(new String[]{"Don't use for-in with arrays", "Low", "59"});
        TableItem rule11 = new TableItem(codingRuleTable, 0);
        rule11.setText(new String[]{"Don't use double-quoted strings", "Low", "60"});
        TableItem rule13 = new TableItem(codingRuleTable, 0);
        rule13.setText(new String[]{"Don't begin with operators", "Low", "62"});
        TableItem rule15 = new TableItem(codingRuleTable, 0);
        rule15.setText(new String[]{"Don't use wrong opening brace", "Low", "64"});
    }

    public void initWebAPIRuleTabel(Table webAPIusageTable) {
        TableItem rule01 = new TableItem(webAPIusageTable, 0);
        rule01.setText(new String[]{"Accessing undefined API", "High", "30"});
        TableItem rule02 = new TableItem(webAPIusageTable, 0);
        rule02.setText(new String[]{"Wrong arguments number", "High", "31"});
        TableItem rule03 = new TableItem(webAPIusageTable, 0);
        rule03.setText(new String[]{"Missing error handling", "Medium", "32"});
        TableItem rule04 = new TableItem(webAPIusageTable, 0);
        rule04.setText(new String[]{"Missing exception handling", "Medium", "33"});
        TableItem rule05 = new TableItem(webAPIusageTable, 0);
        rule05.setText(new String[]{"Wrong argument type", "High", "34"});
        TableItem rule06 = new TableItem(webAPIusageTable, 0);
        rule06.setText(new String[]{"Wrong dictionary type", "High", "36"});
        TableItem rule07 = new TableItem(webAPIusageTable, 0);
        rule07.setText(new String[]{"API version compatibility", "High", "38"});
        TableItem rule08 = new TableItem(webAPIusageTable, 0);
        rule08.setText(new String[]{"API privilege missing", "High", "39"});
    }

    public void setDefaultsRule() {
        this.setTableCheckEnable(Settings.getStore().getString("SELECTED_RULE_CHECKER"));
    }

    protected void performDefaults() {
        super.performDefaults();
        this.setDefaultsRule();
    }

    public boolean performOk() {
        this.setPreferenceSetting();
        Settings.writeConfigFile();
        return super.performOk();
    }
}

